/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.audit.AuditLogger$;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.audit.NoOpAuditProvider$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001B\u0001\u0003\u00015\u0011Q\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-u\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0006\u0002\u0011\u001d,w\u000e^8pYNL!\u0001\b\r\u0003'\u0011\u000bG/Y*u_J,g)Y2u_JL8\u000b]5\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t!\u0001\u0003\u0005.\u0001!\u0015\r\u0011\"\u0003/\u0003A9Gn\u001c2bY\u000e{gN\\3di&|g.F\u00010!\t\u0001\u0004(D\u00012\u0015\t\u00114'\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000bQR!!\u000e\u001c\u0002\r!\fGm\\8q\u0015\t9$\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003sE\u0012!bQ8o]\u0016\u001cG/[8o\u0011!Y\u0004\u0001#A!B\u0013y\u0013!E4m_\n\fGnQ8o]\u0016\u001cG/[8oA!)Q\b\u0001C!}\u0005\u00112M]3bi\u0016tUm\u001e#bi\u0006\u001cFo\u001c:f)\ty$\t\u0005\u0002\u0018\u0001&\u0011\u0011\t\u0007\u0002\n\t\u0006$\u0018m\u0015;pe\u0016DQa\u0011\u001fA\u0002\u0011\u000ba\u0001]1sC6\u001c\b\u0003B#I\u0015Rk\u0011A\u0012\u0006\u0003\u000fJ\tA!\u001e;jY&\u0011\u0011J\u0012\u0002\u0004\u001b\u0006\u0004\bCA&R\u001d\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ak\u0005CA+Y\u001b\u00051&BA,\u0013\u0003\tIw.\u0003\u0002Z-\na1+\u001a:jC2L'0\u00192mK\")1\f\u0001C!9\u0006y1M]3bi\u0016$\u0015\r^1Ti>\u0014X\r\u0006\u0002@;\")1I\u0017a\u0001\t\")q\f\u0001C\tA\u0006q!-^5mI\u0012\u000bG/Y*u_J,GcA1eMB\u00111FY\u0005\u0003G\n\u0011a\u0002\u0013\"bg\u0016$\u0015\r^1Ti>\u0014X\rC\u0003f=\u0002\u0007q&\u0001\u0006d_:tWm\u0019;j_:DQa\u001a0A\u0002!\faaY8oM&<\u0007cA5\u000229\u0011!n\u001e\b\u0003WZt!\u0001\\;\u000f\u00055$hB\u00018t\u001d\ty'/D\u0001q\u0015\t\tH\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002=\u0003\u0011\u0003I\u0018!\u0006%CCN,G)\u0019;b'R|'/\u001a$bGR|'/\u001f\t\u0003Wi4Q!\u0001\u0002\t\u0002m\u001c2A\u001f?\u001e!\taU0\u0003\u0002\u007f\u001b\n1\u0011I\\=SK\u001aDa\u0001\u000b>\u0005\u0002\u0005\u0005A#A=\t\u0013\u0005\u0015!P1A\u0005\u0002\u0005\u001d\u0011a\u0003#jgBd\u0017-\u001f(b[\u0016,\"!!\u0003\u0011\u0007=\tY!\u0003\u0002S!!A\u0011q\u0002>!\u0002\u0013\tI!\u0001\u0007ESN\u0004H.Y=OC6,\u0007\u0005C\u0005\u0002\u0014i\u0014\r\u0011\"\u0001\u0002\b\u0005YA)Z:de&\u0004H/[8o\u0011!\t9B\u001fQ\u0001\n\u0005%\u0011\u0001\u0004#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"CA\u000eu\n\u0007I\u0011AA\u0004\u0003UA%)Y:f\u000f\u0016|W*Z:b!JLgnY5qC2D\u0001\"a\b{A\u0003%\u0011\u0011B\u0001\u0017\u0011\n\u000b7/Z$f_6+7/\u0019)sS:\u001c\u0017\u000e]1mA!I\u00111\u0005>C\u0002\u0013\u0005\u0011qA\u0001\u0013\u0011\n\u000b7/Z$f_6+7/Y&fsR\u000b'\r\u0003\u0005\u0002(i\u0004\u000b\u0011BA\u0005\u0003MA%)Y:f\u000f\u0016|W*Z:b\u0017\u0016LH+\u00192!\u0011)\tYC\u001fb\u0001\n\u00031\u0011qA\u0001\u0013\u0005&<G+\u00192mKB\u000b'/Y7DQ\u0016\u001c7\u000e\u0003\u0005\u00020i\u0004\u000b\u0011BA\u0005\u0003M\u0011\u0015n\u001a+bE2,\u0007+\u0019:b[\u000eCWmY6!\r\u0019\t\u0019D\u001f!\u00026\t!\u0002JQ1tK\u0012\u000bG/Y*u_J,7i\u001c8gS\u001e\u001c\u0012\"!\r}\u0003o\t\u0019&!\u0017\u0011\t\u0005e\u0012Q\n\b\u0005\u0003w\t9E\u0004\u0003\u0002>\u0005\rcb\u00017\u0002@%\u0019\u0011\u0011\t\u0004\u0002\u000b%tG-\u001a=\n\u0007i\t)EC\u0002\u0002B\u0019IA!!\u0013\u0002L\u00059r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/\u001f\u0006\u00045\u0005\u0015\u0013\u0002BA(\u0003#\u0012acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0003\u0013\nY\u0005E\u0002M\u0003+J1!a\u0016N\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001TA.\u0013\tIV\nC\u0006\u0002`\u0005E\"Q3A\u0005\u0002\u0005\u0005\u0014aB2bi\u0006dwnZ\u000b\u0002\u0015\"Q\u0011QMA\u0019\u0005#\u0005\u000b\u0011\u0002&\u0002\u0011\r\fG/\u00197pO\u0002B1\"!\u001b\u00022\tU\r\u0011\"\u0001\u0002l\u0005a!/Z7pi\u00164\u0015\u000e\u001c;feV\u0011\u0011Q\u000e\t\u0004\u0019\u0006=\u0014bAA9\u001b\n9!i\\8mK\u0006t\u0007bCA;\u0003c\u0011\t\u0012)A\u0005\u0003[\nQB]3n_R,g)\u001b7uKJ\u0004\u0003bCA=\u0003c\u0011)\u001a!C\u0001\u0003W\nQbZ3oKJ\fG/Z*uCR\u001c\bbCA?\u0003c\u0011\t\u0012)A\u0005\u0003[\nabZ3oKJ\fG/Z*uCR\u001c\b\u0005C\u0006\u0002\u0002\u0006E\"Q3A\u0005\u0002\u0005\r\u0015!B1vI&$XCAAC!\u0015a\u0015qQAF\u0013\r\tI)\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00111\u000bi)!%\u0002 *K1!a$N\u0005\u0019!V\u000f\u001d7fgA!\u00111SAN\u001b\t\t)J\u0003\u0003\u0002\u0002\u0006]%bAAM\r\u0005)Q\u000f^5mg&!\u0011QTAK\u0005-\tU\u000fZ5u/JLG/\u001a:\u0011\t\u0005M\u0015\u0011U\u0005\u0005\u0003G\u000b)JA\u0007Bk\u0012LG\u000f\u0015:pm&$WM\u001d\u0005\f\u0003O\u000b\tD!E!\u0002\u0013\t))\u0001\u0004bk\u0012LG\u000f\t\u0005\f\u0003W\u000b\tD!f\u0001\n\u0003\ti+\u0001\u0007rk\u0016\u0014\u0018\u0010\u00165sK\u0006$7/\u0006\u0002\u00020B\u0019A*!-\n\u0007\u0005MVJA\u0002J]RD1\"a.\u00022\tE\t\u0015!\u0003\u00020\u0006i\u0011/^3ssRC'/Z1eg\u0002B1\"a/\u00022\tU\r\u0011\"\u0001\u0002>\u0006a\u0011/^3ssRKW.Z8viV\u0011\u0011q\u0018\t\u0006\u0019\u0006\u001d\u0015\u0011\u0019\t\u0004\u0019\u0006\r\u0017bAAc\u001b\n!Aj\u001c8h\u0011-\tI-!\r\u0003\u0012\u0003\u0006I!a0\u0002\u001bE,XM]=US6,w.\u001e;!\u0011-\ti-!\r\u0003\u0016\u0004%\t!!,\u000215\f\u0007PU1oO\u0016\u001c\b+\u001a:FqR,g\u000eZ3e'\u000e\fg\u000eC\u0006\u0002R\u0006E\"\u0011#Q\u0001\n\u0005=\u0016!G7bqJ\u000bgnZ3t!\u0016\u0014X\t\u001f;f]\u0012,GmU2b]\u0002B1\"!6\u00022\tU\r\u0011\"\u0001\u0002l\u0005IAn\\8tK\n\u0013u\u000e\u001f\u0005\f\u00033\f\tD!E!\u0002\u0013\ti'\u0001\u0006m_>\u001cXM\u0011\"pq\u0002B1\"!8\u00022\tU\r\u0011\"\u0001\u0002l\u000591-Y2iS:<\u0007bCAq\u0003c\u0011\t\u0012)A\u0005\u0003[\n\u0001bY1dQ&tw\r\t\u0005\f\u0003K\f\tD!f\u0001\n\u0003\t9/\u0001\u0007bkRD\u0007K]8wS\u0012,'/\u0006\u0002\u0002jB)A*a\"\u0002lB!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r\u001a\t\u0001b]3dkJLG/_\u0005\u0005\u0003k\fyO\u0001\fBkRDwN]5{CRLwN\\:Qe>4\u0018\u000eZ3s\u0011-\tI0!\r\u0003\u0012\u0003\u0006I!!;\u0002\u001b\u0005,H\u000f\u001b)s_ZLG-\u001a:!\u0011-\ti0!\r\u0003\u0016\u0004%\t!a@\u0002\u001d\r|\u0007O]8dKN\u001cxN]+sYV\u0011!\u0011\u0001\t\u0006\u0019\u0006\u001d%1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)\u0019!\u0011\u0002\u001b\u0002\u0005\u0019\u001c\u0018\u0002\u0002B\u0007\u0005\u000f\u0011A\u0001U1uQ\"Y!\u0011CA\u0019\u0005#\u0005\u000b\u0011\u0002B\u0001\u0003=\u0019w\u000e\u001d:pG\u0016\u001c8o\u001c:Ve2\u0004\u0003b\u0002\u0015\u00022\u0011\u0005!Q\u0003\u000b\u0019\u0005/\u0011YB!\b\u0003 \t\u0005\"1\u0005B\u0013\u0005O\u0011ICa\u000b\u0003.\t=\u0002\u0003\u0002B\r\u0003ci\u0011A\u001f\u0005\b\u0003?\u0012\u0019\u00021\u0001K\u0011!\tIGa\u0005A\u0002\u00055\u0004\u0002CA=\u0005'\u0001\r!!\u001c\t\u0011\u0005\u0005%1\u0003a\u0001\u0003\u000bC\u0001\"a+\u0003\u0014\u0001\u0007\u0011q\u0016\u0005\t\u0003w\u0013\u0019\u00021\u0001\u0002@\"A\u0011Q\u001aB\n\u0001\u0004\ty\u000b\u0003\u0005\u0002V\nM\u0001\u0019AA7\u0011!\tiNa\u0005A\u0002\u00055\u0004\u0002CAs\u0005'\u0001\r!!;\t\u0011\u0005u(1\u0003a\u0001\u0005\u0003A!Ba\r\u00022\u0005\u0005I\u0011\u0001B\u001b\u0003\u0011\u0019w\u000e]=\u00151\t]!q\u0007B\u001d\u0005w\u0011iDa\u0010\u0003B\t\r#Q\tB$\u0005\u0013\u0012Y\u0005C\u0005\u0002`\tE\u0002\u0013!a\u0001\u0015\"Q\u0011\u0011\u000eB\u0019!\u0003\u0005\r!!\u001c\t\u0015\u0005e$\u0011\u0007I\u0001\u0002\u0004\ti\u0007\u0003\u0006\u0002\u0002\nE\u0002\u0013!a\u0001\u0003\u000bC!\"a+\u00032A\u0005\t\u0019AAX\u0011)\tYL!\r\u0011\u0002\u0003\u0007\u0011q\u0018\u0005\u000b\u0003\u001b\u0014\t\u0004%AA\u0002\u0005=\u0006BCAk\u0005c\u0001\n\u00111\u0001\u0002n!Q\u0011Q\u001cB\u0019!\u0003\u0005\r!!\u001c\t\u0015\u0005\u0015(\u0011\u0007I\u0001\u0002\u0004\tI\u000f\u0003\u0006\u0002~\nE\u0002\u0013!a\u0001\u0005\u0003A!Ba\u0014\u00022E\u0005I\u0011\u0001B)\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0015+\u0007)\u0013)f\u000b\u0002\u0003XA!!\u0011\fB2\u001b\t\u0011YF\u0003\u0003\u0003^\t}\u0013!C;oG\",7m[3e\u0015\r\u0011\t'T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B3\u00057\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011I'!\r\u0012\u0002\u0013\u0005!1N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iG\u000b\u0003\u0002n\tU\u0003B\u0003B9\u0003c\t\n\u0011\"\u0001\u0003l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003B;\u0003c\t\n\u0011\"\u0001\u0003x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B=U\u0011\t)I!\u0016\t\u0015\tu\u0014\u0011GI\u0001\n\u0003\u0011y(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u0005%\u0006BAX\u0005+B!B!\"\u00022E\u0005I\u0011\u0001BD\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"A!#+\t\u0005}&Q\u000b\u0005\u000b\u0005\u001b\u000b\t$%A\u0005\u0002\t}\u0014AD2paf$C-\u001a4bk2$He\u000e\u0005\u000b\u0005#\u000b\t$%A\u0005\u0002\t-\u0014AD2paf$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0005+\u000b\t$%A\u0005\u0002\t-\u0014AD2paf$C-\u001a4bk2$H%\u000f\u0005\u000b\u00053\u000b\t$%A\u0005\u0002\tm\u0015aD2paf$C-\u001a4bk2$H%\r\u0019\u0016\u0005\tu%\u0006BAu\u0005+B!B!)\u00022E\u0005I\u0011\u0001BR\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\nTC\u0001BSU\u0011\u0011\tA!\u0016\t\u0015\t%\u0016\u0011GA\u0001\n\u0003\n9!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\u000b\u0005[\u000b\t$!A\u0005\u0002\u00055\u0016\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003BY\u0003c\t\t\u0011\"\u0001\u00034\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B[\u0005w\u00032\u0001\u0014B\\\u0013\r\u0011I,\u0014\u0002\u0004\u0003:L\bB\u0003B_\u0005_\u000b\t\u00111\u0001\u00020\u0006\u0019\u0001\u0010J\u0019\t\u0015\t\u0005\u0017\u0011GA\u0001\n\u0003\u0012\u0019-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\r\u0005\u0004\u0003H\n5'QW\u0007\u0003\u0005\u0013T1Aa3N\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0014IM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011\u0019.!\r\u0002\u0002\u0013\u0005!Q[\u0001\tG\u0006tW)];bYR!\u0011Q\u000eBl\u0011)\u0011iL!5\u0002\u0002\u0003\u0007!Q\u0017\u0005\u000b\u00057\f\t$!A\u0005B\tu\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0006B\u0003Bq\u0003c\t\t\u0011\"\u0011\u0003d\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\n!Q!q]A\u0019\u0003\u0003%\tE!;\u0002\r\u0015\fX/\u00197t)\u0011\tiGa;\t\u0015\tu&Q]A\u0001\u0002\u0004\u0011)lB\u0005\u0003pj\f\t\u0011#\u0001\u0003r\u0006!\u0002JQ1tK\u0012\u000bG/Y*u_J,7i\u001c8gS\u001e\u0004BA!\u0007\u0003t\u001aI\u00111\u0007>\u0002\u0002#\u0005!Q_\n\u0007\u0005g\u001490!\u0017\u00117\te(q &\u0002n\u00055\u0014QQAX\u0003\u007f\u000by+!\u001c\u0002n\u0005%(\u0011\u0001B\f\u001b\t\u0011YPC\u0002\u0003~6\u000bqA];oi&lW-\u0003\u0003\u0004\u0002\tm(AE!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocEBq\u0001\u000bBz\t\u0003\u0019)\u0001\u0006\u0002\u0003r\"Q!\u0011\u001dBz\u0003\u0003%)Ea9\t\u0015\r-!1_A\u0001\n\u0003\u001bi!A\u0003baBd\u0017\u0010\u0006\r\u0003\u0018\r=1\u0011CB\n\u0007+\u00199b!\u0007\u0004\u001c\ru1qDB\u0011\u0007GAq!a\u0018\u0004\n\u0001\u0007!\n\u0003\u0005\u0002j\r%\u0001\u0019AA7\u0011!\tIh!\u0003A\u0002\u00055\u0004\u0002CAA\u0007\u0013\u0001\r!!\"\t\u0011\u0005-6\u0011\u0002a\u0001\u0003_C\u0001\"a/\u0004\n\u0001\u0007\u0011q\u0018\u0005\t\u0003\u001b\u001cI\u00011\u0001\u00020\"A\u0011Q[B\u0005\u0001\u0004\ti\u0007\u0003\u0005\u0002^\u000e%\u0001\u0019AA7\u0011!\t)o!\u0003A\u0002\u0005%\b\u0002CA\u007f\u0007\u0013\u0001\rA!\u0001\t\u0015\r\u001d\"1_A\u0001\n\u0003\u001bI#A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r-21\u0007\t\u0006\u0019\u0006\u001d5Q\u0006\t\u0019\u0019\u000e=\"*!\u001c\u0002n\u0005\u0015\u0015qVA`\u0003_\u000bi'!\u001c\u0002j\n\u0005\u0011bAB\u0019\u001b\n9A+\u001e9mKF\n\u0004BCB\u001b\u0007K\t\t\u00111\u0001\u0003\u0018\u0005\u0019\u0001\u0010\n\u0019\t\u0015\re\"1_A\u0001\n\u0013\u0019Y$A\u0006sK\u0006$'+Z:pYZ,G#\u0001\b\t\u000f\r}\"\u0010\"\u0001\u0004B\u0005Q1-\u00198Qe>\u001cWm]:\u0015\t\u0005541\t\u0005\b\u0007\u000eu\u0002\u0019AB#!\u0015)\u0005*!\u0003U\u0011\u001d\u0019IE\u001fC\u0001\u0007\u0017\n!CY;jY\u0012\fU\u000f\u001e5t!J|g/\u001b3feR1\u00111^B'\u0007\u001fBa!ZB$\u0001\u0004y\u0003BB\"\u0004H\u0001\u0007A\tC\u0004\u0004Ti$\ta!\u0016\u0002#\r|gNZ5hkJ,7+Z2ve&$\u0018\u0010\u0006\u0003\u0004X\ru\u0003c\u0001'\u0004Z%\u001911L'\u0003\tUs\u0017\u000e\u001e\u0005\t\u0007?\u001a\t\u00061\u0001\u0004b\u0005!1m\u001c8g!\u0011\u0019\u0019ga\u001a\u000e\u0005\r\u0015$bAB0i%!1\u0011NB3\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"91Q\u000e\u0001\u0005\u0012\r=\u0014\u0001G2iK\u000e\\7\t\\;ti\u0016\u0014\u0018I^1jY\u0006\u0014\u0017\u000e\\5usR!1qKB9\u0011!\u0019yfa\u001bA\u0002\r\u0005\u0004bBB;\u0001\u0011\u00053qO\u0001\u000fO\u0016$H)[:qY\u0006Lh*Y7f)\u0005Q\u0005bBB>\u0001\u0011\u00053qO\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o\u0011\u001d\u0019y\b\u0001C!\u0007\u0003\u000b\u0011cZ3u!\u0006\u0014\u0018-\\3uKJ\u001c\u0018J\u001c4p)\t\u0019\u0019\tE\u0003M\u0007\u000b\u001bI)C\u0002\u0004\b6\u0013Q!\u0011:sCf\u0004Baa#\u0004\u001a:!1QRBK\u001d\u0011\u0019yia%\u000f\u00079\u001c\t*\u0003\u0002\u001b\u0015%\u00111!G\u0005\u0004\u0007/C\u0012!\u0005#bi\u0006\f5mY3tg\u001a\u000b7\r^8ss&!11TBO\u0005\u0015\u0001\u0016M]1n\u0015\r\u00199\n\u0007\u0005\b\u0007\u007f\u0001A\u0011IBQ)\u0011\tiga)\t\r\r\u001by\n1\u0001E\u0011\u001d\u00199\u000b\u0001C!\u0007S\u000b1\"[:Bm\u0006LG.\u00192mKR\u0011\u0011Q\u000e\u0005\b\u0007[\u0003A\u0011IBX\u0003Y9W\r^%na2,W.\u001a8uCRLwN\u001c%j]R\u001cHCABY!\ra51W\u0005\u0004\u0007kk%\u0001\u0002(vY2\u0004")
public class HBaseDataStoreFactory
implements DataStoreFactorySpi,
LazyLogging {
    private Connection org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static void configureSecurity(Configuration configuration) {
        HBaseDataStoreFactory$.MODULE$.configureSecurity(configuration);
    }

    public static AuthorizationsProvider buildAuthsProvider(Connection connection, Map<String, Serializable> map) {
        return HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection, map);
    }

    public static String HBaseGeoMesaKeyTab() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab();
    }

    public static String HBaseGeoMesaPrincipal() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal();
    }

    public static String Description() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public static String DisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    /*
     * WARNING - void declaration
     */
    private Connection org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection$lzycompute() {
        HBaseDataStoreFactory hBaseDataStoreFactory = this;
        synchronized (hBaseDataStoreFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var3_3;
                Configuration conf = HBaseConfiguration.create();
                HBaseDataStoreFactory$.MODULE$.configureSecurity(conf);
                this.checkClusterAvailability(conf);
                Connection ret = ConnectionFactory.createConnection((Configuration)conf);
                Runtime.getRuntime().addShutdownHook(new Thread(this, ret){
                    private final Connection ret$1;

                    public void run() {
                        this.ret$1.close();
                    }
                    {
                        this.ret$1 = ret$1;
                    }
                });
                this.org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection = var3_3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection;
        }
    }

    private Logger logger$lzycompute() {
        HBaseDataStoreFactory hBaseDataStoreFactory = this;
        synchronized (hBaseDataStoreFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public Connection org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection$lzycompute() : this.org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) {
        return this.createDataStore(params);
    }

    public DataStore createDataStore(Map<String, Serializable> params) {
        BoxedUnit boxedUnit;
        Connection connection = (Connection)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupOpt$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.ConnectionParam()), params).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseDataStoreFactory $outer;

            public final Connection apply() {
                return this.$outer.org$locationtech$geomesa$hbase$data$HBaseDataStoreFactory$$globalConnection();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String catalog = (String)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookup$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.BigTableNameParam()), params);
        boolean remoteFilters = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupOpt$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.RemoteFiltersParam()), params).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(new GeoMesaSystemProperties.SystemProperty("geomesa.hbase.remote.filtering", "true").get())).toBoolean();
            }
        }));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " filtering"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteFilters ? "remote" : "local"})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean generateStats = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.GenerateStatsParam()), params));
        None$ audit = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.AuditQueriesParam()), params)) ? new Some((Object)new Tuple3((Object)AuditLogger$.MODULE$, Option$.MODULE$.apply((Object)AuditProvider.Loader.load(params)).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NoOpAuditProvider$ apply() {
                return NoOpAuditProvider$.MODULE$;
            }
        }), (Object)"hbase")) : None$.MODULE$;
        int queryThreads = BoxesRunTime.unboxToInt((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.QueryThreadsParam()), params));
        Option queryTimeout = GeoMesaDataStoreFactory$.MODULE$.queryTimeout(params);
        Integer maxRangesPerExtendedScan = (Integer)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.MaxRangesPerExtendedScan()), params);
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.LooseBBoxParam()), params));
        boolean caching = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupWithDefault$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.CachingParam()), params));
        boolean security = BoxesRunTime.unboxToBoolean((Object)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookup$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.EnableSecurityParam()), params));
        None$ authsProvider = security ? new Some((Object)HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection, params)) : None$.MODULE$;
        Option coprocessorUrl = GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupOpt$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.CoprocessorUrl()), params);
        HBaseDataStoreConfig config = new HBaseDataStoreConfig(catalog, remoteFilters, generateStats, (Option<Tuple3<AuditWriter, AuditProvider, String>>)audit, queryThreads, (Option<Object>)queryTimeout, Predef$.MODULE$.Integer2int(maxRangesPerExtendedScan), looseBBox, caching, (Option<AuthorizationsProvider>)authsProvider, (Option<Path>)coprocessorUrl);
        return this.buildDataStore(connection, config);
    }

    public HBaseDataStore buildDataStore(Connection connection, HBaseDataStoreConfig config) {
        return new HBaseDataStore(connection, config);
    }

    public void checkClusterAvailability(Configuration conf) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking configuration availability.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        HBaseAdmin.checkHBaseAvailable((Configuration)conf);
    }

    public String getDisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    public String getDescription() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return (DataAccessFactory.Param[])((Object[])new DataAccessFactory.Param[]{HBaseDataStoreParams$.MODULE$.BigTableNameParam(), HBaseDataStoreParams$.MODULE$.RemoteFiltersParam(), HBaseDataStoreParams$.MODULE$.QueryThreadsParam(), HBaseDataStoreParams$.MODULE$.QueryTimeoutParam(), HBaseDataStoreParams$.MODULE$.CoprocessorUrl(), HBaseDataStoreParams$.MODULE$.GenerateStatsParam(), HBaseDataStoreParams$.MODULE$.AuditQueriesParam(), HBaseDataStoreParams$.MODULE$.LooseBBoxParam(), HBaseDataStoreParams$.MODULE$.CachingParam(), HBaseDataStoreParams$.MODULE$.EnableSecurityParam(), HBaseDataStoreParams$.MODULE$.AuthsParam(), HBaseDataStoreParams$.MODULE$.ForceEmptyAuthsParam()});
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return HBaseDataStoreFactory$.MODULE$.canProcess(params);
    }

    public boolean isAvailable() {
        return true;
    }

    public Null$ getImplementationHints() {
        return null;
    }

    public HBaseDataStoreFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class HBaseDataStoreConfig
    implements GeoMesaDataStoreFactory.GeoMesaDataStoreConfig,
    Product,
    scala.Serializable {
        private final String catalog;
        private final boolean remoteFilter;
        private final boolean generateStats;
        private final Option<Tuple3<AuditWriter, AuditProvider, String>> audit;
        private final int queryThreads;
        private final Option<Object> queryTimeout;
        private final int maxRangesPerExtendedScan;
        private final boolean looseBBox;
        private final boolean caching;
        private final Option<AuthorizationsProvider> authProvider;
        private final Option<Path> coprocessorUrl;

        public String catalog() {
            return this.catalog;
        }

        public boolean remoteFilter() {
            return this.remoteFilter;
        }

        public boolean generateStats() {
            return this.generateStats;
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> audit() {
            return this.audit;
        }

        public int queryThreads() {
            return this.queryThreads;
        }

        public Option<Object> queryTimeout() {
            return this.queryTimeout;
        }

        public int maxRangesPerExtendedScan() {
            return this.maxRangesPerExtendedScan;
        }

        public boolean looseBBox() {
            return this.looseBBox;
        }

        public boolean caching() {
            return this.caching;
        }

        public Option<AuthorizationsProvider> authProvider() {
            return this.authProvider;
        }

        public Option<Path> coprocessorUrl() {
            return this.coprocessorUrl;
        }

        public HBaseDataStoreConfig copy(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl) {
            return new HBaseDataStoreConfig(catalog, remoteFilter, generateStats, audit, queryThreads, queryTimeout, maxRangesPerExtendedScan, looseBBox, caching, authProvider, coprocessorUrl);
        }

        public String copy$default$1() {
            return this.catalog();
        }

        public boolean copy$default$2() {
            return this.remoteFilter();
        }

        public boolean copy$default$3() {
            return this.generateStats();
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> copy$default$4() {
            return this.audit();
        }

        public int copy$default$5() {
            return this.queryThreads();
        }

        public Option<Object> copy$default$6() {
            return this.queryTimeout();
        }

        public int copy$default$7() {
            return this.maxRangesPerExtendedScan();
        }

        public boolean copy$default$8() {
            return this.looseBBox();
        }

        public boolean copy$default$9() {
            return this.caching();
        }

        public Option<AuthorizationsProvider> copy$default$10() {
            return this.authProvider();
        }

        public Option<Path> copy$default$11() {
            return this.coprocessorUrl();
        }

        public String productPrefix() {
            return "HBaseDataStoreConfig";
        }

        public int productArity() {
            return 11;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 10: {
                    object = this.coprocessorUrl();
                    break;
                }
                case 9: {
                    object = this.authProvider();
                    break;
                }
                case 8: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.caching());
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.looseBBox());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToInteger((int)this.maxRangesPerExtendedScan());
                    break;
                }
                case 5: {
                    object = this.queryTimeout();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.queryThreads());
                    break;
                }
                case 3: {
                    object = this.audit();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.generateStats());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.remoteFilter());
                    break;
                }
                case 0: {
                    object = this.catalog();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HBaseDataStoreConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.catalog()));
            n = Statics.mix((int)n, (int)(this.remoteFilter() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.generateStats() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.audit()));
            n = Statics.mix((int)n, (int)this.queryThreads());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryTimeout()));
            n = Statics.mix((int)n, (int)this.maxRangesPerExtendedScan());
            n = Statics.mix((int)n, (int)(this.looseBBox() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.caching() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.authProvider()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.coprocessorUrl()));
            return Statics.finalizeHash((int)n, (int)11);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HBaseDataStoreConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            HBaseDataStoreConfig hBaseDataStoreConfig = (HBaseDataStoreConfig)x$1;
            String string = this.catalog();
            String string2 = hBaseDataStoreConfig.catalog();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.remoteFilter() != hBaseDataStoreConfig.remoteFilter()) return false;
            if (this.generateStats() != hBaseDataStoreConfig.generateStats()) return false;
            Option<Tuple3<AuditWriter, AuditProvider, String>> option = this.audit();
            Option<Tuple3<AuditWriter, AuditProvider, String>> option2 = hBaseDataStoreConfig.audit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.queryThreads() != hBaseDataStoreConfig.queryThreads()) return false;
            Option<Object> option3 = this.queryTimeout();
            Option<Object> option4 = hBaseDataStoreConfig.queryTimeout();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (this.maxRangesPerExtendedScan() != hBaseDataStoreConfig.maxRangesPerExtendedScan()) return false;
            if (this.looseBBox() != hBaseDataStoreConfig.looseBBox()) return false;
            if (this.caching() != hBaseDataStoreConfig.caching()) return false;
            Option<AuthorizationsProvider> option5 = this.authProvider();
            Option<AuthorizationsProvider> option6 = hBaseDataStoreConfig.authProvider();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Path> option7 = this.coprocessorUrl();
            Option<Path> option8 = hBaseDataStoreConfig.coprocessorUrl();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            if (!hBaseDataStoreConfig.canEqual(this)) return false;
            return true;
        }

        public HBaseDataStoreConfig(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl) {
            this.catalog = catalog;
            this.remoteFilter = remoteFilter;
            this.generateStats = generateStats;
            this.audit = audit;
            this.queryThreads = queryThreads;
            this.queryTimeout = queryTimeout;
            this.maxRangesPerExtendedScan = maxRangesPerExtendedScan;
            this.looseBBox = looseBBox;
            this.caching = caching;
            this.authProvider = authProvider;
            this.coprocessorUrl = coprocessorUrl;
            Product.class.$init$((Product)this);
        }
    }
}

