/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Mutation;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SimpleFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseFeature$;
import org.locationtech.geomesa.hbase.data.HBaseFeatureWriter;
import org.locationtech.geomesa.hbase.data.HBaseFeatureWriter$;
import org.locationtech.geomesa.hbase.package$HBaseSystemProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter;
import org.locationtech.geomesa.utils.io.FlushQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;

public abstract class HBaseFeatureWriter$class {
    public static IndexedSeq createMutators(HBaseFeatureWriter $this, IndexedSeq tables) {
        Option batchSize = package$HBaseSystemProperties$.MODULE$.WriteBatchSize().option().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        });
        return (IndexedSeq)tables.map((Function1)new Serializable($this, batchSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseFeatureWriter $outer;
            private final Option batchSize$1;

            public final BufferedMutator apply(String name) {
                BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf((String)name));
                this.batchSize$1.foreach((Function1)new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final BufferedMutatorParams params$1;

                    public final BufferedMutatorParams apply(long x$1) {
                        return this.params$1.writeBufferSize(x$1);
                    }
                    {
                        this.params$1 = params$1;
                    }
                });
                return ((HBaseDataStore)((GeoMesaFeatureWriter)this.$outer).ds()).connection().getBufferedMutator(params);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchSize$1 = batchSize$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static void executeWrite(HBaseFeatureWriter $this, BufferedMutator mutator, Seq writes) {
        writes.foreach((Function1)new Serializable($this, mutator){
            public static final long serialVersionUID = 0L;
            private final BufferedMutator mutator$1;

            public final void apply(Mutation x$1) {
                this.mutator$1.mutate(x$1);
            }
            {
                this.mutator$1 = mutator$1;
            }
        });
    }

    public static void executeRemove(HBaseFeatureWriter $this, BufferedMutator mutator, Seq removes) {
        removes.foreach((Function1)new Serializable($this, mutator){
            public static final long serialVersionUID = 0L;
            private final BufferedMutator mutator$2;

            public final void apply(Mutation x$1) {
                this.mutator$2.mutate(x$1);
            }
            {
                this.mutator$2 = mutator$2;
            }
        });
    }

    public static HBaseFeature wrapFeature(HBaseFeatureWriter $this, SimpleFeature feature) {
        return new HBaseFeature(feature, (SimpleFeatureSerializer)$this.org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$serializer(), HBaseFeature$.MODULE$.$lessinit$greater$default$3());
    }

    public static void flush(HBaseFeatureWriter $this) {
        $this.org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$super$mutators().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseFeatureWriter $outer;

            public final void apply(BufferedMutator m) {
                FlushQuietly$.MODULE$.apply((Object)m).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseFeatureWriter$.anonfun.flush.1 $outer;

                    public final ArrayBuffer<Throwable> apply(Throwable elem) {
                        return this.$outer.org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$anonfun$$$outer().org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$super$exceptions().$plus$eq((Object)elem);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ HBaseFeatureWriter org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$super$flush();
    }

    public static void $init$(HBaseFeatureWriter $this) {
        $this.org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$_setter_$org$locationtech$geomesa$hbase$data$HBaseFeatureWriter$$serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(((GeoMesaFeatureWriter)$this).sft(), SerializationOption.SerializationOptions$.MODULE$.withoutId()));
    }
}

