/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.filters;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.locationtech.geomesa.hbase.filters.Z2HBaseFilter$;
import org.locationtech.geomesa.index.filters.Z2Filter;
import org.locationtech.geomesa.index.filters.Z2Filter$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u00015\u0011QB\u0017\u001aI\u0005\u0006\u001cXMR5mi\u0016\u0014(BA\u0002\u0005\u0003\u001d1\u0017\u000e\u001c;feNT!!\u0002\u0004\u0002\u000b!\u0014\u0017m]3\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019I\u0002CA\b\u0018\u001b\u0005\u0001\"BA\t\u0013\u0003\u00191\u0017\u000e\u001c;fe*\u0011Qa\u0005\u0006\u0003)U\ta\u0001[1e_>\u0004(B\u0001\f\u000b\u0003\u0019\t\u0007/Y2iK&\u0011\u0001\u0004\u0005\u0002\u000b\r&dG/\u001a:CCN,\u0007C\u0001\u000e\"\u001b\u0005Y\"B\u0001\u000f\u001e\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqr$\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0013aA2p[&\u0011!e\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005\u0012\u0001\t\u0015\r\u0011\"\u0001%+\u0005)\u0003C\u0001\u0014+\u001b\u00059#BA\u0002)\u0015\tIc!A\u0003j]\u0012,\u00070\u0003\u0002,O\tA!L\r$jYR,'\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003&\u0003\u001d1\u0017\u000e\u001c;fe\u0002B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0007_\u001a47/\u001a;\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u0007%sG\u000fC\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0004smb\u0004C\u0001\u001e\u0001\u001b\u0005\u0011\u0001\"B\t7\u0001\u0004)\u0003\"B\u00187\u0001\u0004\u0001\u0004\"\u0002 \u0001\t\u0003z\u0014A\u00044jYR,'oS3z-\u0006dW/\u001a\u000b\u0003\u0001\u001e\u0003\"!\u0011#\u000f\u0005=\u0011\u0015BA\"\u0011\u0003\u00191\u0015\u000e\u001c;fe&\u0011QI\u0012\u0002\u000b%\u0016$XO\u001d8D_\u0012,'BA\"\u0011\u0011\u0015AU\b1\u0001J\u0003\u00051\bC\u0001&L\u001b\u0005\u0011\u0012B\u0001'\u0013\u0005\u0011\u0019U\r\u001c7\t\u000b9\u0003A\u0011I(\u0002\u0017Q|')\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0002!B\u0019\u0011'U*\n\u0005I\u0013$!B!se\u0006L\bCA\u0019U\u0013\t)&G\u0001\u0003CsR,w!B,\u0003\u0011\u0003A\u0016!\u0004.3\u0011\n\u000b7/\u001a$jYR,'\u000f\u0005\u0002;3\u001a)\u0011A\u0001E\u00015N\u0019\u0011lW\r\u0011\u0005Eb\u0016BA/3\u0005\u0019\te.\u001f*fM\")q'\u0017C\u0001?R\t\u0001\fC\u0004b3\n\u0007I\u0011\u00012\u0002\u0011A\u0013\u0018n\u001c:jif,\u0012\u0001\r\u0005\u0007If\u0003\u000b\u0011\u0002\u0019\u0002\u0013A\u0013\u0018n\u001c:jif\u0004\u0003\"\u00024Z\t\u00039\u0017!\u00039beN,gI]8n)\tA7\u000e\u0005\u0002\u0010S&\u0011!\u000e\u0005\u0002\u0007\r&dG/\u001a:\t\u000b1,\u0007\u0019\u0001)\u0002\u000fA\u0014')\u001f;fg\"\u001aQM\\<\u0011\u0007Ez\u0017/\u0003\u0002qe\t1A\u000f\u001b:poN\u0004\"A];\u000e\u0003MT!\u0001\u001e\n\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0002wg\nAB)Z:fe&\fG.\u001b>bi&|g.\u0012=dKB$\u0018n\u001c82\u000byAx0!\r\u0011\u0005edhBA\u0019{\u0013\tY('\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>3c%\u0019\u0013\u0011AA\u0005\u0003O\tY!\u0006\u0003\u0002\u0004\u0005\u0015Q#\u0001=\u0005\u000f\u0005\u001dAB1\u0001\u0002\u0012\t\tA+\u0003\u0003\u0002\f\u00055\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u0010I\na\u0001\u001e5s_^\u001c\u0018\u0003BA\n\u00033\u00012!MA\u000b\u0013\r\t9B\r\u0002\b\u001d>$\b.\u001b8h!\u0011\tY\"!\t\u000f\u0007E\ni\"C\u0002\u0002 I\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"!\u0003+ie><\u0018M\u00197f\u0015\r\tyBM\u0019\nG\u0005%\u00121FA\u0017\u0003\u001fq1!MA\u0016\u0013\r\tyAM\u0019\u0006EE\u0012\u0014q\u0006\u0002\u0006g\u000e\fG.Y\u0019\u0003ME\u0004")
public class Z2HBaseFilter
extends FilterBase
implements LazyLogging {
    private final Z2Filter filter;
    private final int offset;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Filter parseFrom(byte[] byArray) throws DeserializationException {
        return Z2HBaseFilter$.MODULE$.parseFrom(byArray);
    }

    public static int Priority() {
        return Z2HBaseFilter$.MODULE$.Priority();
    }

    private Logger logger$lzycompute() {
        Z2HBaseFilter z2HBaseFilter = this;
        synchronized (z2HBaseFilter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Z2Filter filter() {
        return this.filter;
    }

    public Filter.ReturnCode filterKeyValue(Cell v) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("In filterKeyValue()");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.filter().inBounds(v.getRowArray(), v.getRowOffset() + this.offset) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
    }

    public byte[] toByteArray() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Serializing Z2HBaseFilter");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Bytes.concat((byte[][])new byte[][]{Z2Filter$.MODULE$.toByteArray(this.filter()), Ints.toByteArray((int)this.offset)});
    }

    public Z2HBaseFilter(Z2Filter filter, int offset) {
        this.filter = filter;
        this.offset = offset;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

