/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.locationtech.geomesa.hbase.coprocessor.package$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public abstract class HBaseFeatureIndex$class {
    /*
     * WARNING - void declaration
     */
    public static void configure(HBaseFeatureIndex $this, SimpleFeatureType sft, HBaseDataStore ds) {
        Admin admin;
        block5: {
            $this.org$locationtech$geomesa$hbase$index$HBaseFeatureIndex$$super$configure(sft, ds);
            TableName name = TableName.valueOf((String)$this.getTableName(sft.getTypeName(), ds));
            admin = ds.connection().getAdmin();
            Option coprocessorUrl = ds.config().coprocessorUrl().orElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Option<Path> apply() {
                    return new GeoMesaSystemProperties.SystemProperty("geomesa.hbase.coprocessor.path", null).option().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x$1) {
                            return new Path(x$1);
                        }
                    });
                }
            });
            try {
                BoxedUnit boxedUnit;
                if (admin.tableExists(name)) break block5;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                HTableDescriptor descriptor = new HTableDescriptor(name);
                descriptor.addFamily(HBaseFeatureIndex$.MODULE$.DataColumnFamilyDescriptor());
                if (ds.config().remoteFilter()) {
                    Option installed = Option$.MODULE$.apply((Object)admin.getConfiguration().get("hbase.coprocessor.user.region.classes"));
                    Set names = (Set)installed.map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Set<String> apply(String x$2) {
                            return Predef$.MODULE$.refArrayOps((Object[])x$2.split(":")).toSet();
                        }
                    }).getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Set<String> apply() {
                            return Predef$.MODULE$.Set().empty();
                        }
                    });
                    package$.MODULE$.AllCoprocessors().foreach((Function1)new Serializable($this, coprocessorUrl, descriptor, names){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseFeatureIndex $outer;
                        private final Option coprocessorUrl$1;
                        private final HTableDescriptor descriptor$1;
                        private final Set names$1;

                        public final void apply(Class<? extends Coprocessor> c) {
                            if (!this.names$1.contains((Object)c.getCanonicalName())) {
                                HBaseFeatureIndex$class.addCoprocessor$1(this.$outer, c, this.descriptor$1, this.coprocessorUrl$1);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.coprocessorUrl$1 = coprocessorUrl$1;
                            this.descriptor$1 = descriptor$1;
                            this.names$1 = names$1;
                        }
                    });
                }
                admin.createTable(descriptor, (byte[][])$this.getSplits(sft).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
            }
            catch (Throwable throwable) {
                void var4_4;
                var4_4.close();
                throw throwable;
            }
        }
        admin.close();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static void delete(HBaseFeatureIndex $this, SimpleFeatureType sft, HBaseDataStore ds, boolean shared) {
        if (shared) {
            Table table = ds.connection().getTable(TableName.valueOf((String)$this.getTableName(sft.getTypeName(), ds)));
            Scan scan2 = new Scan().setRowPrefixFilter(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).setFilter((Filter)new KeyOnlyFilter());
            ds.applySecurity((Query)scan2);
            ResultScanner scanner = table.getScanner(scan2);
            JavaConversions$.MODULE$.asScalaIterator(scanner.iterator()).grouped(10000).foreach((Function1)new Serializable($this, table){
                public static final long serialVersionUID = 0L;
                private final Table table$1;

                public final void apply(Seq<Result> result) {
                    Seq deletes = (Seq)result.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Delete apply(Result r) {
                            return new Delete(r.getRow());
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    this.table$1.delete(JavaConversions$.MODULE$.seqAsJavaList(deletes));
                }
                {
                    this.table$1 = table$1;
                }
            });
            scanner.close();
            table.close();
        } else {
            TableName table = TableName.valueOf((String)$this.getTableName(sft.getTypeName(), ds));
            Admin admin = ds.connection().getAdmin();
            admin.disableTable(table);
            admin.deleteTable(table);
            admin.close();
        }
        return;
        {
            catch (Throwable throwable) {
                try {
                    void var7_6;
                    var7_6.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var4_4;
                    var4_4.close();
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable) {
            void var10_8;
            var10_8.close();
            throw throwable;
        }
    }

    public static final void addCoprocessor$1(HBaseFeatureIndex $this, Class clazz, HTableDescriptor desc, Option coprocessorUrl$1) {
        Option option;
        block4: {
            block2: {
                String name;
                block3: {
                    name = clazz.getCanonicalName();
                    if (desc.getCoprocessors().contains(name)) break block2;
                    option = coprocessorUrl$1;
                    if (!(option instanceof Some)) break block3;
                    Some some = (Some)option;
                    Path path = (Path)some.x();
                    desc.addCoprocessor(name, path, 0x3FFFFFFF, null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                desc.addCoprocessor(name);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static void $init$(HBaseFeatureIndex $this) {
    }
}

