/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig;
import org.locationtech.geomesa.hbase.data.CoprocessorPlan;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.data.ScanPlan;
import org.locationtech.geomesa.hbase.index.HBasePlatform;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.index.IndexAdapter$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;

public abstract class HBasePlatform$class {
    public static HBaseQueryPlan buildPlatformScanPlan(HBasePlatform $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Hints hints, Seq ranges, TableName table, Seq hbaseFilters, Option coprocessor, Function1 toFeatures) {
        Option option;
        block7: {
            Product product;
            block6: {
                block2: {
                    Query query;
                    block5: {
                        Seq seq;
                        block4: {
                            block3: {
                                option = coprocessor;
                                if (!None$.MODULE$.equals(option)) break block2;
                                query = (Query)ranges.head();
                                if (!(query instanceof Get)) break block3;
                                seq = HBasePlatform$class.configureGet($this, ranges, hbaseFilters);
                                break block4;
                            }
                            if (!(query instanceof Scan)) break block5;
                            seq = HBasePlatform$class.configureMultiRowRangeFilter($this, ds, ranges, hbaseFilters);
                        }
                        Seq scans = seq;
                        product = new ScanPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, table, (Seq<Scan>)scans, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)toFeatures);
                        break block6;
                    }
                    throw new MatchError((Object)query);
                }
                if (!(option instanceof Some)) break block7;
                Some some = (Some)option;
                CoprocessorConfig coprocessorConfig = (CoprocessorConfig)some.x();
                product = new CoprocessorPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, table, (Seq<Query>)ranges, (Seq<Tuple2<Object, Filter>>)hbaseFilters, coprocessorConfig);
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private static Seq configureGet(HBasePlatform $this, Seq originalRanges, Seq hbaseFilters) {
        FilterList filterList = new FilterList((Filter[])((TraversableOnce)((TraversableLike)hbaseFilters.sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Filter> x$1) {
                return x$1._1$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Filter apply(Tuple2<Object, Filter> x$2) {
                return (Filter)x$2._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class)));
        return (Seq)originalRanges.map((Function1)new Serializable($this, filterList){
            public static final long serialVersionUID = 0L;
            private final FilterList filterList$1;

            public final Scan apply(Query r) {
                Get g = (Get)r;
                byte[] start = g.getRow();
                byte[] end = IndexAdapter$.MODULE$.rowFollowingRow(start);
                return new Scan(g).setStartRow(start).setStopRow(end).setFilter((Filter)this.filterList$1).setSmall(true);
            }
            {
                this.filterList$1 = filterList$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static Buffer configureMultiRowRangeFilter(HBasePlatform $this, HBaseDataStore ds, Seq originalRanges, Seq hbaseFilters) {
        Seq sortedFilters = (Seq)((TraversableLike)hbaseFilters.sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Filter> x$3) {
                return x$3._1$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Filter apply(Tuple2<Object, Filter> x$4) {
                return (Filter)x$4._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ArrayList rowRanges = Lists.newArrayList();
        originalRanges.foreach((Function1)new Serializable($this, rowRanges){
            public static final long serialVersionUID = 0L;
            private final ArrayList rowRanges$1;

            public final boolean apply(Query r) {
                return this.rowRanges$1.add(new MultiRowRangeFilter.RowRange(((Scan)r).getStartRow(), true, ((Scan)r).getStopRow(), false));
            }
            {
                this.rowRanges$1 = rowRanges$1;
            }
        });
        List sortedRowRanges = MultiRowRangeFilter.sortAndMerge((List)rowRanges);
        int numRanges = JavaConversions$.MODULE$.asScalaBuffer(sortedRowRanges).length();
        int numThreads = ds.config().queryThreads();
        int rangesPerThread = package$.MODULE$.min(ds.config().maxRangesPerExtendedScan(), package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(numRanges / numThreads * 2))));
        List groupedRanges = Lists.partition((List)sortedRowRanges, (int)rangesPerThread);
        Buffer groupedScans = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(groupedRanges).map((Function1)new Serializable($this, sortedFilters){
            public static final long serialVersionUID = 0L;
            private final Seq sortedFilters$1;

            public final Scan apply(List<MultiRowRangeFilter.RowRange> localRanges) {
                MultiRowRangeFilter mrrf = new MultiRowRangeFilter(localRanges);
                FilterList filterList = new FilterList((Filter[])((TraversableOnce)this.sortedFilters$1.$plus$colon((Object)mrrf, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class)));
                Scan s = new Scan();
                s.setStartRow(((MultiRowRangeFilter.RowRange)JavaConversions$.MODULE$.asScalaBuffer(localRanges).head()).getStartRow());
                s.setStopRow(localRanges.get(JavaConversions$.MODULE$.asScalaBuffer(localRanges).length() - 1).getStopRow());
                s.setFilter((Filter)filterList);
                s.setCaching(1000);
                s.setCacheBlocks(true);
                return s;
            }
            {
                this.sortedFilters$1 = sortedFilters$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        groupedScans.foreach((Function1)new Serializable($this, ds){
            public static final long serialVersionUID = 0L;
            private final HBaseDataStore ds$1;

            public final void apply(Query query) {
                this.ds$1.applySecurity(query);
            }
            {
                this.ds$1 = ds$1;
            }
        });
        return groupedScans;
    }

    public static void $init$(HBasePlatform $this) {
    }
}

