/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.ExportParams;
import org.locationtech.geomesa.tools.export.FileExportParams;
import org.locationtech.geomesa.tools.export.formats.BinExporter$;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExportCommand$
implements LazyLogging {
    public static final ExportCommand$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExportCommand$();
    }

    private Logger logger$lzycompute() {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Tuple2<Query, Option<ExportCommand.ExportAttributes>> createQuery(DataStore ds, Function0<SimpleFeatureType> sft, Enumeration.Value fmt2, ExportParams params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option option;
        Object object;
        String typeName = (String)Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportParams, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TypeNameParam) {
                    A1 A12 = A1;
                    object = ((TypeNameParam)((Object)A12)).featureName();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportParams x1) {
                ExportParams exportParams = x1;
                boolean bl = exportParams instanceof TypeNameParam;
                return bl;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Filter filter = (Filter)Option$.MODULE$.apply((Object)params.cqlFilter()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Filter apply(String x$1) {
                return ECQL.toFilter((String)x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Query query = new Query(typeName, filter);
        Option$.MODULE$.apply((Object)params.maxFeatures()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return BoxesRunTime.unboxToInt((Object)x);
            }
        }).foreach((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final Query query$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.query$2.setMaxFeatures(x$1);
            }
            {
                this.query$2 = query$2;
            }
        });
        Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportParams, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x2;
                Object object = A12 instanceof OptionalIndexParam ? (A1 = A12) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportParams x2) {
                ExportParams exportParams = x2;
                boolean bl = exportParams instanceof OptionalIndexParam;
                return bl;
            }
        }).foreach((Function1)new Serializable(ds, query){
            public static final long serialVersionUID = 0L;
            private final DataStore ds$1;
            public final Query query$2;

            public final void apply(ExportParams p) {
                GeoMesaDataStore gmds = (GeoMesaDataStore)Option$.MODULE$.apply((Object)this.ds$1).collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends DataStore, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof GeoMesaDataStore) {
                            GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)A1;
                            object = geoMesaDataStore;
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(DataStore x3) {
                        DataStore dataStore = x3;
                        boolean bl = dataStore instanceof GeoMesaDataStore;
                        return bl;
                    }
                }).orNull(Predef$.MODULE$.$conforms());
                ((OptionalIndexParam)((Object)p)).loadIndex(gmds, IndexMode$.MODULE$.Read()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createQuery.4 $outer;

                    public final void apply(GeoMesaFeatureIndex<?, ?, ?> index) {
                        BoxedUnit boxedUnit;
                        this.$outer.query$2.getHints().put((Object)QueryHints$.MODULE$.QUERY_INDEX(), index);
                        if (ExportCommand$.MODULE$.logger().underlying().isDebugEnabled()) {
                            ExportCommand$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.identifier()})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.ds$1 = ds$1;
                this.query$2 = query$2;
            }
        });
        Enumeration.Value value = fmt2;
        Enumeration.Value value2 = DataFormats$.MODULE$.Arrow();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            object = query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)Boolean.TRUE);
        } else {
            Enumeration.Value value3 = fmt2;
            Enumeration.Value value4 = DataFormats$.MODULE$.Bin();
            object = !(value3 != null ? !value3.equals(value4) : value4 != null) ? query.getHints().put((Object)QueryHints$.MODULE$.BIN_TRACK(), (Object)"id") : BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply(params.hints()).foreach((Function1)new Serializable(sft, query){
            public static final long serialVersionUID = 0L;
            private final Function0 sft$2;
            private final Query query$2;

            public final void apply(Map<String, String> hints2) {
                this.query$2.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, hints2);
                ViewParams$.MODULE$.setHints((SimpleFeatureType)this.sft$2.apply(), this.query$2);
            }
            {
                this.sft$2 = sft$2;
                this.query$2 = query$2;
            }
        });
        Option provided = Option$.MODULE$.apply(params.attributes()).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends List<String>, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1.isEmpty() ? function1.apply(x4) : JavaConversions$.MODULE$.asScalaBuffer(A1).toSeq();
                return (B1)object;
            }

            public final boolean isDefinedAt(List<String> x4) {
                List<String> list = x4;
                boolean bl = !list.isEmpty();
                return bl;
            }
        }).orElse((Function0)new Serializable(sft, fmt2, query){
            public static final long serialVersionUID = 0L;
            private final Function0 sft$2;
            private final Enumeration.Value fmt$1;
            private final Query query$2;

            public final Option<Seq<String>> apply() {
                Enumeration.Value value = this.fmt$1;
                Enumeration.Value value2 = DataFormats$.MODULE$.Bin();
                return !(value != null ? !value.equals(value2) : value2 != null) ? new Some(BinExporter$.MODULE$.getAttributeList((SimpleFeatureType)this.sft$2.apply(), this.query$2.getHints())) : None$.MODULE$;
            }
            {
                this.sft$2 = sft$2;
                this.fmt$1 = fmt$1;
                this.query$2 = query$2;
            }
        });
        Enumeration.Value value5 = fmt2;
        Enumeration.Value value6 = DataFormats$.MODULE$.Shp();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            Seq attributes = (Seq)provided.map((Function1)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final Function0 sft$2;

                public final Seq<String> apply(Seq<String> x$7) {
                    return ShapefileExporter$.MODULE$.replaceGeom((SimpleFeatureType)this.sft$2.apply(), x$7);
                }
                {
                    this.sft$2 = sft$2;
                }
            }).getOrElse((Function0)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final Function0 sft$2;

                public final Seq<String> apply() {
                    return ShapefileExporter$.MODULE$.modifySchema((SimpleFeatureType)this.sft$2.apply());
                }
                {
                    this.sft$2 = sft$2;
                }
            });
            option = new Some((Object)new ExportCommand.ExportAttributes((Seq<String>)attributes, true));
        } else {
            option = provided.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ExportCommand.ExportAttributes apply(Seq<String> p) {
                    Tuple2 tuple2 = p.partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$8) {
                            return x$8.equalsIgnoreCase("id");
                        }
                    });
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Seq id = (Seq)tuple2._1();
                        Seq attributes = (Seq)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)id, (Object)attributes);
                        Seq id2 = (Seq)tuple23._1();
                        Seq attributes2 = (Seq)tuple23._2();
                        return new ExportCommand.ExportAttributes((Seq<String>)attributes2, id2.nonEmpty());
                    }
                    throw new MatchError((Object)tuple2);
                }
            });
        }
        Option attributes = option;
        query.setPropertyNames((String[])attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(ExportCommand.ExportAttributes x$10) {
                return (String[])x$10.names().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Applying CQL filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ECQL.toCQL((Filter)filter)})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Applying transform ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)query.getPropertyNames()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String[] x$11) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$11).mkString(",");
                }
            }).orNull(Predef$.MODULE$.$conforms())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)query, (Object)attributes);
    }

    public OutputStream createOutputStream(File file, Integer compress) {
        OutputStream out = (OutputStream)Option$.MODULE$.apply((Object)file).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileOutputStream apply(File x$12) {
                return new FileOutputStream(x$12);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PrintStream apply() {
                return System.out;
            }
        });
        OutputStream compressed = compress == null ? out : new GZIPOutputStream(compress, out){
            {
                this.def.setLevel(Predef$.MODULE$.Integer2int(compress$1));
            }
        };
        return new BufferedOutputStream(compressed);
    }

    public Writer getWriter(FileExportParams params) {
        return new OutputStreamWriter(this.createOutputStream(params.file(), params.gzip()));
    }

    public File checkShpFile(FileExportParams params) {
        if (params.file() == null) {
            throw new ParameterException("Error: -o or --output for file-based output is required for shapefile export (stdout not supported for shape files)");
        }
        return params.file();
    }

    private ExportCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

