/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Point2D;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Point Buffers", description="Returns a collection of circular buffer polygons with specified radii centered on a given point")
public class PointBuffers
implements VectorProcess {
    @DescribeResult(name="buffers", description="Features for the circular buffer polygons around the point, with attributes geom and radius")
    public SimpleFeatureCollection execute(@DescribeParameter(name="center", description="Input point") Point center, @DescribeParameter(name="crs", description="Coordinate reference system of the point and the generated buffer polygons", min=0) CoordinateReferenceSystem crs, @DescribeParameter(name="distances", description="Buffer radius distance, in meters") double[] distances, @DescribeParameter(name="quadrantSegments", description="Number of line segments per quarter-circle to be generated.  Larger numbers produce smoother shapes but larger numbers of vertices. Default is 8", min=0, defaultValue="8") Integer quadrantSegments, ProgressListener listener) {
        BufferGenerator generator;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geom", Polygon.class, crs);
        tb.add("radius", Double.class);
        tb.setName("buffers");
        SimpleFeatureType schema = tb.buildFeatureType();
        if (quadrantSegments == null) {
            quadrantSegments = 8;
        }
        if (crs != null) {
            SingleCRS hor = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
            if (hor instanceof GeographicCRS) {
                generator = new GeographicGenerator(center, quadrantSegments, crs);
            } else {
                Unit unit = hor.getCoordinateSystem().getAxis(0).getUnit();
                UnitConverter converter = SI.METER.getConverterTo(unit);
                generator = new MetricGenerator(center, quadrantSegments, converter);
            }
        } else {
            generator = new MetricGenerator(center, quadrantSegments, UnitConverter.IDENTITY);
        }
        ListFeatureCollection result = new ListFeatureCollection(schema);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        for (int i = 0; i < distances.length; ++i) {
            fb.add((Object)generator.getBuffer(distances[i]));
            fb.add((Object)distances[i]);
            result.add(fb.buildFeature("buffers." + (i + 1)));
        }
        return result;
    }

    boolean isLatLonOrder(CoordinateSystem cs) {
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals((Object)AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals((Object)AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        return longitudeDim >= 0 && latitudeDim >= 0 && longitudeDim > latitudeDim;
    }

    public class GeographicGenerator
    extends BufferGenerator {
        GeometryFactory gf = new GeometryFactory();
        GeodeticCalculator calculator;
        boolean latLon;

        public GeographicGenerator(Point center, int quadrantSegments, CoordinateReferenceSystem crs) {
            this.quadrantSegments = quadrantSegments;
            this.center = center;
            this.calculator = new GeodeticCalculator(crs);
            this.latLon = PointBuffers.this.isLatLonOrder(crs.getCoordinateSystem());
            if (this.latLon) {
                this.calculator.setStartingGeographicPoint(center.getY(), center.getX());
            } else {
                this.calculator.setStartingGeographicPoint(center.getX(), center.getY());
            }
        }

        @Override
        public Polygon getBuffer(double distance) {
            LiteCoordinateSequence cs = new LiteCoordinateSequence(this.quadrantSegments * 4 + 1, 2);
            for (int i = 0; i < cs.size() - 1; ++i) {
                double azimuth = 360.0 * (double)i / (double)cs.size() - 180.0;
                this.calculator.setDirection(azimuth, distance);
                Point2D dp = this.calculator.getDestinationGeographicPoint();
                if (this.latLon) {
                    cs.setOrdinate(i, 0, dp.getY());
                    cs.setOrdinate(i, 1, dp.getX());
                    continue;
                }
                cs.setOrdinate(i, 0, dp.getX());
                cs.setOrdinate(i, 1, dp.getY());
            }
            cs.setOrdinate(cs.size() - 1, 0, cs.getOrdinate(0, 0));
            cs.setOrdinate(cs.size() - 1, 1, cs.getOrdinate(0, 1));
            return this.gf.createPolygon(this.gf.createLinearRing((CoordinateSequence)cs), null);
        }
    }

    public class MetricGenerator
    extends BufferGenerator {
        UnitConverter converter;

        public MetricGenerator(Point center, Integer quadrantSegments, UnitConverter converter) {
            this.center = center;
            this.quadrantSegments = quadrantSegments;
            this.converter = converter;
        }

        @Override
        public Polygon getBuffer(double distance) {
            distance = this.converter.convert(distance);
            return (Polygon)this.center.buffer(distance, this.quadrantSegments);
        }
    }

    static abstract class BufferGenerator {
        Point center;
        int quadrantSegments;

        BufferGenerator() {
        }

        public abstract Polygon getBuffer(double var1);
    }
}

