/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.typesafe.scalalogging.Logger;
import java.util.Arrays;
import org.locationtech.geomesa.index.index.IndexAdapter$IndexAdapterLogger$;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class IndexAdapter$ {
    public static final IndexAdapter$ MODULE$;
    private final byte ZeroByte;
    private final byte MaxByte;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new IndexAdapter$();
    }

    private Logger logger$lzycompute() {
        IndexAdapter$ indexAdapter$ = this;
        synchronized (indexAdapter$) {
            if (!this.bitmap$0) {
                this.logger = IndexAdapter$IndexAdapterLogger$.MODULE$.log();
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public byte ZeroByte() {
        return this.ZeroByte;
    }

    public byte MaxByte() {
        return this.MaxByte;
    }

    private Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] rowFollowingPrefix(byte[] prefix) {
        byte[] byArray;
        int changeIndex;
        for (changeIndex = prefix.length - 1; changeIndex >= 0 && prefix[changeIndex] == this.MaxByte(); --changeIndex) {
        }
        if (changeIndex < 0) {
            byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        } else {
            void var3_3;
            byte[] following = (byte[])Array$.MODULE$.ofDim(changeIndex + 1, ClassTag$.MODULE$.Byte());
            System.arraycopy(prefix, 0, following, 0, changeIndex + 1);
            following[changeIndex] = (byte)(following[changeIndex] + 1);
            byArray = var3_3;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] rowFollowingRow(byte[] row) {
        void var2_2;
        byte[] following = (byte[])Array$.MODULE$.ofDim(row.length + 1, ClassTag$.MODULE$.Byte());
        System.arraycopy(row, 0, following, 0, row.length);
        following[row.length] = this.ZeroByte();
        return var2_2;
    }

    public Seq<Tuple2<byte[], byte[]>> splitRange(byte[] start, byte[] stop, int splits) {
        Seq seq;
        Predef$.MODULE$.require(splits > 0 && splits < 256, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Splits must be greater than 0 and less than 256";
            }
        });
        if (splits == 1) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)start, (Object)stop)}));
        } else if (start.length == 0 && stop.length == 0 || Arrays.equals(this.rowFollowingPrefix(start), stop)) {
            int increment = 256 / splits;
            IndexedSeq bytes = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), splits).map((Function1)new Serializable(start, increment){
                public static final long serialVersionUID = 0L;
                private final byte[] start$1;
                private final int increment$1;

                public final byte[] apply(int i) {
                    return (byte[])Predef$.MODULE$.byteArrayOps(this.start$1).$colon$plus((Object)BoxesRunTime.boxToByte((byte)((byte)(i * this.increment$1 & IndexAdapter$.MODULE$.MaxByte()))), ClassTag$.MODULE$.Byte());
                }
                {
                    this.start$1 = start$1;
                    this.increment$1 = increment$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Tuple2 first = new Tuple2((Object)start, bytes.head());
            Tuple2 last = new Tuple2(bytes.last(), (Object)stop);
            GenTraversable middle = bytes.length() == 1 ? Seq$.MODULE$.empty() : bytes.sliding(2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<byte[], byte[]> apply(IndexedSeq<byte[]> x0$1) {
                    IndexedSeq<byte[]> indexedSeq = x0$1;
                    Some some = Seq$.MODULE$.unapplySeq(indexedSeq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        byte[] l = (byte[])((SeqLike)some.get()).apply(0);
                        byte[] r = (byte[])((SeqLike)some.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)l, (Object)r);
                        return tuple2;
                    }
                    throw new MatchError(indexedSeq);
                }
            });
            seq = (Seq)((SeqLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{first}))).$plus$plus((GenTraversableOnce)middle, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)last, Seq$.MODULE$.canBuildFrom());
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not splitting range [", ",", "] - "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteArrays$.MODULE$.toHex(start), ByteArrays$.MODULE$.toHex(stop)}))).append((Object)"may want to consider implementing further split logic").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)start, (Object)stop)}));
        }
        return seq;
    }

    private IndexAdapter$() {
        MODULE$ = this;
        this.ZeroByte = (byte)0;
        this.MaxByte = (byte)255;
    }
}

