/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Shorts;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Date;
import org.joda.time.DateTime;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.LegacyZ3SFC;
import org.locationtech.geomesa.curve.LegacyZ3SFC$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$class;
import org.locationtech.geomesa.index.index.Z3Index$;
import org.locationtech.geomesa.index.index.Z3IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public final class Z3Index$
implements IndexKeySpace<Z3IndexValues> {
    public static final Z3Index$ MODULE$;
    private final int indexKeyLength;

    static {
        new Z3Index$();
    }

    @Override
    public boolean toIndexKey$default$2() {
        return IndexKeySpace$class.toIndexKey$default$2(this);
    }

    @Override
    public int indexKeyLength() {
        return this.indexKeyLength;
    }

    @Override
    public boolean supports(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    @Override
    public Function1<SimpleFeature, byte[]> toIndexKey(SimpleFeatureType sft, boolean lenient) {
        LegacyZ3SFC sfc = LegacyZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Z3 index requires a valid date");
            }
        }));
        return new Serializable(lenient, sfc, timeToIndex, geomIndex, dtgIndex){
            public static final long serialVersionUID = 0L;
            private final boolean lenient$1;
            private final LegacyZ3SFC sfc$1;
            private final Function1 timeToIndex$1;
            private final int geomIndex$1;
            private final int dtgIndex$1;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final byte[] apply(SimpleFeature feature) {
                Tuple2 tuple2;
                Point geom = (Point)feature.getAttribute(this.geomIndex$1);
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                Date dtg = (Date)feature.getAttribute(this.dtgIndex$1);
                long time = dtg == null ? 0L : dtg.getTime();
                BinnedTime binnedTime = (BinnedTime)this.timeToIndex$1.apply((Object)BoxesRunTime.boxToLong((long)time));
                if (binnedTime == null) throw new MatchError((Object)binnedTime);
                short b = binnedTime.bin();
                long t = binnedTime.offset();
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
                short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long t2 = tuple22._2$mcJ$sp();
                try {
                    long z = this.sfc$1.index(geom.getX(), geom.getY(), t2, this.lenient$1);
                    return ByteArrays$.MODULE$.toBytes(b2, z);
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2, var3_3})), e);
                }
            }
            {
                this.lenient$1 = lenient$1;
                this.sfc$1 = sfc$1;
                this.timeToIndex$1 = timeToIndex$1;
                this.geomIndex$1 = geomIndex$1;
                this.dtgIndex$1 = dtgIndex$1;
            }
        };
    }

    @Override
    public Z3IndexValues getIndexValues(SimpleFeatureType sft, Filter filter2, Explainer explain) {
        String dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to execute a z3 query but the schema does not have a date");
            }
        });
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$10 = filter2;
        String x$11 = dtgField;
        boolean x$12 = true;
        boolean x$13 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$10, x$11, x$13, x$12);
        explain.apply((Function0<String>)new Serializable(geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable(intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        LegacyZ3SFC sfc = LegacyZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        long minTime = (long)sfc.time().min();
        long maxTime = (long)sfc.time().max();
        Seq wholePeriod = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(minTime, maxTime)}));
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint geometries or dates extracted, short-circuiting to empty query";
                }
            });
            return new Z3IndexValues((Z3SFC)sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<DateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)wholePeriod);
        }
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Seq$.MODULE$.empty());
        Function1 dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        intervals.foreach((Function1)new Serializable(minTime, maxTime, wholePeriod, timesByBin, dateToIndex, boundsToDates){
            public static final long serialVersionUID = 0L;
            private final long minTime$1;
            private final long maxTime$1;
            public final Seq wholePeriod$1;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Function1 dateToIndex$1;
            private final Function1 boundsToDates$1;

            public final void apply(Bounds<DateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.boundsToDates$1.apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    DateTime lower = (DateTime)tuple2._1();
                    DateTime upper = (DateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    DateTime lower2 = (DateTime)tuple23._1();
                    DateTime upper2 = (DateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.dateToIndex$1.apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex$1.apply((Object)upper2);
                        if (binnedTime2 != null) {
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (lb2 == ub2) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, ut2)})), Seq$.MODULE$.canBuildFrom()));
                            } else {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, this.maxTime$1)})), Seq$.MODULE$.canBuildFrom()));
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(this.minTime$1, ut2)})), Seq$.MODULE$.canBuildFrom()));
                                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.getIndexValues.4 $outer;

                                    public final void apply(int b) {
                                        this.apply$mcVI$sp(b);
                                    }

                                    public void apply$mcVI$sp(int b) {
                                        this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.wholePeriod$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            return;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.minTime$1 = minTime$1;
                this.maxTime$1 = maxTime$1;
                this.wholePeriod$1 = wholePeriod$1;
                this.timesByBin$1 = timesByBin$1;
                this.dateToIndex$1 = dateToIndex$1;
                this.boundsToDates$1 = boundsToDates$1;
            }
        });
        return new Z3IndexValues((Z3SFC)sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<DateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(minTime, maxTime)}))));
    }

    @Override
    public Iterator<Tuple2<byte[], byte[]>> getRanges(SimpleFeatureType sft, Z3IndexValues values) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Z3IndexValues z3IndexValues = values;
        if (z3IndexValues != null) {
            Tuple4 tuple4;
            Z3SFC sfc = z3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = z3IndexValues.spatialBounds();
            Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = z3IndexValues.temporalBounds();
            Seq<Tuple2<Object, Object>> wholePeriod = z3IndexValues.wholePeriod();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)sfc, xy, timesByBin, wholePeriod);
            Z3SFC sfc2 = (Z3SFC)tuple42._1();
            Seq xy2 = (Seq)tuple42._2();
            Map timesByBin2 = (Map)tuple42._3();
            Seq wholePeriod2 = (Seq)tuple42._4();
            Option rangeTarget = QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$9) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
                }
            });
            return timesByBin2.iterator().flatMap((Function1)new Serializable(sfc2, xy2, wholePeriod2, rangeTarget, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final Z3SFC sfc$2;
                private final Seq xy$1;
                private final Seq wholePeriod$2;
                private final Option rangeTarget$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final GenTraversableOnce<Tuple2<byte[], byte[]>> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$2) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        byte[] b = Shorts.toByteArray((short)bin);
                        Seq zs = times == this.wholePeriod$2 ? Z3Index$.MODULE$.org$locationtech$geomesa$index$index$Z3Index$$wholePeriodRanges$1(this.sfc$2, this.xy$1, this.wholePeriod$2, this.rangeTarget$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : Z3Index$.MODULE$.org$locationtech$geomesa$index$index$Z3Index$$toZRanges$1(times, this.sfc$2, this.xy$1, this.rangeTarget$1);
                        GenTraversableOnce genTraversableOnce = (GenTraversableOnce)zs.map((Function1)new Serializable(this, b){
                            public static final long serialVersionUID = 0L;
                            private final byte[] b$1;

                            public final Tuple2<byte[], byte[]> apply(IndexRange range) {
                                return new Tuple2((Object)ByteArrays$.MODULE$.toBytes(this.b$1, range.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(this.b$1, range.upper()));
                            }
                            {
                                this.b$1 = b$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return genTraversableOnce;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sfc$2 = sfc$2;
                    this.xy$1 = xy$1;
                    this.wholePeriod$2 = wholePeriod$2;
                    this.rangeTarget$1 = rangeTarget$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        throw new MatchError((Object)z3IndexValues);
    }

    public final Seq org$locationtech$geomesa$index$index$Z3Index$$toZRanges$1(Seq t, Z3SFC sfc$2, Seq xy$1, Option rangeTarget$1) {
        return sfc$2.ranges(xy$1, t, 64, rangeTarget$1);
    }

    private final Seq wholePeriodRanges$lzycompute$1(Z3SFC sfc$2, Seq xy$1, Seq wholePeriod$2, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        Z3Index$ z3Index$ = this;
        synchronized (z3Index$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = this.org$locationtech$geomesa$index$index$Z3Index$$toZRanges$1(wholePeriod$2, sfc$2, xy$1, rangeTarget$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public final Seq org$locationtech$geomesa$index$index$Z3Index$$wholePeriodRanges$1(Z3SFC sfc$2, Seq xy$1, Seq wholePeriod$2, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.wholePeriodRanges$lzycompute$1(sfc$2, xy$1, wholePeriod$2, rangeTarget$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    private Z3Index$() {
        MODULE$ = this;
        IndexKeySpace$class.$init$(this);
        this.indexKeyLength = 10;
    }
}

