/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatParser$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class Stat$ {
    public static final Stat$ MODULE$;
    private final Object ScalaMapSerializer;
    private final Object ScalaSeqSerializer;
    private final Object StatSerializer;
    private final Object GeometrySerializer;
    private final Object DateSerializer;
    private final Object DoubleSerializer;
    private final Object FloatSerializer;
    private final Gson JSON;

    static {
        new Stat$();
    }

    public Object ScalaMapSerializer() {
        return this.ScalaMapSerializer;
    }

    public Object ScalaSeqSerializer() {
        return this.ScalaSeqSerializer;
    }

    public Object StatSerializer() {
        return this.StatSerializer;
    }

    public Object GeometrySerializer() {
        return this.GeometrySerializer;
    }

    public Object DateSerializer() {
        return this.DateSerializer;
    }

    public Object DoubleSerializer() {
        return this.DoubleSerializer;
    }

    public Object FloatSerializer() {
        return this.FloatSerializer;
    }

    public Gson JSON() {
        return this.JSON;
    }

    public Stat apply(SimpleFeatureType sft, String s) {
        return StatParser$.MODULE$.parse(sft, s, StatParser$.MODULE$.parse$default$3());
    }

    public String Count() {
        return "Count()";
    }

    public String MinMax(String attribute2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MinMax(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2)}));
    }

    public String Enumeration(String attribute2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enumeration(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2)}));
    }

    public String TopK(String attribute2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TopK(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2)}));
    }

    public String Frequency(String attribute2, int precision) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frequency(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2), BoxesRunTime.boxToInteger((int)precision)}));
    }

    public String Frequency(String attribute2, String dtg, Enumeration.Value period, int precision) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frequency(", ",", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2), this.org$locationtech$geomesa$utils$stats$Stat$$safeString(dtg), period, BoxesRunTime.boxToInteger((int)precision)}));
    }

    public String Z3Frequency(String geom, String dtg, Enumeration.Value period, int precision) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Z3Frequency(", ",", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(geom), this.org$locationtech$geomesa$utils$stats$Stat$$safeString(dtg), period, BoxesRunTime.boxToInteger((int)precision)}));
    }

    public <T> String Histogram(String attribute2, int bins, T min, T max, ClassTag<T> ct) {
        Function1<Object, String> stringify = this.stringifier(ct.runtimeClass(), this.stringifier$default$2());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Histogram(", ",", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2), BoxesRunTime.boxToInteger((int)bins), this.org$locationtech$geomesa$utils$stats$Stat$$safeString((String)stringify.apply(min)), this.org$locationtech$geomesa$utils$stats$Stat$$safeString((String)stringify.apply(max))}));
    }

    public String Z3Histogram(String geom, String dtg, Enumeration.Value period, int length) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Z3Histogram(", ",", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(geom), this.org$locationtech$geomesa$utils$stats$Stat$$safeString(dtg), period, BoxesRunTime.boxToInteger((int)length)}));
    }

    public String IteratorStackCount() {
        return "IteratorStackCount()";
    }

    public String SeqStat(Seq<String> stats2) {
        return stats2.mkString(";");
    }

    public String GroupBy(String attribute2, Stat groupedStat) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GroupBy(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$utils$stats$Stat$$safeString(attribute2), groupedStat}));
    }

    public String DescriptiveStats(Seq<String> attributes) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DescriptiveStats(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return Stat$.MODULE$.org$locationtech$geomesa$utils$stats$Stat$$safeString(s);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")}));
    }

    public <T extends Stat> Option<T> combine(Seq<T> stats2) {
        Option option;
        if (stats2.length() < 2) {
            option = stats2.headOption();
        } else {
            Stat summed = ((Stat)stats2.head()).$plus((Stat)((IterableLike)stats2.tail()).head(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            ((IterableLike)stats2.drop(2)).foreach((Function1)new Serializable(summed){
                public static final long serialVersionUID = 0L;
                private final Stat summed$1;

                public final void apply(T x$1) {
                    this.summed$1.$plus$eq((Stat)x$1, Predef.DummyImplicit$.MODULE$.dummyImplicit());
                }
                {
                    this.summed$1 = summed$1;
                }
            });
            option = new Some((Object)summed);
        }
        return option;
    }

    public String org$locationtech$geomesa$utils$stats$Stat$$safeString(String s) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{StringEscapeUtils.escapeJava((String)s)}));
    }

    public <T> Function1<Object, String> stringifier(Class<T> clas, boolean json) {
        Object object;
        if (Geometry.class.isAssignableFrom(clas)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object v) {
                    return WKTUtils$.MODULE$.write((Geometry)v);
                }
            };
        } else {
            Class<T> clazz = clas;
            Class<Date> clazz2 = Date.class;
            object = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object v) {
                    return package$.MODULE$.GeoToolsDateFormat().format(((Date)v).toInstant());
                }
            } : new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object v) {
                    return v.toString();
                }
            };
        }
        Serializable toString = object;
        return json && !Number.class.isAssignableFrom(clas) ? new Serializable((Function1)toString){
            public static final long serialVersionUID = 0L;
            private final Function1 toString$1;

            public final String apply(Object v) {
                return v == null ? "null" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString$1.apply(v)}));
            }
            {
                this.toString$1 = toString$1;
            }
        } : new Serializable((Function1)toString){
            public static final long serialVersionUID = 0L;
            private final Function1 toString$1;

            public final String apply(Object v) {
                return v == null ? "null" : (String)this.toString$1.apply(v);
            }
            {
                this.toString$1 = toString$1;
            }
        };
    }

    public <T> boolean stringifier$default$2() {
        return false;
    }

    public <T> Function1<String, T> destringifier(Class<T> clas) {
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Class<T> clazz = clas;
                                        Class<String> clazz2 = String.class;
                                        if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                        object = new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final T apply(String s) {
                                                String string2 = s;
                                                String string3 = "null";
                                                return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : s);
                                            }
                                        };
                                        break block3;
                                    }
                                    Class<T> clazz = clas;
                                    Class<Integer> clazz3 = Integer.class;
                                    if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final T apply(String s) {
                                            String string2 = s;
                                            String string3 = "null";
                                            return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt()));
                                        }
                                    };
                                    break block3;
                                }
                                Class<T> clazz = clas;
                                Class<Long> clazz4 = Long.class;
                                if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final T apply(String s) {
                                        String string2 = s;
                                        String string3 = "null";
                                        return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s)).toLong()));
                                    }
                                };
                                break block3;
                            }
                            Class<T> clazz = clas;
                            Class<Float> clazz5 = Float.class;
                            if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final T apply(String s) {
                                    String string2 = s;
                                    String string3 = "null";
                                    return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s)).toFloat()));
                                }
                            };
                            break block3;
                        }
                        Class<T> clazz = clas;
                        Class<Double> clazz6 = Double.class;
                        if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final T apply(String s) {
                                String string2 = s;
                                String string3 = "null";
                                return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s)).toDouble()));
                            }
                        };
                        break block3;
                    }
                    if (!Geometry.class.isAssignableFrom(clas)) break block8;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final T apply(String s) {
                            String string2 = s;
                            String string3 = "null";
                            return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : WKTUtils$.MODULE$.read(s));
                        }
                    };
                    break block3;
                }
                Class<T> clazz = clas;
                Class<Date> clazz7 = Date.class;
                if (clazz != null ? !clazz.equals(clazz7) : clazz7 != null) break block9;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final T apply(String s) {
                        String string2 = s;
                        String string3 = "null";
                        return (T)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? null : Date.from(LocalDateTime.parse(s, package$.MODULE$.GeoToolsDateFormat()).toInstant(ZoneOffset.UTC)));
                    }
                };
            }
            return object;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected class binding for stat attribute: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clas})));
    }

    private Stat$() {
        MODULE$ = this;
        this.ScalaMapSerializer = new JsonSerializer<Map<Object, Object>>(){

            public JsonElement serialize(Map<Object, Object> s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(JavaConverters$.MODULE$.mapAsJavaMapConverter(s).asJava());
            }
        };
        this.ScalaSeqSerializer = new JsonSerializer<Seq<Object>>(){

            public JsonElement serialize(Seq<Object> s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(JavaConverters$.MODULE$.seqAsJavaListConverter(s).asJava());
            }
        };
        this.StatSerializer = new JsonSerializer<Stat>(){

            public JsonElement serialize(Stat s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(s.toJsonObject());
            }
        };
        this.GeometrySerializer = new JsonSerializer<Geometry>(){

            public JsonElement serialize(Geometry g, Type t, JsonSerializationContext jsc) {
                return new JsonPrimitive(WKTUtils$.MODULE$.write(g));
            }
        };
        this.DateSerializer = new JsonSerializer<Date>(){

            public JsonElement serialize(Date d, Type t, JsonSerializationContext jsc) {
                return new JsonPrimitive(package$.MODULE$.GeoToolsDateFormat().format(d.toInstant()));
            }
        };
        this.DoubleSerializer = new JsonSerializer<Double>(){

            public JsonElement serialize(Double d, Type t, JsonSerializationContext jsc) {
                Double d2 = d;
                Object object = Double.isNaN(Predef$.MODULE$.Double2double(d2)) ? JsonNull.INSTANCE : (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)) ? new JsonPrimitive("Infinity") : (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)) ? new JsonPrimitive("+Infinity") : new JsonPrimitive((Number)d)));
                return object;
            }
        };
        this.FloatSerializer = new JsonSerializer<Float>(){

            public JsonElement serialize(Float f, Type t, JsonSerializationContext jsc) {
                Float f2 = f;
                Object object = Float.isNaN(Predef$.MODULE$.Float2float(f2)) ? JsonNull.INSTANCE : (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)) ? new JsonPrimitive("Infinity") : (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)) ? new JsonPrimitive("+Infinity") : new JsonPrimitive((Number)f)));
                return object;
            }
        };
        this.JSON = new GsonBuilder().serializeNulls().registerTypeAdapter(Double.TYPE, (Object)this.DoubleSerializer()).registerTypeAdapter(Double.class, (Object)this.DoubleSerializer()).registerTypeAdapter(Float.TYPE, (Object)this.FloatSerializer()).registerTypeAdapter(Float.class, (Object)this.FloatSerializer()).registerTypeHierarchyAdapter(Stat.class, (Object)this.StatSerializer()).registerTypeHierarchyAdapter(Geometry.class, (Object)this.GeometrySerializer()).registerTypeHierarchyAdapter(Date.class, (Object)this.DateSerializer()).registerTypeHierarchyAdapter(Map.class, (Object)this.ScalaMapSerializer()).registerTypeHierarchyAdapter(Seq.class, (Object)this.ScalaSeqSerializer()).create();
    }
}

