/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryReader;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryWriter;

public abstract class AbstractPointVector
implements GeometryVector<Point, FixedSizeListVector> {
    private final FixedSizeListVector vector;
    private final PointWriter writer;
    private final PointReader reader;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)new ArrowType.FixedSizeList(2), null, metadata);
    }

    protected AbstractPointVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new FixedSizeListVector(name, allocator, AbstractPointVector.createFieldType(metadata), null));
    }

    protected AbstractPointVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((FixedSizeListVector)container.addOrGet(name, AbstractPointVector.createFieldType(metadata), FixedSizeListVector.class));
    }

    protected AbstractPointVector(FixedSizeListVector vector) {
        if (vector.getDataVector().equals(ZeroVector.INSTANCE)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.vector = vector;
        this.writer = this.createWriter(vector);
        this.reader = this.createReader(vector);
    }

    protected abstract List<Field> getFields();

    protected abstract PointWriter createWriter(FixedSizeListVector var1);

    protected abstract PointReader createReader(FixedSizeListVector var1);

    public PointWriter getWriter() {
        return this.writer;
    }

    public PointReader getReader() {
        return this.reader;
    }

    @Override
    public FixedSizeListVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    public static abstract class PointReader
    extends AbstractGeometryReader<Point> {
        private static final GeometryFactory factory = new GeometryFactory();
        private final FixedSizeListVector.Accessor accessor;

        protected PointReader(FixedSizeListVector vector) {
            this.accessor = vector.getAccessor();
            this.setOrdinalAccessor(((FieldVector)vector.getChildrenFromFields().get(0)).getAccessor());
        }

        @Override
        public Point get(int index) {
            if (this.accessor.isNull(index)) {
                return null;
            }
            double y = this.readOrdinal(index * 2);
            double x = this.readOrdinal(index * 2 + 1);
            return factory.createPoint(new Coordinate(x, y));
        }

        public double getCoordinateY(int index) {
            return this.readOrdinal(index * 2);
        }

        public double getCoordinateX(int index) {
            return this.readOrdinal(index * 2 + 1);
        }

        @Override
        public int getValueCount() {
            return this.accessor.getValueCount();
        }

        @Override
        public int getNullCount() {
            return this.accessor.getNullCount();
        }
    }

    public static abstract class PointWriter
    extends AbstractGeometryWriter<Point> {
        private final FixedSizeListVector.Mutator mutator;

        protected PointWriter(FixedSizeListVector vector) {
            this.mutator = vector.getMutator();
            this.setOrdinalMutator(((FieldVector)vector.getChildrenFromFields().get(0)).getMutator());
        }

        @Override
        public void set(int index, Point geom) {
            if (geom == null) {
                this.mutator.setNull(index);
            } else {
                this.mutator.setNotNull(index);
                this.writeOrdinal(index * 2, geom.getY());
                this.writeOrdinal(index * 2 + 1, geom.getX());
            }
        }

        @Override
        public void setValueCount(int count) {
            this.mutator.setValueCount(count);
        }
    }
}

