_geomesa-hbase(){
  local cur prev;
  COMPREPLY=();
  cur="${COMP_WORDS[COMP_CWORD]}";
  prev="${COMP_WORDS[COMP_CWORD-1]}";

  if [[ "${COMP_WORDS[1]}" == "help" ]]; then
    COMPREPLY=( $(compgen -W "create-schema delete-catalog delete-features describe-schema env explain export help ingest keywords get-type-names remove-schema version-remote version get-sft-config gen-avro-schema stats-analyze stats-bounds stats-count stats-top-k stats-histogram convert export-bin configure classpath" ${cur}));
    return 0;
  fi;

  case ${COMP_CWORD} in
    1)
      COMPREPLY=( $(compgen -W "create-schema delete-catalog delete-features describe-schema env explain export help ingest keywords get-type-names remove-schema version-remote version get-sft-config gen-avro-schema stats-analyze stats-bounds stats-count stats-top-k stats-histogram convert export-bin configure classpath" ${cur}));
      ;;
    [2-9] | [1-9][0-9])
      if [[ "${cur}" =~ ^-[a-zA-Z-]?+$ ]]; then
        case ${COMP_WORDS[1]} in
                    create-schema)
              COMPREPLY=( $(compgen -W "--catalog --spec --dtg --feature-name --use-shared-tables" -- ${cur}));
              return 0;
              ;;
                  delete-catalog)
              COMPREPLY=( $(compgen -W "--catalog --force" -- ${cur}));
              return 0;
              ;;
                  delete-features)
              COMPREPLY=( $(compgen -W "--cql --catalog --feature-name" -- ${cur}));
              return 0;
              ;;
                  describe-schema)
              COMPREPLY=( $(compgen -W "--feature-name --catalog" -- ${cur}));
              return 0;
              ;;
                  env)
              COMPREPLY=( $(compgen -W "--concise --converters --list-sfts --describe-sfts --exclude-user-data --format --sfts --list-converters --describe-converters" -- ${cur}));
              return 0;
              ;;
                  explain)
              COMPREPLY=( $(compgen -W "--cql --feature-name --index --attributes --catalog" -- ${cur}));
              return 0;
              ;;
                  export)
              COMPREPLY=( $(compgen -W "--output-format --attributes --no-header --cql --max-features --catalog --feature-name --output --index --gzip --hints" -- ${cur}));
              return 0;
              ;;
                  help)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  ingest)
              COMPREPLY=( $(compgen -W "--threads --converter --input-format --feature-name --catalog --spec" -- ${cur}));
              return 0;
              ;;
                  keywords)
              COMPREPLY=( $(compgen -W "--list --feature-name --add --remove --removeAll --catalog" -- ${cur}));
              return 0;
              ;;
                  get-type-names)
              COMPREPLY=( $(compgen -W "--catalog" -- ${cur}));
              return 0;
              ;;
                  remove-schema)
              COMPREPLY=( $(compgen -W "--pattern --feature-name --force --catalog" -- ${cur}));
              return 0;
              ;;
                  version-remote)
              COMPREPLY=( $(compgen -W "--catalog" -- ${cur}));
              return 0;
              ;;
                  version)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  get-sft-config)
              COMPREPLY=( $(compgen -W "--exclude-user-data --catalog --feature-name --concise --format" -- ${cur}));
              return 0;
              ;;
                  gen-avro-schema)
              COMPREPLY=( $(compgen -W "--feature-name --spec" -- ${cur}));
              return 0;
              ;;
                  stats-analyze)
              COMPREPLY=( $(compgen -W "--catalog --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-bounds)
              COMPREPLY=( $(compgen -W "--cql --attributes --catalog --no-cache --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-count)
              COMPREPLY=( $(compgen -W "--cql --no-cache --feature-name --catalog" -- ${cur}));
              return 0;
              ;;
                  stats-top-k)
              COMPREPLY=( $(compgen -W "--no-cache --catalog --feature-name --attributes --cql" -- ${cur}));
              return 0;
              ;;
                  stats-histogram)
              COMPREPLY=( $(compgen -W "--catalog --bins --no-cache --cql --feature-name --attributes" -- ${cur}));
              return 0;
              ;;
                  convert)
              COMPREPLY=( $(compgen -W "--max-features --cql --output-format --no-header --converter --output --gzip --feature-name --spec --hints" -- ${cur}));
              return 0;
              ;;
                  export-bin)
              COMPREPLY=( $(compgen -W "--cql --geom-attribute --gzip --id-attribute --index --feature-name --no-header --dt-attribute --attributes --label-attribute --hints --output-format --output --catalog --max-features" -- ${cur}));
              return 0;
              ;;
                  configure)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  classpath)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
              esac;
      else
        compopt -o filenames -o nospace;
        COMPREPLY=( $(compgen -f "$2") );
      fi;
      return 0;
      ;;
    *)
      COMPREPLY=();
      ;;
  esac;
};
complete -F _geomesa-hbase geomesa-hbase;
complete -F _geomesa-hbase bin/geomesa-hbase;


       