/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import java.io.InputStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.features.ArrowSimpleFeature;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileReader$;
import org.locationtech.geomesa.arrow.io.reader.CachingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.reader.StreamingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.package$;

public final class SimpleFeatureArrowFileReader$ {
    public static final SimpleFeatureArrowFileReader$ MODULE$;

    static {
        new SimpleFeatureArrowFileReader$();
    }

    public SimpleFeatureArrowFileReader caching(InputStream is, BufferAllocator allocator) {
        return new CachingSimpleFeatureArrowFileReader(is, allocator);
    }

    public SimpleFeatureArrowFileReader streaming(Function0<InputStream> is, BufferAllocator allocator) {
        return new StreamingSimpleFeatureArrowFileReader(is, allocator);
    }

    public Map<String, ArrowDictionary> loadDictionaries(Seq<Field> fields, DictionaryProvider provider, SimpleFeatureVector.SimpleFeatureEncoding precision) {
        return ((TraversableOnce)fields.flatMap((Function1)new Serializable(provider, precision){
            public static final long serialVersionUID = 0L;
            public final DictionaryProvider provider$1;
            public final SimpleFeatureVector.SimpleFeatureEncoding precision$1;

            public final Seq<Tuple2<String, ArrowDictionary>> apply(Field field) {
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)field.getDictionary())).toSeq().map((Function1)new Serializable(this, field){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadDictionaries.1 $outer;
                    private final Field field$1;

                    public final Tuple2<String, ArrowDictionary> apply(DictionaryEncoding encoding) {
                        AttributeDescriptor descriptor = SimpleFeatureTypes$.MODULE$.createDescriptor((String)this.field$1.getMetadata().get(SimpleFeatureVector$.MODULE$.DescriptorKey()));
                        FieldVector vector = this.$outer.provider$1.lookup(encoding.getId()).getVector();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.field$1.getName()), (Object)ArrowDictionary$.MODULE$.create(encoding, vector, descriptor, this.$outer.precision$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.field$1 = field$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.provider$1 = provider$1;
                this.precision$1 = precision$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Function1<SimpleFeatureVector, Iterator<ArrowSimpleFeature>> features(SimpleFeatureType sft, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Option<Tuple2<String, Object>> sort, Map<String, ArrowDictionary> dictionaries2) {
        Option<Tuple2<String, Object>> option;
        block4: {
            Object object;
            block3: {
                Some some;
                Tuple2 tuple2;
                Filter optimized;
                block2: {
                    optimized = ArrowFilterOptimizer$.MODULE$.rewrite(filter, sft, dictionaries2);
                    option = sort;
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = new Serializable(optimized){
                        public static final long serialVersionUID = 0L;
                        private final Filter optimized$1;

                        public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$1) {
                            return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(x$1, this.optimized$1);
                        }
                        {
                            this.optimized$1 = optimized$1;
                        }
                    };
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                String field = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                int i = sft.indexOf(field);
                Class binding = sft.getDescriptor(i).getType().getBinding();
                Seq bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter, field, binding).values();
                object = bounds.isEmpty() ? new Serializable(optimized){
                    public static final long serialVersionUID = 0L;
                    private final Filter optimized$1;

                    public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$2) {
                        return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(x$2, this.optimized$1);
                    }
                    {
                        this.optimized$1 = optimized$1;
                    }
                } : new Serializable(skip, optimized, reverse, i, bounds){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureArrowFileReader.SkipIndicator skip$1;
                    private final Filter optimized$1;
                    private final boolean reverse$1;
                    private final int i$1;
                    private final Seq bounds$1;

                    public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$3) {
                        return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$sortedFeatures(x$3, this.optimized$1, this.skip$1, (Seq<Bounds<Comparable<Object>>>)this.bounds$1, this.i$1, this.reverse$1);
                    }
                    {
                        this.skip$1 = skip$1;
                        this.optimized$1 = optimized$1;
                        this.reverse$1 = reverse$1;
                        this.i$1 = i$1;
                        this.bounds$1 = bounds$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError(option);
    }

    public Iterator<ArrowSimpleFeature> org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(SimpleFeatureVector vector, Filter filter) {
        Iterator iterator;
        int total = vector.reader().getValueCount();
        if (total == 0) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            ArrowSimpleFeature feature = vector.reader().feature();
            Iterator all = package$.MODULE$.Iterator().range(0, total).map((Function1)new Serializable(vector, feature){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureVector vector$1;
                private final ArrowSimpleFeature feature$1;

                public final ArrowSimpleFeature apply(int i) {
                    this.vector$1.reader().load(i);
                    return this.feature$1;
                }
                {
                    this.vector$1 = vector$1;
                    this.feature$1 = feature$1;
                }
            });
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            iterator = !(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null) ? all : all.filter((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                private final Filter filter$1;

                public final boolean apply(Object x$1) {
                    return this.filter$1.evaluate(x$1);
                }
                {
                    this.filter$1 = filter$1;
                }
            });
        }
        return iterator;
    }

    public Iterator<ArrowSimpleFeature> org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$sortedFeatures(SimpleFeatureVector vector, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Seq<Bounds<Comparable<Object>>> filterBounds, int sortField, boolean reverse) {
        Iterator iterator;
        int total = vector.reader().getValueCount();
        if (total == 0 || skip.skip()) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            Bounds currentBatchBounds;
            ArrowSimpleFeature feature = vector.reader().feature();
            vector.reader().load(0);
            Bounds.Bound lo = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
            vector.reader().load(total - 1);
            Bounds.Bound hi = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
            Bounds bounds = currentBatchBounds = reverse ? new Bounds(hi, lo) : new Bounds(lo, hi);
            if (filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                public static final long serialVersionUID = 0L;
                private final Bounds currentBatchBounds$1;

                public final boolean apply(Bounds<Comparable<Object>> x$4) {
                    return Bounds$.MODULE$.intersection(x$4, this.currentBatchBounds$1).isDefined();
                }
                {
                    this.currentBatchBounds$1 = currentBatchBounds$1;
                }
            })) {
                Iterator all = package$.MODULE$.Iterator().range(0, vector.reader().getValueCount()).map((Function1)new Serializable(vector, feature){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureVector vector$2;
                    private final ArrowSimpleFeature feature$2;

                    public final ArrowSimpleFeature apply(int i) {
                        this.vector$2.reader().load(i);
                        return this.feature$2;
                    }
                    {
                        this.vector$2 = vector$2;
                        this.feature$2 = feature$2;
                    }
                });
                iterator = all.filter((Function1)new Serializable(filter){
                    public static final long serialVersionUID = 0L;
                    private final Filter filter$2;

                    public final boolean apply(Object x$1) {
                        return this.filter$2.evaluate(x$1);
                    }
                    {
                        this.filter$2 = filter$2;
                    }
                });
            } else {
                boolean hasMore = reverse ? filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                    public static final long serialVersionUID = 0L;
                    private final Bounds currentBatchBounds$1;

                    public final boolean apply(Bounds<Comparable<Object>> fb) {
                        return Bounds$.MODULE$.smallerLowerBound(fb.lower(), this.currentBatchBounds$1.lower()) == fb.lower();
                    }
                    {
                        this.currentBatchBounds$1 = currentBatchBounds$1;
                    }
                }) : filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                    public static final long serialVersionUID = 0L;
                    private final Bounds currentBatchBounds$1;

                    public final boolean apply(Bounds<Comparable<Object>> fb) {
                        return Bounds$.MODULE$.largerUpperBound(fb.upper(), this.currentBatchBounds$1.upper()) == fb.upper();
                    }
                    {
                        this.currentBatchBounds$1 = currentBatchBounds$1;
                    }
                });
                skip.skip_$eq(!hasMore);
                iterator = package$.MODULE$.Iterator().empty();
            }
        }
        return iterator;
    }

    private SimpleFeatureArrowFileReader$() {
        MODULE$ = this;
    }
}

