/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.BBOXExpandingFilterVisitor;
import org.geotools.process.vector.BarnesSurfaceInterpolator;
import org.geotools.process.vector.BilinearInterpolator;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="BarnesSurface", description="Uses Barnes Analysis to compute an interpolated surface over a set of irregular data points.")
public class BarnesSurfaceProcess
implements VectorProcess {
    private static final double METRES_PER_DEGREE = 111320.0;

    @DescribeResult(name="result", description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="valueAttr", description="Name of attribute containing the data value to be interpolated") String valueAttr, @DescribeParameter(name="dataLimit", description="Limit for the number of input features processed", min=0, max=1) Integer argDataLimit, @DescribeParameter(name="scale", description="Length scale for the interpolation, in units of the source data CRS", min=1, max=1) Double argScale, @DescribeParameter(name="convergence", description="Convergence factor for refinement (between 0 and 1, default 0.3)", min=0, max=1, defaultValue="0.3") Double argConvergence, @DescribeParameter(name="passes", description="Number of passes to compute (default = 2)", min=0, max=1) Integer argPasses, @DescribeParameter(name="minObservations", description="Minimum number of observations required to support a grid cell (default = 2)", min=0, max=1, defaultValue="2") Integer argMinObsCount, @DescribeParameter(name="maxObservationDistance", description="Maximum distance to an observation for it to support a grid cell, in units of the source CRS (default = 0, meaning all observations used)", defaultValue="0", min=0, max=1) Double argMaxObsDistance, @DescribeParameter(name="noDataValue", description="Value to use for NO_DATA cells (default = -999)", defaultValue="-999", min=0, max=1) Double argNoDataValue, @DescribeParameter(name="pixelsPerCell", description="Resolution of the computed grid in pixels per grid cell (default = 1)", defaultValue="1", min=0, max=1) Integer argPixelsPerCell, @DescribeParameter(name="queryBuffer", description="Distance to expand the query envelope by, in units of the source CRS (larger values provide a more stable surface)", min=0, max=1) Double argQueryBuffer, @DescribeParameter(name="outputBBOX", description="Bounding box for output") ReferencedEnvelope outputEnv, @DescribeParameter(name="outputWidth", description="Width of the output raster in pixels") Integer outputWidth, @DescribeParameter(name="outputHeight", description="Height of the output raster in pixels") Integer outputHeight, ProgressListener monitor) throws ProcessException {
        if (valueAttr == null || valueAttr.length() <= 0) {
            throw new IllegalArgumentException("Value attribute must be specified");
        }
        int dataLimit = 0;
        if (argDataLimit != null) {
            dataLimit = argDataLimit;
        }
        double lengthScale = argScale;
        double convergenceFactor = argConvergence != null ? argConvergence : 0.3;
        int passes = argPasses != null ? argPasses : 2;
        int minObsCount = argMinObsCount != null ? argMinObsCount : 2;
        double maxObsDistance = argMaxObsDistance != null ? argMaxObsDistance : 0.0;
        float noDataValue = (float)(argNoDataValue != null ? argNoDataValue : -999.0);
        int pixelsPerCell = 1;
        if (argPixelsPerCell != null && argPixelsPerCell > 1) {
            pixelsPerCell = argPixelsPerCell;
        }
        int gridWidth = outputWidth;
        int gridHeight = outputHeight;
        if (pixelsPerCell > 1) {
            gridWidth = outputWidth / pixelsPerCell;
            gridHeight = outputHeight / pixelsPerCell;
        }
        CoordinateReferenceSystem srcCRS = ((SimpleFeatureType)obsFeatures.getSchema()).getCoordinateReferenceSystem();
        CoordinateReferenceSystem dstCRS = outputEnv.getCoordinateReferenceSystem();
        MathTransform trans = null;
        try {
            trans = CRS.findMathTransform((CoordinateReferenceSystem)srcCRS, (CoordinateReferenceSystem)dstCRS);
        }
        catch (FactoryException e) {
            throw new ProcessException(e);
        }
        double distanceConversionFactor = BarnesSurfaceProcess.distanceConversionFactor(srcCRS, dstCRS);
        double dstLengthScale = lengthScale * distanceConversionFactor;
        double dstMaxObsDistance = maxObsDistance * distanceConversionFactor;
        Coordinate[] pts = null;
        try {
            pts = BarnesSurfaceProcess.extractPoints(obsFeatures, valueAttr, trans, dataLimit);
        }
        catch (CQLException e) {
            throw new ProcessException(e);
        }
        float[][] barnesGrid = this.createBarnesGrid(pts, dstLengthScale, convergenceFactor, passes, minObsCount, dstMaxObsDistance, noDataValue, outputEnv, gridWidth, gridHeight);
        float[][] outGrid = barnesGrid = BarnesSurfaceProcess.flipXY(barnesGrid);
        if (pixelsPerCell > 1) {
            outGrid = this.upsample(barnesGrid, noDataValue, outputWidth, outputHeight);
        }
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        GridCoverage2D gridCov = gcf.create((CharSequence)"values", outGrid, (org.opengis.geometry.Envelope)outputEnv);
        return gridCov;
    }

    private static double distanceConversionFactor(CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem dstCRS) {
        Unit dstUnit;
        Unit srcUnit = srcCRS.getCoordinateSystem().getAxis(0).getUnit();
        if (srcUnit == (dstUnit = dstCRS.getCoordinateSystem().getAxis(0).getUnit())) {
            return 1.0;
        }
        if (srcUnit == NonSI.DEGREE_ANGLE && dstUnit == SI.METER) {
            return 111320.0;
        }
        if (srcUnit == SI.METER && dstUnit == NonSI.DEGREE_ANGLE) {
            return 8.98311174991017E-6;
        }
        throw new IllegalStateException("Unable to convert distances from " + srcUnit + " to " + dstUnit);
    }

    private static float[][] flipXY(float[][] grid) {
        int xsize = grid.length;
        int ysize = grid[0].length;
        float[][] grid2 = new float[ysize][xsize];
        for (int ix = 0; ix < xsize; ++ix) {
            for (int iy = 0; iy < ysize; ++iy) {
                int iy2 = ysize - iy - 1;
                grid2[iy2][ix] = grid[ix][iy];
            }
        }
        return grid2;
    }

    private float[][] createBarnesGrid(Coordinate[] pts, double lengthScale, double convergenceFactor, int passes, int minObservationCount, double maxObservationDistance, float noDataValue, Envelope destEnv, int width, int height) {
        BarnesSurfaceInterpolator barnesInterp = new BarnesSurfaceInterpolator(pts);
        barnesInterp.setLengthScale(lengthScale);
        barnesInterp.setConvergenceFactor(convergenceFactor);
        barnesInterp.setPassCount(passes);
        barnesInterp.setMinObservationCount(minObservationCount);
        barnesInterp.setMaxObservationDistance(maxObservationDistance);
        barnesInterp.setNoData(noDataValue);
        float[][] grid = barnesInterp.computeSurface(destEnv, width, height);
        return grid;
    }

    private float[][] upsample(float[][] grid, float noDataValue, int width, int height) {
        BilinearInterpolator bi = new BilinearInterpolator(grid, noDataValue);
        float[][] outGrid = bi.interpolate(width, height, true);
        return outGrid;
    }

    public Query invertQuery(@DescribeParameter(name="queryBuffer", description="The distance by which to expand the query window", min=0, max=1) Double argQueryBuffer, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        double queryBuffer = 0.0;
        if (argQueryBuffer != null) {
            queryBuffer = argQueryBuffer;
        }
        targetQuery.setFilter(this.expandBBox(targetQuery.getFilter(), queryBuffer));
        targetQuery.setProperties(null);
        Hints hints = targetQuery.getHints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.0);
        return targetQuery;
    }

    private Filter expandBBox(Filter filter, double distance) {
        return (Filter)filter.accept((FilterVisitor)new BBOXExpandingFilterVisitor(distance, distance, distance, distance), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Coordinate[] extractPoints(SimpleFeatureCollection obsPoints, String attrName, MathTransform trans, int dataLimit) throws CQLException {
        ArrayList<Coordinate> ptList;
        block8: {
            Expression attrExpr = ECQL.toExpression((String)attrName);
            ptList = new ArrayList<Coordinate>();
            SimpleFeatureIterator obsIt = obsPoints.features();
            double[] srcPt = new double[2];
            double[] dstPt = new double[2];
            int i = 0;
            block5: while (true) {
                while (obsIt.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)obsIt.next();
                    double val = 0.0;
                    try {
                        if (dataLimit > 0 && i >= dataLimit) {
                            break block8;
                        }
                        ++i;
                        Object valObj = attrExpr.evaluate((Object)feature);
                        if (valObj == null) continue block5;
                        Number valNum = (Number)valObj;
                        val = valNum.doubleValue();
                        Geometry geom = (Geometry)feature.getDefaultGeometry();
                        Coordinate p = geom.getCoordinate();
                        srcPt[0] = p.x;
                        srcPt[1] = p.y;
                        trans.transform(srcPt, 0, dstPt, 0, 1);
                        Coordinate pobs = new Coordinate(dstPt[0], dstPt[1], val);
                        ptList.add(pobs);
                        continue block5;
                    }
                    catch (Exception exception) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                obsIt.close();
            }
        }
        Coordinate[] pts = CoordinateArrays.toCoordinateArray(ptList);
        return pts;
    }
}

