/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import redis.clients.util.SafeEncoder;

public class Tuple
implements Comparable<Tuple> {
    private byte[] element;
    private Double score;

    public Tuple(String element, Double score) {
        this.element = SafeEncoder.encode(element);
        this.score = score;
    }

    public Tuple(byte[] element, Double score) {
        this.element = element;
        this.score = score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (null != this.element) {
            for (byte b : this.element) {
                result = 31 * result + b;
            }
        }
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return !(this.element == null ? other.element != null : !Arrays.equals(this.element, other.element));
    }

    @Override
    public int compareTo(Tuple other) {
        if (this.score.doubleValue() == other.getScore() || Arrays.equals(this.element, other.element)) {
            return 0;
        }
        return this.score < other.getScore() ? -1 : 1;
    }

    public String getElement() {
        if (null != this.element) {
            return SafeEncoder.encode(this.element);
        }
        return null;
    }

    public byte[] getBinaryElement() {
        return this.element;
    }

    public double getScore() {
        return this.score;
    }

    public String toString() {
        return '[' + Arrays.toString(this.element) + ',' + this.score + ']';
    }
}

