/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.hbase;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.spark.hbase.HBaseGeoMesaRecordReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011qcR3p\u001b\u0016\u001c\u0018\r\u0013\"bg\u0016Le\u000e];u\r>\u0014X.\u0019;\u000b\u0005\r!\u0011!\u00025cCN,'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q\u0001\u0006\u0005\u0003\u0010-aqR\"\u0001\t\u000b\u0005E\u0011\u0012!C7baJ,G-^2f\u0015\t\u0019B#\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003+)\ta!\u00199bG\",\u0017BA\f\u0011\u0005-Ie\u000e];u\r>\u0014X.\u0019;\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0011\u0012AA5p\u0013\ti\"D\u0001\u0003UKb$\bCA\u0010'\u001b\u0005\u0001#BA\u0011#\u0003\u0019\u0019\u0018.\u001c9mK*\u00111\u0005J\u0001\bM\u0016\fG/\u001e:f\u0015\t)#\"A\u0004pa\u0016tw-[:\n\u0005\u001d\u0002#!D*j[BdWMR3biV\u0014X\r\u0005\u0002*a5\t!F\u0003\u0002,Y\u0005a1oY1mC2|wmZ5oO*\u0011QFL\u0001\tif\u0004Xm]1gK*\tq&A\u0002d_6L!!\r\u0016\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0002\"A\u000e\u0001\u000e\u0003\tAq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011(\u0001\u0005eK2,w-\u0019;f+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\t>\u0015\t\u0019!#\u0003\u0002@y\t)R*\u001e7uSR\u000b'\r\\3J]B,HOR8s[\u0006$\bBB!\u0001A\u0003%!(A\u0005eK2,w-\u0019;fA!I1\t\u0001a\u0001\u0002\u0004%\t\u0001R\u0001\u0004g\u001a$X#A#\u0011\u0005}1\u0015BA$!\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0002)\u000bqa\u001d4u?\u0012*\u0017\u000f\u0006\u0002L#B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n!QK\\5u\u0011\u001d\u0011\u0006*!AA\u0002\u0015\u000b1\u0001\u001f\u00132\u0011\u0019!\u0006\u0001)Q\u0005\u000b\u0006!1O\u001a;!\u0011%1\u0006\u00011AA\u0002\u0013\u0005q+A\u0003uC\ndW-F\u0001Y!\tIV,D\u0001[\u0015\tYF,A\u0003j]\u0012,\u0007P\u0003\u0002\u0004\r%\u0011aL\u0017\u0002\u0012\u0011\n\u000b7/\u001a$fCR,(/Z%oI\u0016D\b\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0001b\u0003%!\u0018M\u00197f?\u0012*\u0017\u000f\u0006\u0002LE\"9!kXA\u0001\u0002\u0004A\u0006B\u00023\u0001A\u0003&\u0001,\u0001\u0004uC\ndW\r\t\u0005\u0006M\u0002!IaZ\u0001\u0005S:LG\u000f\u0006\u0002LQ\")\u0011.\u001aa\u0001U\u0006!1m\u001c8g!\tYW.D\u0001m\u0015\tI'#\u0003\u0002oY\ni1i\u001c8gS\u001e,(/\u0019;j_:DQ\u0001\u001d\u0001\u0005BE\f\u0011bZ3u'Bd\u0017\u000e^:\u0015\u0005Il\bcA:yu6\tAO\u0003\u0002vm\u0006!Q\u000f^5m\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f;\u0003\t1K7\u000f\u001e\t\u0003\u001fmL!\u0001 \t\u0003\u0015%s\u0007/\u001e;Ta2LG\u000fC\u0003\u007f_\u0002\u0007q0A\u0004d_:$X\r\u001f;\u0011\u0007=\t\t!C\u0002\u0002\u0004A\u0011!BS8c\u0007>tG/\u001a=u\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t!c\u0019:fCR,'+Z2pe\u0012\u0014V-\u00193feR1\u00111BA\t\u0003+\u0001RaDA\u00071yI1!a\u0004\u0011\u00051\u0011VmY8sIJ+\u0017\rZ3s\u0011\u001d\t\u0019\"!\u0002A\u0002i\fQa\u001d9mSRDqA`A\u0003\u0001\u0004\t9\u0002E\u0002\u0010\u00033I1!a\u0007\u0011\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;")
public class GeoMesaHBaseInputFormat
extends InputFormat<Text, SimpleFeature>
implements LazyLogging {
    private final MultiTableInputFormat delegate;
    private SimpleFeatureType sft;
    private HBaseFeatureIndex table;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaHBaseInputFormat geoMesaHBaseInputFormat = this;
        synchronized (geoMesaHBaseInputFormat) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public MultiTableInputFormat delegate() {
        return this.delegate;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    public HBaseFeatureIndex table() {
        return this.table;
    }

    public void table_$eq(HBaseFeatureIndex x$1) {
        this.table = x$1;
    }

    private void init(Configuration conf) {
        if (this.sft() == null) {
            this.sft_$eq(GeoMesaConfigurator$.MODULE$.getSchema(conf));
            this.table_$eq(HBaseFeatureIndex$.MODULE$.index(GeoMesaConfigurator$.MODULE$.getIndexIn(conf)));
            this.delegate().setConf(conf);
            HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
            HBaseDataStoreFactory$.MODULE$.configureSecurity(conf);
            conf.set("hbase.mapreduce.inputtable", GeoMesaConfigurator$.MODULE$.getTable(conf));
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<InputSplit> getSplits(JobContext context) {
        void var2_2;
        BoxedUnit boxedUnit;
        this.init(context.getConfiguration());
        List splits = this.delegate().getSplits(context);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " splits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)splits.size())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public RecordReader<Text, SimpleFeature> createRecordReader(InputSplit split, TaskAttemptContext context) {
        this.init(context.getConfiguration());
        RecordReader rr = this.delegate().createRecordReader(split, context);
        Option transformSchema = GeoMesaConfigurator$.MODULE$.getTransformSchema(context.getConfiguration());
        SimpleFeatureType schema = (SimpleFeatureType)transformSchema.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaHBaseInputFormat $outer;

            public final SimpleFeatureType apply() {
                return this.$outer.sft();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option q = GeoMesaConfigurator$.MODULE$.getFilter(context.getConfiguration()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Filter apply(String f) {
                return ECQL.toFilter((String)f);
            }
        });
        return new HBaseGeoMesaRecordReader(schema, this.table(), (RecordReader<ImmutableBytesWritable, Result>)rr, (Option<Filter>)q, (Option<SimpleFeatureType>)None$.MODULE$);
    }

    public GeoMesaHBaseInputFormat() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.delegate = new MultiTableInputFormat();
    }
}

