/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.redis;

import com.typesafe.config.Config;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.EnrichmentCacheFactory;
import org.locationtech.geomesa.convert.redis.RedisConnectionBuilder;
import org.locationtech.geomesa.convert.redis.RedisEnrichmentCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\tY\"+\u001a3jg\u0016s'/[2i[\u0016tGoQ1dQ\u00164\u0015m\u0019;pefT!a\u0001\u0003\u0002\u000bI,G-[:\u000b\u0005\u00151\u0011aB2p]Z,'\u000f\u001e\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005Y)eN]5dQ6,g\u000e^\"bG\",g)Y2u_JL\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0011 \u0003)\u0019\u0017M\u001c)s_\u000e,7o\u001d\u000b\u0003A\r\u0002\"aD\u0011\n\u0005\t\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006Iu\u0001\r!J\u0001\u0005G>tg\r\u0005\u0002'[5\tqE\u0003\u0002)S\u000511m\u001c8gS\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u0005\u0019\u0019uN\u001c4jO\")\u0001\u0007\u0001C!c\u0005)!-^5mIR\u0011!'\u000e\t\u0003+MJ!\u0001\u000e\u0003\u0003\u001f\u0015s'/[2i[\u0016tGoQ1dQ\u0016DQ\u0001J\u0018A\u0002\u0015BQa\u000e\u0001\u0005\na\nQ\u0002]1sg\u0016\u0014V\rZ5t+JcECA\u001dE!\ry!\bP\u0005\u0003wA\u0011Q!\u0011:sCf\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\t1\fgn\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eH\u0001\u0004TiJLgn\u001a\u0005\u0006\u000bZ\u0002\rAR\u0001\u0004kJd\u0007CA$K\u001d\ty\u0001*\u0003\u0002J!\u00051\u0001K]3eK\u001aL!aQ&\u000b\u0005%\u0003\u0002")
public class RedisEnrichmentCacheFactory
implements EnrichmentCacheFactory {
    public boolean canProcess(Config conf) {
        return conf.hasPath("type") && conf.getString("type").equals("redis");
    }

    public EnrichmentCache build(Config conf) {
        String[] stringArray = this.parseRedisURL(conf.getString("redis-url"));
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String host = (String)((SeqLike)option.get()).apply(0);
            String port = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)host, (Object)port);
            String host2 = (String)tuple22._1();
            String port2 = (String)tuple22._2();
            long timeout = conf.hasPath("expiration") ? conf.getLong("expiration") : -1L;
            RedisConnectionBuilder connBuilder = new RedisConnectionBuilder(this, host2, port2){
                private final JedisPool pool;

                public JedisPool pool() {
                    return this.pool;
                }

                public Jedis getConn() {
                    return this.pool().getResource();
                }
                {
                    this.pool = new JedisPool(host$1, new StringOps(Predef$.MODULE$.augmentString(port$1)).toInt());
                }
            };
            boolean localCache = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Config conf$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.conf$1.getBoolean("local-cache");
                }
                {
                    this.conf$1 = conf$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }));
            return new RedisEnrichmentCache(connBuilder, timeout, localCache);
        }
        throw new MatchError((Object)stringArray);
    }

    private String[] parseRedisURL(String url) {
        return url.indexOf(":") != -1 ? url.split(":") : (String[])((Object[])new String[]{url, "6379"});
    }
}

