/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.geotools.ows.ServiceException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServiceExceptionParser {
    public static ServiceException parse(InputStream inputStream) throws JDOMException, IOException {
        ServiceException exception;
        int i;
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(inputStream);
        Element root = document.getRootElement();
        List serviceExceptions = root.getChildren("ServiceException");
        ArrayList<ServiceException> codes = new ArrayList<ServiceException>();
        ArrayList<ServiceException> noCodes = new ArrayList<ServiceException>();
        for (int i2 = 0; i2 < serviceExceptions.size(); ++i2) {
            Element element = (Element)serviceExceptions.get(i2);
            ServiceException exception2 = ServiceExceptionParser.parseSE(element);
            if (exception2.getCode() != null && exception2.getCode().length() != 0) {
                codes.add(exception2);
                continue;
            }
            noCodes.add(exception2);
        }
        ServiceException firstException = null;
        ServiceException recentException = null;
        for (i = 0; i < codes.size(); ++i) {
            exception = (ServiceException)codes.get(i);
            if (firstException == null) {
                firstException = exception;
                recentException = exception;
                continue;
            }
            recentException.setNext(exception);
            recentException = exception;
        }
        codes = null;
        for (i = 0; i < noCodes.size(); ++i) {
            exception = (ServiceException)noCodes.get(i);
            if (firstException == null) {
                firstException = exception;
                recentException = exception;
                continue;
            }
            recentException.setNext(exception);
            recentException = exception;
        }
        noCodes = null;
        return firstException;
    }

    private static ServiceException parseSE(Element element) {
        String errorMessage = element.getText();
        String code = element.getAttributeValue("code");
        return new ServiceException(errorMessage, code);
    }
}

