/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class GeometryConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Geometry.class.isAssignableFrom(target)) {
            if (String.class.equals((Object)source)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        return new WKTReader2().read((String)source);
                    }
                };
            }
            if (Envelope.class.isAssignableFrom(source)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Envelope e = (Envelope)source;
                        GeometryFactory factory = new GeometryFactory();
                        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMinX(), e.getMinY())}), null);
                    }
                };
            }
        }
        if (Geometry.class.isAssignableFrom(source)) {
            if (Envelope.class.equals((Object)target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Geometry geometry = (Geometry)source;
                        return geometry.getEnvelopeInternal();
                    }
                };
            }
            if (String.class.equals((Object)target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Geometry geometry = (Geometry)source;
                        return geometry.toText();
                    }
                };
            }
        }
        return null;
    }
}

