/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import it.geosolutions.jaiext.affine.AffinePropertyGenerator;
import it.geosolutions.jaiext.affine.JaiI18N;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class AffineDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(AffineDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Affine"}, {"LocalName", "Affine"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", JaiI18N.getString("AffineDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AffineDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("AffineDescriptor1")}, {"arg1Desc", JaiI18N.getString("AffineDescriptor2")}, {"arg2Desc", JaiI18N.getString("AffineDescriptor3")}, {"arg3Desc", JaiI18N.getString("AffineDescriptor4")}, {"arg4Desc", JaiI18N.getString("AffineDescriptor5")}, {"arg5Desc", JaiI18N.getString("AffineDescriptor6")}, {"arg6Desc", JaiI18N.getString("AffineDescriptor7")}};
    private static final Class[] paramClasses = new Class[]{AffineTransform.class, Interpolation.class, double[].class, ROI.class, Boolean.class, Boolean.class, Range.class};
    private static final String[] paramNames = new String[]{"transform", "interpolation", "backgroundValues", "roi", "useROIAccessor", "setDestinationNoData", "nodata"};
    private static final Object[] paramDefaults = new Object[]{new AffineTransform(), Interpolation.getInstance((int)0), null, null, false, false, null};

    public AffineDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new AffinePropertyGenerator()};
        return pg;
    }

    protected boolean validateParameters(ParameterBlock args, StringBuffer message) {
        if (!super.validateParameters(args, message)) {
            return false;
        }
        AffineTransform transform = (AffineTransform)args.getObjectParameter(0);
        try {
            AffineTransform itransform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            message.append(this.getName() + " " + JaiI18N.getString("AffineDescriptor7"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, ROI roi, boolean useROIAccessor, boolean setDestinationNoData, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Affine", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("transform", (Object)transform);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        pb.setParameter("setDestinationNoData", setDestinationNoData);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("roi", (Object)roi);
            pb.setParameter("useROIAccessor", useROIAccessor);
        }
        return JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, ROI roi, boolean useROIAccessor, boolean setDestinationNoData, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Affine", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("transform", (Object)transform);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        pb.setParameter("setDestinationNoData", setDestinationNoData);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("roi", (Object)roi);
            pb.setParameter("useROIAccessor", useROIAccessor);
        }
        return JAI.createRenderable((String)"Affine", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

