/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.Bounds;
import org.locationtech.geomesa.utils.geohash.CoveringGeoHashes;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import scala.Array$;
import scala.Function$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BitSet;
import scala.collection.BitSet$;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class BoundingBox$
implements Serializable {
    public static final BoundingBox$ MODULE$;
    private final int DEFAULT_PRECISION;
    private GeometryFactory latLonGeoFactory;
    private volatile boolean bitmap$0;

    static {
        new BoundingBox$();
    }

    private GeometryFactory latLonGeoFactory$lzycompute() {
        BoundingBox$ boundingBox$ = this;
        synchronized (boundingBox$) {
            if (!this.bitmap$0) {
                this.latLonGeoFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                this.bitmap$0 = true;
            }
            return this.latLonGeoFactory;
        }
    }

    public int DEFAULT_PRECISION() {
        return this.DEFAULT_PRECISION;
    }

    public Envelope toEnvelope(BoundingBox bbox) {
        return bbox.envelope();
    }

    public Geometry toGeometry(BoundingBox bbox) {
        return bbox.geom();
    }

    public GeometryFactory latLonGeoFactory() {
        return this.bitmap$0 ? this.latLonGeoFactory : this.latLonGeoFactory$lzycompute();
    }

    public BoundingBox apply(double x1, double x2, double y1, double y2) {
        return this.apply(new Bounds(Math.min(x1, x2), Math.max(x1, x2)), new Bounds(Math.min(y1, y2), Math.max(y1, y2)));
    }

    public BoundingBox apply(Bounds lons, Bounds lats) {
        Bounds bounds = lats;
        if (bounds != null) {
            Tuple2.mcDD.sp sp2;
            double minLat = bounds.low();
            double maxLat = bounds.high();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(minLat, maxLat);
            double minLat2 = sp3._1$mcD$sp();
            double maxLat2 = sp3._2$mcD$sp();
            Bounds bounds2 = lons;
            if (bounds2 != null) {
                Tuple2.mcDD.sp sp4;
                double minLon = bounds2.low();
                double maxLon = bounds2.high();
                Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(minLon, maxLon);
                double minLon2 = sp5._1$mcD$sp();
                double maxLon2 = sp5._2$mcD$sp();
                return new BoundingBox(this.latLonGeoFactory().createPoint(new Coordinate(minLon2, minLat2)), this.latLonGeoFactory().createPoint(new Coordinate(maxLon2, maxLat2)));
            }
            throw new MatchError((Object)bounds2);
        }
        throw new MatchError((Object)bounds);
    }

    public BoundingBox apply(Envelope env) {
        return this.apply(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    public GeoHash geoHashFromEwkb(String ewkb, int precision) {
        byte[] b = Base64.decodeBase64((byte[])ewkb.getBytes());
        Geometry wkt = WKBUtils$.MODULE$.read(b);
        return GeoHash$.MODULE$.apply(wkt.getInteriorPoint().getY(), wkt.getInteriorPoint().getX(), precision);
    }

    public int geoHashFromEwkb$default$2() {
        return this.DEFAULT_PRECISION();
    }

    public double getAreaOfBoundingBox(BoundingBox bbox) {
        return bbox.geom().getArea();
    }

    public Polygon bboxToPoly(Point ll, Point ur) {
        return this.latLonGeoFactory().createPolygon(this.latLonGeoFactory().createLinearRing((Coordinate[])((Object[])new Coordinate[]{new Coordinate(ll.getX(), ll.getY()), new Coordinate(ll.getX(), ur.getY()), new Coordinate(ur.getX(), ur.getY()), new Coordinate(ur.getX(), ll.getY()), new Coordinate(ll.getX(), ll.getY())})), (LinearRing[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LinearRing.class)));
    }

    public boolean intersects(BoundingBox l, BoundingBox r) {
        return l.geom().intersects(r.geom());
    }

    public BoundingBox getCoveringBoundingBox(BoundingBox l, BoundingBox r) {
        double maxLon = package$.MODULE$.max(l.ur().getX(), r.ur().getX());
        double minLon = package$.MODULE$.min(l.ll().getX(), r.ll().getX());
        double maxLat = package$.MODULE$.max(l.ur().getY(), r.ur().getY());
        double minLat = package$.MODULE$.min(l.ll().getY(), r.ll().getY());
        return this.apply(new Bounds(minLon, maxLon), new Bounds(minLat, maxLat));
    }

    public List<String> getGeoHashesFromBoundingBox(BoundingBox bbox) {
        return this.getGeoHashesFromBoundingBox(bbox, 32, this.DEFAULT_PRECISION());
    }

    public List<String> getGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes, int precision) {
        return this.getMinBoxes$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHash[]{this.getCoveringGeoHash(bbox, precision)})), bbox, maxHashes, precision);
    }

    public int getGeoHashesFromBoundingBox$default$2() {
        return 32;
    }

    public int getGeoHashesFromBoundingBox$default$3() {
        return this.DEFAULT_PRECISION();
    }

    public CoveringGeoHashes getCoveringGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes) {
        return this.getCoveringGeoHashesFromBoundingBox(bbox, maxHashes, this.DEFAULT_PRECISION());
    }

    public CoveringGeoHashes getCoveringGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes, int precision) {
        return new CoveringGeoHashes((List<GeoHash>)((List)this.getGeoHashesFromBoundingBox(bbox, maxHashes, precision).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GeoHash apply(String x$3) {
                return GeoHash$.MODULE$.apply(x$3);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public GeoHash getCoveringGeoHash(BoundingBox bbox, int precision) {
        String ll = GeoHash$.MODULE$.apply(bbox.ll(), precision).hash();
        String ur = GeoHash$.MODULE$.apply(bbox.ur().getX() - 1.0E-12, bbox.ur().getY() - 1.0E-12, precision).hash();
        return GeoHash$.MODULE$.apply(((TraversableOnce)((GenericTraversableTemplate)((IterableLike)new StringOps(Predef$.MODULE$.augmentString(ll)).zip((GenIterable)Predef$.MODULE$.wrapString(ur), Predef$.MODULE$.fallbackStringCanBuildFrom())).takeWhile(Function$.MODULE$.tupled((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$4, char x$5) {
                return x$4 == x$5;
            }
        }))).unzip((Function1)Predef$.MODULE$.$conforms())._1()).mkString());
    }

    public int getCoveringGeoHashesFromBoundingBox$default$3() {
        return this.DEFAULT_PRECISION();
    }

    public Seq<GeoHash> generateSubGeoHashes(GeoHash hash2) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 31).map((Function1)new Serializable(hash2){
            public static final long serialVersionUID = 0L;
            public final GeoHash hash$1;

            public final GeoHash apply(int i) {
                IndexedSeq oneBits = (IndexedSeq)((TraversableLike)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(BoundingBox$.MODULE$.org$locationtech$geomesa$utils$geohash$BoundingBox$$padLongToString(i))).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            char ch2 = tuple2._1$mcC$sp();
                            boolean bl = ch2 != '0';
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateSubGeoHashes.1 $outer;

                    public final int apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int idx = tuple2._2$mcI$sp();
                            int n = this.$outer.hash$1.prec() + idx;
                            return n;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return GeoHash$.MODULE$.apply((BitSet)this.hash$1.bitset().$bar(BitSet$.MODULE$.apply((Seq)oneBits)), this.hash$1.prec() + 5);
            }
            {
                this.hash$1 = hash$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String org$locationtech$geomesa$utils$geohash$BoundingBox$$padLongToString(long i) {
        return String.format("%5s", RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    public BoundingBox apply(Point ll, Point ur) {
        return new BoundingBox(ll, ur);
    }

    public Option<Tuple2<Point, Point>> unapply(BoundingBox x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.ll(), (Object)x$0.ur()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final List getMinBoxes$1(List hashList, BoundingBox bbox$1, int maxHashes$1, int precision$1) {
        List childHashes;
        List hashes = (List)((TraversableLike)hashList.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<GeoHash> apply(GeoHash h) {
                return BoundingBox$.MODULE$.generateSubGeoHashes(h);
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(bbox$1){
            public static final long serialVersionUID = 0L;
            private final BoundingBox bbox$1;

            public final boolean apply(GeoHash hash2) {
                return BoundingBox$.MODULE$.intersects(this.bbox$1, hash2.bbox());
            }
            {
                this.bbox$1 = bbox$1;
            }
        });
        return hashes.size() < maxHashes$1 && hashes.size() > 0 && ((GeoHash)hashes.head()).prec() < precision$1 ? ((childHashes = this.getMinBoxes$1(hashes, bbox$1, maxHashes$1, precision$1)).size() > maxHashes$1 ? (List)hashes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeoHash hash2) {
                return hash2.hash();
            }
        }, List$.MODULE$.canBuildFrom()) : childHashes) : (List)hashes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeoHash hash2) {
                return hash2.hash();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private BoundingBox$() {
        MODULE$ = this;
        this.DEFAULT_PRECISION = 40;
    }
}

