/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$$anonfun$export$1$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3mS6LG/\u001a3FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0003\u0007\u000f\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJ\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\r]\u0014\u0018\u000e^3s!\tIC&D\u0001+\u0015\tYC#\u0001\u0002j_&\u0011QF\u000b\u0002\u0007/JLG/\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\naAZ8s[\u0006$\bCA\u0019D\u001d\t\u0011\u0004I\u0004\u00024}9\u0011A'\u0010\b\u0003kqr!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005er\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u007f\u0019\tQ!\u001e;jYNL!!\u0011\"\u0002\u0017\u0011\u000bG/\u0019$pe6\fGo\u001d\u0006\u0003\u007f\u0019I!\u0001R#\u0003\u0015\u0011\u000bG/\u0019$pe6\fGO\u0003\u0002B\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001*\u0001\u0006biR\u0014\u0018NY;uKN\u00042!\u0013'O\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB(qi&|g\u000e\u0005\u0002P):\u0011\u0001K\u0015\b\u0003gEK!!\u0002\u0004\n\u0005M#\u0011!D#ya>\u0014HoQ8n[\u0006tG-\u0003\u0002V-\n\u0001R\t\u001f9peR\fE\u000f\u001e:jEV$Xm\u001d\u0006\u0003'\u0012A\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!W\u0001\u000bo&$\b\u000eS3bI\u0016\u0014\bCA%[\u0013\tY&JA\u0004C_>dW-\u00198\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0015y\u0006-\u00192d!\tI\u0002\u0001C\u0003(9\u0002\u0007\u0001\u0006C\u000309\u0002\u0007\u0001\u0007C\u0003H9\u0002\u0007\u0001\nC\u0003Y9\u0002\u0007\u0011\fC\u0004f\u0001\t\u0007I\u0011\u00024\u0002\u000fA\u0014\u0018N\u001c;feV\tq\r\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006\u00191m\u001d<\u000b\u00051l\u0017aB2p[6|gn\u001d\u0006\u0003]2\ta!\u00199bG\",\u0017B\u00019j\u0005)\u00195K\u0016)sS:$XM\u001d\u0005\u0007e\u0002\u0001\u000b\u0011B4\u0002\u0011A\u0014\u0018N\u001c;fe\u0002BQ!\u0002\u0001\u0005BQ$\"!^=\u0011\u0007%ce\u000f\u0005\u0002Jo&\u0011\u0001P\u0013\u0002\u0005\u0019>tw\rC\u0003{g\u0002\u000710\u0001\u0005gK\u0006$XO]3t!\ra\u0018qA\u0007\u0002{*\u0011ap`\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005\u0005\u00111A\u0001\u0005I\u0006$\u0018MC\u0002\u0002\u00061\t\u0001bZ3pi>|Gn]\u0005\u0004\u0003\u0013i(aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t\u0011b\u001d;sS:<\u0017NZ=\u0015\t\u0005E\u0011q\u0004\t\u0005\u0003'\tIBD\u0002J\u0003+I1!a\u0006K\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003&\t\u0011\u0005\u0005\u00121\u0002a\u0001\u0003G\t\u0011a\u001c\t\u0004\u0013\u0006\u0015\u0012bAA\u0014\u0015\n\u0019\u0011I\\=\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.\u0005)1\r\\8tKR\u0011\u0011q\u0006\t\u0004\u0013\u0006E\u0012bAA\u001a\u0015\n!QK\\5u\u0001")
public class DelimitedExporter
implements FeatureExporter,
LazyLogging {
    private final Option<ExportCommand.ExportAttributes> attributes;
    private final boolean withHeader;
    private final CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer() {
        return this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    }

    @Override
    public Option<Object> export(SimpleFeatureCollection features) {
        BoxedUnit boxedUnit;
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        boolean withId = this.attributes.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ExportCommand.ExportAttributes x$1) {
                return x$1.fid();
            }
        });
        Seq names = (Seq)this.attributes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(ExportCommand.ExportAttributes x$2) {
                return x$2.names();
            }
        }).getOrElse((Function0)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Buffer<String> apply() {
                return (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.sft$1.getAttributeDescriptors()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor x$3) {
                        return x$3.getLocalName();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
            }
            {
                this.sft$1 = sft$1;
            }
        });
        if (this.withHeader) {
            if (withId) {
                this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)"id");
            }
            Seq headers = (Seq)((TraversableLike)names.map((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final AttributeDescriptor apply(String x$1) {
                    return this.sft$1.getDescriptor(x$1);
                }
                {
                    this.sft$1 = sft$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final String apply(AttributeDescriptor x$4) {
                    return SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, x$4);
                }
                {
                    this.sft$1 = sft$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().printRecord((Object[])headers.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        LongRef count = LongRef.create((long)0L);
        WithClose$.MODULE$.apply((Object)CloseableIterator$.MODULE$.apply((FeatureIterator)features.features()), (Function1)new Serializable(this, withId, names, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedExporter $outer;
            public final boolean withId$1;
            public final Seq names$1;
            public final LongRef count$1;

            public final void apply(CloseableIterator<SimpleFeature> features) {
                features.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$export$1 $outer;

                    public final void apply(SimpleFeature sf) {
                        if (this.$outer.withId$1) {
                            this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)sf.getID());
                        }
                        this.$outer.names$1.foreach((Function1)new Serializable(this, sf){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$export$1$$anonfun$apply$2 $outer;
                            private final SimpleFeature sf$1;

                            public final void apply(String name) {
                                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().stringify(this.sf$1.getAttribute(name)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.sf$1 = sf$1;
                            }
                        });
                        this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().println();
                        ++this.$outer.count$1.elem;
                        if (this.$outer.count$1.elem % 10000L == 0L) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrote ", " features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.count$1.elem)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }

                    public /* synthetic */ $anonfun$export$1 org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DelimitedExporter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.withId$1 = withId$1;
                this.names$1 = names$1;
                this.count$1 = count$1;
            }
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exported ", " features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count.elem)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    public String stringify(Object o) {
        String string;
        Object object = o;
        if (object == null) {
            string = "";
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            string = WKTUtils$.MODULE$.write(geometry);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        } else if (object instanceof List) {
            List list = (List)object;
            string = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(list).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Object o) {
                    return this.$outer.stringify(o);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            string = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(map).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.stringify(k), this.$outer.stringify(v)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = o.toString();
        }
        return string;
    }

    @Override
    public void close() {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().flush();
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().close();
    }

    public DelimitedExporter(Writer writer, Enumeration.Value format, Option<ExportCommand.ExportAttributes> attributes, boolean withHeader) {
        Enumeration.Value value;
        block4: {
            CSVPrinter cSVPrinter;
            block3: {
                block2: {
                    this.attributes = attributes;
                    this.withHeader = withHeader;
                    LazyLogging.class.$init$((LazyLogging)this);
                    value = format;
                    Enumeration.Value value2 = DataFormats$.MODULE$.Csv();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    cSVPrinter = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.MINIMAL).print((Appendable)writer);
                    break block3;
                }
                Enumeration.Value value4 = DataFormats$.MODULE$.Tsv();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                cSVPrinter = CSVFormat.TDF.withQuoteMode(QuoteMode.MINIMAL).print((Appendable)writer);
            }
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer = cSVPrinter;
            return;
        }
        throw new MatchError((Object)value);
    }
}

