/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AutoIngest;
import org.locationtech.geomesa.tools.ingest.ConverterIngest;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.ShapefileIngest;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;

public abstract class IngestCommand$class {
    public static void execute(IngestCommand $this) {
        Runnable runnable;
        $this.ensureSameFs(IngestCommand$.MODULE$.org$locationtech$geomesa$tools$ingest$IngestCommand$$RemotePrefixes());
        Enumeration.Value value = $this.params().fmt();
        Enumeration.Value value2 = DataFormats$.MODULE$.Shp();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            runnable = new ShapefileIngest(JavaConversions$.MODULE$.mapAsJavaMap($this.connection()), (Option<String>)Option$.MODULE$.apply((Object)$this.params().featureName()), (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), Predef$.MODULE$.Integer2int($this.params().threads()));
        } else if ($this.params().spec() == null && $this.params().config() == null && ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DataFormats$.MODULE$.Csv(), DataFormats$.MODULE$.Tsv(), DataFormats$.MODULE$.Avro()}))).contains((Object)$this.params().fmt())) {
            if ($this.params().featureName() == null) {
                throw new ParameterException("Feature name is required when a schema is not specified");
            }
            Command$.MODULE$.user().info("No schema or converter defined - will attempt to detect schema from input files");
            runnable = new AutoIngest($this.params().featureName(), $this.connection(), (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), $this.params().fmt(), $this.libjarsFile(), $this.libjarsPaths(), Predef$.MODULE$.Integer2int($this.params().threads()));
        } else {
            if ($this.params().config() == null) {
                throw new ParameterException("Converter Config argument is required");
            }
            if ($this.params().spec() == null) {
                throw new ParameterException("SimpleFeatureType specification argument is required");
            }
            SimpleFeatureType sft = CLArgResolver$.MODULE$.getSft($this.params().spec(), $this.params().featureName());
            Config converterConfig = CLArgResolver$.MODULE$.getConfig($this.params().config());
            runnable = $this.createConverterIngest(sft, converterConfig);
        }
        ShapefileIngest ingest = runnable;
        ingest.run();
    }

    public static Runnable createConverterIngest(IngestCommand $this, SimpleFeatureType sft, Config converterConfig) {
        return new ConverterIngest(sft, $this.connection(), converterConfig, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), $this.libjarsFile(), $this.libjarsPaths(), Predef$.MODULE$.Integer2int($this.params().threads()));
    }

    public static void ensureSameFs(IngestCommand $this, Seq prefixes) {
        prefixes.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestCommand $outer;

            public final void apply(String pre) {
                if (JavaConversions$.MODULE$.asScalaBuffer(this.$outer.params().files()).exists((Function1)new Serializable(this, pre){
                    public static final long serialVersionUID = 0L;
                    private final String pre$1;

                    public final boolean apply(String x$1) {
                        return x$1.toLowerCase().startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pre$1})));
                    }
                    {
                        this.pre$1 = pre$1;
                    }
                }) && !JavaConversions$.MODULE$.asScalaBuffer(this.$outer.params().files()).forall((Function1)new Serializable(this, pre){
                    public static final long serialVersionUID = 0L;
                    private final String pre$1;

                    public final boolean apply(String x$2) {
                        return x$2.toLowerCase().startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pre$1})));
                    }
                    {
                        this.pre$1 = pre$1;
                    }
                })) {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files must all be on the same file system: (", ") or all be local"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pre})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }
}

