/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.status;

import com.beust.jcommander.ParameterException;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.status.DescribeSchemaCommand;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.stats.IndexCoverage$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DescribeSchemaCommand$class {
    public static boolean hasSpatialIndex(DescribeSchemaCommand $this) {
        return true;
    }

    public static boolean hasSpatioTemporalIndex(DescribeSchemaCommand $this) {
        return true;
    }

    public static boolean hasAttributeIndex(DescribeSchemaCommand $this) {
        return true;
    }

    public static void execute(DescribeSchemaCommand $this) {
        $this.withDataStore(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeSchemaCommand $outer;

            public final void apply(DS ds) {
                SimpleFeatureType sft = this.$outer.getSchema(ds);
                if (sft == null) {
                    String string;
                    Object object = this.$outer.params();
                    if (object instanceof TypeNameParam) {
                        TypeNameParam typeNameParam = (TypeNameParam)object;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature '", "' not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeNameParam.featureName()}));
                    } else {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature type not found"})).s((Seq)Nil$.MODULE$);
                    }
                    String msg = string;
                    throw new ParameterException(msg);
                }
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Describing attributes of feature '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                this.$outer.describe(ds, sft, (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String x$1) {
                        Command$.MODULE$.output().info(x$1);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static SimpleFeatureType getSchema(DescribeSchemaCommand $this, DataStore ds) {
        Object object = $this.params();
        if (object instanceof TypeNameParam) {
            TypeNameParam typeNameParam = (TypeNameParam)object;
            SimpleFeatureType simpleFeatureType = ds.getSchema(typeNameParam.featureName());
            return simpleFeatureType;
        }
        throw new MatchError(object);
    }

    public static void describe(DescribeSchemaCommand $this, DataStore ds, SimpleFeatureType sft, Function1 output) {
        Buffer namesAndDescriptions = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeSchemaCommand $outer;
            private final SimpleFeatureType sft$1;

            public final Tuple3<String, String, ArrayBuffer<String>> apply(AttributeDescriptor descriptor) {
                String name = descriptor.getLocalName();
                ArrayBuffer description = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                AttributeDescriptor attributeDescriptor = descriptor;
                GeometryDescriptor geometryDescriptor = this.sft$1.getGeometryDescriptor();
                if (!(attributeDescriptor != null ? !attributeDescriptor.equals(geometryDescriptor) : geometryDescriptor != null)) {
                    if (this.$outer.hasSpatialIndex()) {
                        description.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Spatially indexed)"}));
                    }
                } else if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).contains((Object)name) && this.$outer.hasSpatioTemporalIndex()) {
                    description.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Spatio-temporally indexed)"}));
                }
                if (this.$outer.hasAttributeIndex()) {
                    Enumeration.Value value = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getIndexCoverage$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor));
                    Enumeration.Value value2 = IndexCoverage$.MODULE$.JOIN();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        description.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Attribute indexed - join)"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value4 = IndexCoverage$.MODULE$.FULL();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            description.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Attribute indexed)"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
                Option$.MODULE$.apply(descriptor.getDefaultValue()).foreach((Function1)new Serializable(this, description){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer description$1;

                    public final void apply(Object v) {
                        this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default Value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}))}));
                    }
                    {
                        this.description$1 = description$1;
                    }
                });
                return new Tuple3((Object)name, (Object)descriptor.getType().getBinding().getSimpleName(), (Object)description);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        int maxName = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndDescriptions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, String, ArrayBuffer<String>> x$1) {
                return ((String)x$1._1()).length();
            }
        }, Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int maxType = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndDescriptions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, String, ArrayBuffer<String>> x$2) {
                return ((String)x$2._2()).length();
            }
        }, Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        namesAndDescriptions.foreach((Function1)new Serializable($this, maxName, maxType, output){
            public static final long serialVersionUID = 0L;
            private final int maxName$1;
            private final int maxType$1;
            private final Function1 output$1;

            public final void apply(Tuple3<String, String, ArrayBuffer<String>> x0$1) {
                Tuple3<String, String, ArrayBuffer<String>> tuple3 = x0$1;
                if (tuple3 != null) {
                    String n = (String)tuple3._1();
                    String t = (String)tuple3._2();
                    ArrayBuffer d = (ArrayBuffer)tuple3._3();
                    BoxedUnit boxedUnit = (BoxedUnit)this.output$1.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(n)).padTo(this.maxName$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), new StringOps(Predef$.MODULE$.augmentString(t)).padTo(this.maxType$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), d.mkString(" ")})));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                void var4_4;
                this.maxName$1 = maxName$1;
                this.maxType$1 = maxType$1;
                this.output$1 = var4_4;
            }
        });
        java.util.Map userData = sft.getUserData();
        if (!userData.isEmpty()) {
            output.apply((Object)"\nUser data:");
            Map namesAndValues = (Map)JavaConversions$.MODULE$.mapAsScalaMap(userData).map((Function1)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final Tuple2<String, String> apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Object object = k;
                        String string = SimpleFeatureTypes.Configs$.MODULE$.KEYWORDS_KEY();
                        Tuple2 tuple22 = !(object != null ? !object.equals(string) : string != null) ? new Tuple2((Object)SimpleFeatureTypes.Configs$.MODULE$.KEYWORDS_KEY(), (Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).mkString("[\"", "\", \"", "\"]")) : new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sft$1 = sft$1;
                }
            }, Map$.MODULE$.canBuildFrom());
            int maxName2 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndValues.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, String> x$3) {
                    return ((String)x$3._1()).length();
                }
            }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            ((IterableLike)namesAndValues.toSeq().sortBy((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x$4) {
                    return (String)x$4._1();
                }
            }, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable($this, maxName2, output){
                public static final long serialVersionUID = 0L;
                private final int maxName$2;
                private final Function1 output$1;

                public final void apply(Tuple2<String, String> x0$3) {
                    Tuple2<String, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String n = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        BoxedUnit boxedUnit = (BoxedUnit)this.output$1.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(n)).padTo(this.maxName$2, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), v})));
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    void var3_3;
                    this.maxName$2 = maxName$2;
                    this.output$1 = var3_3;
                }
            });
        }
    }

    public static void $init$(DescribeSchemaCommand $this) {
        $this.org$locationtech$geomesa$tools$status$DescribeSchemaCommand$_setter_$name_$eq("describe-schema");
    }
}

