/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.orderdither;

import it.geosolutions.jaiext.orderdither.JaiI18N;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ColorCube;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public class OrderedDitherDescriptor
extends OperationDescriptorImpl {
    public OrderedDitherDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "OrderedDither"}, {"LocalName", "OrderedDither"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", JaiI18N.getString("OrderedDitherDescriptor0")}, {"DocURL", ""}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("OrderedDitherDescriptor1")}, {"arg1Desc", JaiI18N.getString("OrderedDitherDescriptor2")}, {"arg2Desc", JaiI18N.getString("OrderedDitherDescriptor3")}, {"arg3Desc", JaiI18N.getString("OrderedDitherDescriptor4")}, {"arg4Desc", JaiI18N.getString("OrderedDitherDescriptor5")}}, new String[]{"rendered"}, 1, new String[]{"colorMap", "ditherMask", "roi", "nodata", "destNoData"}, new Class[]{ColorCube.class, KernelJAI[].class, ROI.class, Range.class, Double.class}, new Object[]{ColorCube.BYTE_496, KernelJAI.DITHER_MASK_443, null, null, 0.0}, null);
    }

    private static boolean isValidColorMap(RenderedImage sourceImage, ColorCube colorMap, StringBuffer msg) {
        SampleModel srcSampleModel = sourceImage.getSampleModel();
        if (colorMap.getDataType() != srcSampleModel.getTransferType()) {
            msg.append(JaiI18N.getString("OrderedDitherDescriptor6"));
            return false;
        }
        if (colorMap.getNumBands() != srcSampleModel.getNumBands()) {
            msg.append(JaiI18N.getString("OrderedDitherDescriptor7"));
            return false;
        }
        return true;
    }

    private static boolean isValidDitherMask(RenderedImage sourceImage, KernelJAI[] ditherMask, StringBuffer msg) {
        if (ditherMask.length != sourceImage.getSampleModel().getNumBands()) {
            msg.append(JaiI18N.getString("OrderedDitherDescriptor8"));
            return false;
        }
        int maskWidth = ditherMask[0].getWidth();
        int maskHeight = ditherMask[0].getHeight();
        for (int band = 0; band < ditherMask.length; ++band) {
            if (ditherMask[band].getWidth() != maskWidth || ditherMask[band].getHeight() != maskHeight) {
                msg.append(JaiI18N.getString("OrderedDitherDescriptor9"));
                return false;
            }
            float[] kernelData = ditherMask[band].getKernelData();
            for (int i = 0; i < kernelData.length; ++i) {
                if (!(kernelData[i] < 0.0f) && !((double)kernelData[i] > 1.0)) continue;
                msg.append(JaiI18N.getString("OrderedDitherDescriptor10"));
                return false;
            }
        }
        return true;
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer msg) {
        if (!super.validateArguments(modeName, args, msg)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage src = args.getRenderedSource(0);
        ColorCube colorMap = (ColorCube)args.getObjectParameter(0);
        KernelJAI[] ditherMask = (KernelJAI[])args.getObjectParameter(1);
        if (!OrderedDitherDescriptor.isValidColorMap(src, colorMap, msg)) {
            return false;
        }
        return OrderedDitherDescriptor.isValidDitherMask(src, ditherMask, msg);
    }

    public static RenderedOp create(RenderedImage source0, ColorCube colorMap, KernelJAI[] ditherMask, RenderingHints hints, ROI roi, Range nodata, Double destNoData) {
        ParameterBlockJAI pb = new ParameterBlockJAI("OrderedDither", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("colorMap", (Object)colorMap);
        pb.setParameter("ditherMask", (Object)ditherMask);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        pb.setParameter("destNoData", (Object)destNoData);
        return JAI.create((String)"OrderedDither", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

