/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.google.protobuf.ByteString;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HBaseDataStoreFactory$
implements LazyLogging {
    public static final HBaseDataStoreFactory$ MODULE$;
    private final String DisplayName;
    private final String Description;
    private final String HBaseGeoMesaPrincipal;
    private final String HBaseGeoMesaKeyTab;
    private final String BigTableParamCheck;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HBaseDataStoreFactory$();
    }

    private Logger logger$lzycompute() {
        HBaseDataStoreFactory$ hBaseDataStoreFactory$ = this;
        synchronized (hBaseDataStoreFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String DisplayName() {
        return this.DisplayName;
    }

    public String Description() {
        return this.Description;
    }

    public String HBaseGeoMesaPrincipal() {
        return this.HBaseGeoMesaPrincipal;
    }

    public String HBaseGeoMesaKeyTab() {
        return this.HBaseGeoMesaKeyTab;
    }

    public String BigTableParamCheck() {
        return this.BigTableParamCheck;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return params.containsKey(HBaseDataStoreParams$.MODULE$.BigTableNameParam().key) && Option$.MODULE$.apply((Object)HBaseConfiguration.create().get(this.BigTableParamCheck())).forall((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.trim().isEmpty();
            }
        });
    }

    public AuthorizationsProvider buildAuthsProvider(Connection connection, Map<String, Serializable> params) {
        Option forceEmptyOpt = GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupOpt$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(package$.MODULE$.ForceEmptyAuthsParam()), params);
        boolean forceEmptyAuths = BoxesRunTime.unboxToBoolean((Object)forceEmptyOpt.getOrElse((Function0)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Boolean apply() {
                return Boolean.FALSE;
            }
        }));
        if (VisibilityClient.isCellVisibilityEnabled((Connection)connection)) {
            String userName = User.getCurrent().getName();
            Buffer masterAuths = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(VisibilityClient.getAuths((Connection)connection, (String)userName).getAuthList()).map((Function1)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(ByteString a) {
                    return Bytes.toString((byte[])a.toByteArray());
                }
            }, Buffer$.MODULE$.canBuildFrom());
            String[] configuredAuths = (String[])Predef$.MODULE$.refArrayOps((Object[])((String)GeoMesaDataStoreFactory.RichParam$.MODULE$.lookupOpt$extension(GeoMesaDataStoreFactory$.MODULE$.RichParam(HBaseDataStoreParams$.MODULE$.AuthsParam()), params).getOrElse((Function0)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).split(",")).filter((Function1)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String s) {
                    return !s.isEmpty();
                }
            });
            String[] invalidAuths = (String[])Predef$.MODULE$.refArrayOps((Object[])configuredAuths).filterNot((Function1)new scala.Serializable(masterAuths){
                public static final long serialVersionUID = 0L;
                private final Buffer masterAuths$1;

                public final boolean apply(Object elem) {
                    return this.masterAuths$1.contains(elem);
                }
                {
                    this.masterAuths$1 = masterAuths$1;
                }
            });
            if (Predef$.MODULE$.refArrayOps((Object[])invalidAuths).nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The authorizations '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])invalidAuths).mkString(",")}))).append((Object)"are not valid for the HBase user and connection being used").toString());
            }
            if (configuredAuths.length != 0 && forceEmptyAuths) {
                throw new IllegalArgumentException("Forcing empty auths is checked, but explicit auths are provided");
            }
            List auths = forceEmptyAuths || configuredAuths.length > 0 ? Predef$.MODULE$.refArrayOps((Object[])configuredAuths).toList() : masterAuths.toList();
            return package$.MODULE$.getAuthorizationsProvider(params, (Seq)auths);
        }
        throw new IllegalArgumentException("HBase cell visibility is not enabled on cluster");
    }

    /*
     * Unable to fully structure code
     */
    public void configureSecurity(Configuration conf) {
        block13: {
            block12: {
                auth = conf.get("hbase.security.authentication");
                var3_3 = auth;
                if (!"kerberos".equals(var3_3)) break block12;
                authMethod = SecurityUtil.getAuthenticationMethod((Configuration)conf);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Auth method: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authMethod})));
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                v1 = authMethod;
                var6_5 = UserGroupInformation.AuthenticationMethod.KERBEROS;
                if (v1 != null ? v1.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                v2 = authMethod;
                var7_6 = UserGroupInformation.AuthenticationMethod.KERBEROS_SSL;
                if (!(v2 != null ? v2.equals(var7_6) == false : var7_6 != null)) {
                    v3 = BoxedUnit.UNIT;
                } else if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HBase is configured to used Kerberos.  The Hadoop configuration is missing or not configured to use Kerberos."})).s((Seq)Nil$.MODULE$));
                    v3 = BoxedUnit.UNIT;
                } else {
                    v3 = BoxedUnit.UNIT;
                }
                UserGroupInformation.setConfiguration((Configuration)conf);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Is Hadoop security enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)UserGroupInformation.isSecurityEnabled())})));
                    v4 = BoxedUnit.UNIT;
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Kerberos with principal ", " and file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(this.HBaseGeoMesaPrincipal()), conf.get(this.HBaseGeoMesaKeyTab())})));
                    v5 = BoxedUnit.UNIT;
                } else {
                    v5 = BoxedUnit.UNIT;
                }
                UserGroupInformation.loginUserFromKeytab((String)conf.get(this.HBaseGeoMesaPrincipal()), (String)conf.get(this.HBaseGeoMesaKeyTab()));
                var4_7 = BoxedUnit.UNIT;
                break block13;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hadoop is not configured to use Kerberos.  The value of the setting 'hbase.security.authentication' ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{auth})));
                v6 = BoxedUnit.UNIT;
            } else {
                v6 = BoxedUnit.UNIT;
            }
            var4_8 = v6;
        }
    }

    private HBaseDataStoreFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.DisplayName = "HBase (GeoMesa)";
        this.Description = "Apache HBase\u2122 distributed key/value store";
        this.HBaseGeoMesaPrincipal = "hbase.geomesa.principal";
        this.HBaseGeoMesaKeyTab = "hbase.geomesa.keytab";
        this.BigTableParamCheck = "google.bigtable.instance.id";
    }
}

