/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.filters.Z2HBaseFilter;
import org.locationtech.geomesa.hbase.filters.Z3HBaseFilter;
import org.locationtech.geomesa.index.utils.Explainer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HBaseQueryPlan$ {
    public static final HBaseQueryPlan$ MODULE$;

    static {
        new HBaseQueryPlan$();
    }

    public void explain(HBaseQueryPlan plan, Explainer explainer, String prefix) {
        explainer.pushLevel((Function0)new Serializable(plan, prefix){
            public static final long serialVersionUID = 0L;
            private final HBaseQueryPlan plan$1;
            private final String prefix$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Plan: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, this.plan$1.getClass().getName()}));
            }
            {
                this.plan$1 = plan$1;
                this.prefix$1 = prefix$1;
            }
        });
        explainer.apply((Function0)new Serializable(plan){
            public static final long serialVersionUID = 0L;
            private final HBaseQueryPlan plan$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)this.plan$1.table()).orNull(Predef$.MODULE$.$conforms())}));
            }
            {
                this.plan$1 = plan$1;
            }
        });
        explainer.apply((Function0)new Serializable(plan){
            public static final long serialVersionUID = 0L;
            private final HBaseQueryPlan plan$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.plan$1.filter().toString()}));
            }
            {
                this.plan$1 = plan$1;
            }
        });
        explainer.apply((Function0)new Serializable(plan){
            public static final long serialVersionUID = 0L;
            private final HBaseQueryPlan plan$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ranges (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.plan$1.ranges().size()), ((TraversableOnce)((TraversableLike)this.plan$1.ranges().take(5)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Query range) {
                        return HBaseQueryPlan$.MODULE$.rangeToString(range);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}));
            }
            {
                this.plan$1 = plan$1;
            }
        });
        plan.explain(explainer);
        explainer.popLevel();
    }

    public String rangeToString(Query range) {
        Query query;
        block4: {
            String string;
            block3: {
                block2: {
                    query = range;
                    if (!(query instanceof Scan)) break block2;
                    Scan scan2 = (Scan)query;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(scan2.getStartRow()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(byte b) {
                            return HBaseQueryPlan$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseQueryPlan$$printable$1(b);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(""), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(scan2.getStopRow()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(byte b) {
                            return HBaseQueryPlan$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseQueryPlan$$printable$1(b);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("")}));
                    break block3;
                }
                if (!(query instanceof Get)) break block4;
                Get get = (Get)query;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(get.getRow()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(byte b) {
                        return HBaseQueryPlan$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseQueryPlan$$printable$1(b);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(""), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(get.getRow()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(byte b) {
                        return HBaseQueryPlan$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseQueryPlan$$printable$1(b);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("")}));
            }
            return string;
        }
        throw new MatchError((Object)query);
    }

    public String filterToString(Filter filter) {
        String string;
        Filter filter2 = filter;
        if (filter2 instanceof FilterList) {
            FilterList filterList = (FilterList)filter2;
            string = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(filterList.getFilters()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Filter filter) {
                    return HBaseQueryPlan$.MODULE$.filterToString(filter);
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        } else if (filter2 instanceof Z3HBaseFilter) {
            Z3HBaseFilter z3HBaseFilter = (Z3HBaseFilter)filter2;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Z3HBaseFilter[xy: (", "), times ", " to ", ": (", ")]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])z3HBaseFilter.filter().xyvals()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(int[] x$1) {
                    return Predef$.MODULE$.intArrayOps(x$1).mkString(",");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(")("), BoxesRunTime.boxToShort((short)z3HBaseFilter.filter().minEpoch()), BoxesRunTime.boxToShort((short)z3HBaseFilter.filter().maxEpoch()), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])z3HBaseFilter.filter().tvals()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(int[][] tval) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)tval).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int[][] apply() {
                            return (int[][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int[] x$2) {
                            return Predef$.MODULE$.intArrayOps(x$2).mkString(",");
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" ");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(")(")}));
        } else if (filter2 instanceof Z2HBaseFilter) {
            Z2HBaseFilter z2HBaseFilter = (Z2HBaseFilter)filter2;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Z2HBaseFilter[xy: (", ")]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])z2HBaseFilter.filter().xyvals()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(int[] x$3) {
                    return Predef$.MODULE$.intArrayOps(x$3).mkString(",");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(")(")}));
        } else {
            string = filter2.toString();
        }
        return string;
    }

    public final String org$locationtech$geomesa$hbase$data$HBaseQueryPlan$$printable$1(byte b) {
        String string;
        int c = 0xFF & b;
        if (c >= 32 && c <= 126) {
            string = ((Object)BoxesRunTime.boxToCharacter((char)((char)c))).toString();
        } else {
            int arg$macro$1 = c;
            string = new StringOps("%%%02x;").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
        }
        return string;
    }

    private HBaseQueryPlan$() {
        MODULE$ = this;
    }
}

