/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.xml.XMLSAXHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentFactory {
    public static final String VALIDATION_HINT = "DocumentFactory_VALIDATION_HINT";

    public static Object getInstance(URI desiredDocument, Map hints) throws SAXException {
        return DocumentFactory.getInstance(desiredDocument, hints, Level.WARNING);
    }

    public static Object getInstance(URI desiredDocument, Map hints, Level level) throws SAXException {
        SAXParser parser = DocumentFactory.getParser();
        XMLSAXHandler xmlContentHandler = new XMLSAXHandler(desiredDocument, hints);
        XMLSAXHandler.setLogLevel(level);
        try {
            parser.parse(desiredDocument.toString(), (DefaultHandler)xmlContentHandler);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return xmlContentHandler.getDocument();
    }

    public static Object getInstance(InputStream is, Map hints, Level level) throws SAXException {
        SAXParser parser = DocumentFactory.getParser();
        XMLSAXHandler xmlContentHandler = new XMLSAXHandler(hints);
        XMLSAXHandler.setLogLevel(level);
        try {
            parser.parse(is, (DefaultHandler)xmlContentHandler);
        }
        catch (IOException e) {
            XMLSAXHandler.logger.warning(e.toString());
            throw new SAXException(e);
        }
        return xmlContentHandler.getDocument();
    }

    private static SAXParser getParser() throws SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        try {
            SAXParser sp = spf.newSAXParser();
            return sp;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }
}

