/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.XMLElementHandler;
import org.geotools.xml.handlers.ElementHandlerFactory;
import org.geotools.xml.handlers.IgnoreHandler;
import org.geotools.xml.handlers.XMLTypeHelper;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Any;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Sequence;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ComplexElementHandler
extends XMLElementHandler {
    private static final long serialVersionUID = ComplexElementHandler.class.hashCode();
    private ComplexType type;
    private Element elem;
    private String text;
    private Attributes attr;
    private List elements;
    private Object value = null;
    private ElementHandlerFactory ehf;

    public ComplexElementHandler(ElementHandlerFactory ehf, Element elem) throws SAXException {
        this.ehf = ehf;
        if (elem == null) {
            logger.warning("ComplexType provided was null");
            throw new SAXException(new NullPointerException("ComplexType provided was null"));
        }
        this.elem = elem;
        try {
            this.type = (ComplexType)elem.getType();
        }
        catch (ClassCastException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    @Override
    public Element getElement() {
        return this.elem;
    }

    @Override
    public void characters(String text1) throws SAXException {
        if (this.type.isMixed()) {
            this.text = this.text != null ? this.text.concat(text1) : text1;
        } else if (!"".equals(text1.trim())) {
            if (this.type.getName() == null) {
                throw new SAXException("This type may not have mixed content");
            }
            throw new SAXException("The " + this.type.getName() + " type may not have mixed content");
        }
    }

    @Override
    public void endElement(URI namespaceURI, String localName, Map hints) throws OperationNotSupportedException, SAXException {
        boolean validate;
        String string = this.text = this.text == null ? null : this.text.trim();
        if (hints == null) {
            hints = new HashMap<String, ElementHandlerFactory>();
            hints.put("org.geotools.xml.handlers.ElementHandlerFactory_KEY", this.ehf);
        } else if (!hints.containsKey("org.geotools.xml.handlers.ElementHandlerFactory_KEY")) {
            hints.put("org.geotools.xml.handlers.ElementHandlerFactory_KEY", this.ehf);
        }
        if (this.elements == null) {
            if (this.type != null) {
                ElementValue[] vals = this.type.isMixed() ? new ElementValue[]{new DefaultElementValue(null, this.text)} : new ElementValue[]{};
                this.value = this.type.getValue(this.elem, vals, this.attr, hints);
            } else {
                this.value = this.text;
            }
            return;
        }
        boolean bl = validate = hints == null || !hints.containsKey("DocumentFactory_VALIDATION_HINT") || hints.get("DocumentFactory_VALIDATION_HINT") == null || !(hints.get("DocumentFactory_VALIDATION_HINT") instanceof Boolean) || (Boolean)hints.get("DocumentFactory_VALIDATION_HINT") != false;
        if (validate) {
            this.validateElementOrder();
        }
        ElementValue[] vals = new ElementValue[this.elements.size() + (this.type.isMixed() ? 1 : 0)];
        for (int i = 0; i < this.elements.size(); ++i) {
            XMLElementHandler xeh = (XMLElementHandler)this.elements.get(i);
            vals[i] = new DefaultElementValue(xeh.getElement(), xeh.getValue());
        }
        if (this.type.isMixed()) {
            vals[vals.length - 1] = new DefaultElementValue(null, this.text);
        }
        this.value = this.type.getValue(this.elem, vals, this.attr, hints);
        this.attr = null;
        this.elements = null;
        this.text = null;
    }

    private void validateElementOrder() throws SAXException {
        if (this.elements == null || this.elements.size() == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        int[] i2 = new int[2];
        int cache = 0;
        i2[1] = 1;
        while (i < this.elements.size() && i2[1] == 1) {
            i2[0] = i;
            i2[1] = 0;
            cache = i2[0];
            i2 = this.valid(this.type.getChild(), i);
            if (i2[1] == 0 && i == i2[0]) {
                if (count >= this.type.getChild().getMinOccurs()) continue;
                StringBuffer buf = new StringBuffer();
                buf.append("Too few elements for ");
                buf.append(this.elem.getNamespace() + ":" + this.elem.getName());
                buf.append(" (type = " + this.type.getName() + ") ");
                buf.append(": ");
                buf.append(count);
                buf.append(" children, ");
                buf.append(this.type.getChild().getMinOccurs());
                buf.append(" minOccurs");
                throw new SAXException(buf.toString());
            }
            i = cache == i2[0] ? i2[0] + 1 : i2[0];
            ++count;
        }
        if (count > this.type.getChild().getMaxOccurs()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Too many elements for ");
            buf.append(this.elem.getNamespace() + ":" + this.elem.getName());
            buf.append(" (type = " + this.type.getName() + ") ");
            buf.append(": ");
            buf.append(count);
            buf.append(" children, ");
            buf.append(this.type.getChild().getMaxOccurs());
            buf.append(" maxOccurs");
            throw new SAXException(buf.toString());
        }
        if (i != this.elements.size()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Invalid Element ordering for ");
            buf.append(this.elem.getNamespace() + ":" + this.elem.getName());
            buf.append(" (type = " + this.type.getName() + ") ");
            buf.append(". There were " + (this.elements.size() - i) + "elements which were unaccounted for");
            throw new SAXException(buf.toString());
        }
    }

    private int[] valid(ElementGrouping eg, int index) throws SAXException {
        if (eg == null) {
            return new int[]{index, 1};
        }
        switch (eg.getGrouping()) {
            case 8: {
                int[] tmp = this.valid((Sequence)eg, index);
                return tmp;
            }
            case 32: {
                return this.valid((All)eg, index);
            }
            case 4: {
                return this.valid((Any)eg, index);
            }
            case 16: {
                return this.valid((Choice)eg, index);
            }
            case 2: {
                return this.valid((Group)eg, index);
            }
            case 1: {
                int[] tmp = this.valid((Element)eg, index);
                return tmp;
            }
        }
        return new int[]{index, 1};
    }

    private int[] valid(All all, int index) {
        int i;
        Element[] elems = all.getElements();
        int[] r = new int[elems.length];
        for (int i2 = 0; i2 < r.length; ++i2) {
            r[i2] = 0;
        }
        boolean c = true;
        int head = index;
        while (c) {
            c = false;
            for (i = 0; i < elems.length; ++i) {
                if (!elems[i].getType().getName().equalsIgnoreCase(((XMLElementHandler)this.elements.get(head)).getName())) continue;
                int n = i;
                r[n] = r[n] + 1;
                ++head;
                i = elems.length;
                c = true;
            }
        }
        for (i = 0; i < r.length; ++i) {
            if (r[i] >= elems[i].getMinOccurs() && r[i] <= elems[i].getMaxOccurs()) continue;
            return new int[]{index, 0};
        }
        return new int[]{head, 1};
    }

    private int[] valid(Any any, int index) {
        if (any.getNamespace().equals(((XMLElementHandler)this.elements.get(index)).getElement().getType().getNamespace())) {
            return new int[]{index + 1, 1};
        }
        return new int[]{index, 1};
    }

    private int[] valid(Choice choice, int index) throws SAXException {
        ElementGrouping[] eg = choice.getChildren();
        if (eg == null) {
            return new int[]{index, 1};
        }
        int i = 0;
        int end = index;
        int t = index;
        int count = 0;
        int[] t2 = null;
        while (i < eg.length && end < this.elements.size()) {
            t2 = this.valid(eg[i], t);
            if (t2[1] == 0 && t2[0] == t) {
                if (t2[0] > end && count >= eg[i].getMinOccurs() && count <= eg[i].getMaxOccurs()) {
                    end = t2[0];
                }
                count = 0;
                ++i;
                t = index;
                continue;
            }
            if (count == eg[i].getMaxOccurs()) {
                if (t2[0] > end && count >= eg[i].getMinOccurs()) {
                    end = t2[0];
                }
                count = 0;
                ++i;
                t = index;
                continue;
            }
            t = t2[0];
            if (t == this.elements.size()) {
                end = t;
            }
            ++count;
        }
        return new int[]{end, end == index ? 0 : 1};
    }

    private int[] valid(Group group, int index) throws SAXException {
        if (group.getChild() == null) {
            return new int[]{index, 1};
        }
        return this.valid(group.getChild(), index);
    }

    private int[] valid(Element element, int index) {
        int[] r = null;
        XMLElementHandler indexHandler = null;
        if (index >= this.elements.size()) {
            return new int[]{index, 0};
        }
        indexHandler = (XMLElementHandler)this.elements.get(index);
        if (r == null && (indexHandler == null || indexHandler.getElement() == null)) {
            return new int[]{index, 0};
        }
        if (r == null && indexHandler.getElement() == element) {
            r = new int[]{index + 1, 1};
        }
        if (r == null && element.getName() == null) {
            return new int[]{index, 0};
        }
        if (r == null && element.getName() != null && element.getName().equalsIgnoreCase(indexHandler.getName())) {
            r = new int[]{index + 1, 1};
        }
        if (r == null && element.getName() != null) {
            for (Element e = indexHandler.getElement(); r == null && e != null; e = e.getSubstitutionGroup()) {
                if (!element.getName().equalsIgnoreCase(e.getName())) continue;
                r = new int[]{index + 1, 1};
            }
        }
        if (r == null) {
            r = new int[]{index, 0};
        }
        return r;
    }

    private int[] valid(Sequence seq, int index) throws SAXException {
        ElementGrouping[] eg = seq.getChildren();
        if (eg == null) {
            return new int[]{index, 1};
        }
        int tIndex = index;
        int t = 0;
        int count = 0;
        int[] i2 = new int[2];
        while (t < eg.length && tIndex < this.elements.size()) {
            i2 = this.valid(eg[t], tIndex);
            if (i2[1] == 1) {
                if (tIndex == i2[0]) {
                    ++t;
                    count = 0;
                    continue;
                }
                if (++count <= eg[t].getMaxOccurs()) {
                    tIndex = i2[0];
                    continue;
                }
                if (eg[t].getMinOccurs() > count) {
                    return new int[]{index, 0};
                }
                ++t;
                count = 0;
                continue;
            }
            if (eg[t].getMinOccurs() > count) {
                return new int[]{index, 0};
            }
            ++t;
            count = 0;
        }
        return new int[]{tIndex, 1};
    }

    @Override
    public void startElement(URI namespaceURI, String localName, Attributes attr1) {
        this.attr = new AttributesImpl(attr1);
    }

    @Override
    public XMLElementHandler getHandler(URI namespaceURI, String localName, Map hints) throws SAXException {
        Boolean valid;
        if (this.elements == null) {
            this.elements = new LinkedList();
        }
        logger.finest("Starting search for element handler " + localName + " :: " + namespaceURI);
        Element e = XMLTypeHelper.findChildElement(this.type, localName, namespaceURI);
        if (e != null && namespaceURI.equals(e.getNamespace())) {
            XMLElementHandler r = this.ehf.createElementHandler(e);
            if (this.type.cache(r.getElement(), hints)) {
                this.elements.add(r);
            }
            return r;
        }
        logger.finest("Checking the document schemas");
        XMLElementHandler r = this.ehf.createElementHandler(namespaceURI, localName);
        if (r != null) {
            if (this.type.cache(r.getElement(), hints)) {
                this.elements.add(r);
            }
            return r;
        }
        if (hints != null && hints.containsKey("DocumentFactory_VALIDATION_HINT") && (valid = (Boolean)hints.get("DocumentFactory_VALIDATION_HINT")) != null && !valid.booleanValue()) {
            return new IgnoreHandler();
        }
        throw new SAXException("Could not find element handler for " + namespaceURI + " : " + localName + " as a child of " + this.type.getName() + ".");
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.elem.getName();
    }

    public void removeElement(XMLElementHandler handler) {
        if (this.elements != null) {
            this.elements.remove(handler);
        }
    }

    public ComplexType getType() {
        return this.type;
    }

    private static class DefaultElementValue
    implements ElementValue {
        Element t;
        Object value;

        public DefaultElementValue(Element t, Object o) {
            this.t = t;
            this.value = o;
        }

        @Override
        public Element getElement() {
            return this.t;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.t != null && this.t.toString() != null) {
                buf.append(this.t.toString());
            } else {
                buf.append(this.getClass().getName());
            }
            buf.append("[");
            buf.append(this.value);
            buf.append("]");
            return buf.toString();
        }
    }
}

