/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.TypeName;

public class RecordTypeImpl
implements RecordType {
    private TypeName typeName;
    private Map<MemberName, TypeName> attributeTypes;
    private RecordSchema parent;

    private RecordTypeImpl() {
    }

    public RecordTypeImpl(RecordSchema parent, TypeName typeName, Collection<MemberName> members) {
        this.parent = parent;
        this.typeName = typeName;
        HashMap<MemberName, TypeName> attributeTypes = new HashMap<MemberName, TypeName>();
        for (MemberName member : members) {
            attributeTypes.put(member, member.getAttributeType());
        }
        this.attributeTypes = Collections.unmodifiableMap(attributeTypes);
    }

    public RecordTypeImpl(RecordSchema parent, TypeName typeName, Map<MemberName, TypeName> attributeTypes) {
        this.parent = parent;
        this.typeName = typeName;
        this.attributeTypes = Collections.unmodifiableMap(attributeTypes);
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public RecordSchema getContainer() {
        return this.parent;
    }

    @Override
    public Map<MemberName, TypeName> getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public Set<MemberName> getMembers() {
        return this.getAttributeTypes().keySet();
    }

    @Override
    public TypeName locate(MemberName memberName) {
        return this.getAttributeTypes().get(memberName);
    }

    @Override
    public boolean isInstance(Record record) {
        return this.getMembers().equals(record.getAttributes().keySet());
    }
}

