/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.path;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.path.Path;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.util.IndexedStack;

public class ExhaustivePathFinder {
    public static final int CONTINUE_PATH = 0;
    public static final int END_PATH_AND_CONTINUE = 1;
    public static final int END_PATH_AND_STOP = 2;
    public static final int KILL_PATH = 3;
    private int m_maxitr;
    private int m_maxplen;

    public ExhaustivePathFinder() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ExhaustivePathFinder(int maxitr, int maxplen) {
        this.m_maxitr = maxitr;
        this.m_maxplen = maxplen;
    }

    public Path getPath(Node from, Node to) {
        final Node dst = to;
        GraphVisitor visitor = new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                if (component.equals(dst)) {
                    return 2;
                }
                return 0;
            }
        };
        List paths = this.getPaths(from, visitor);
        if (paths.isEmpty()) {
            return null;
        }
        return (Path)paths.get(0);
    }

    public List getPaths(Node from, Node to) {
        final Node dst = to;
        GraphVisitor visitor = new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                if (component.equals(dst)) {
                    return 1;
                }
                return 0;
            }
        };
        return this.getPaths(from, visitor);
    }

    public List getPaths(Node from, GraphVisitor visitor) {
        ArrayList<Path> paths = new ArrayList<Path>();
        HashMap<Node, Iterator> node2related = new HashMap<Node, Iterator>();
        IndexedStack stack = new IndexedStack();
        stack.push(from);
        int iterations = 0;
        block5: while (!stack.isEmpty() && iterations++ < this.m_maxitr) {
            Node top = (Node)stack.peek();
            switch (visitor.visit(top)) {
                case 1: {
                    paths.add(new Path((Collection)stack));
                    stack.pop();
                    continue block5;
                }
                case 2: {
                    paths.add(new Path((Collection)stack));
                    break block5;
                }
                case 3: {
                    stack.pop();
                    continue block5;
                }
                default: {
                    Iterator related = null;
                    related = (Iterator)node2related.get(top);
                    if (related == null) {
                        related = top.getRelated();
                        node2related.put(top, related);
                    }
                    while (stack.size() < this.m_maxplen && related.hasNext()) {
                        Node adj = (Node)related.next();
                        if (stack.contains(adj)) continue;
                        stack.push(adj);
                        node2related.put(adj, adj.getRelated());
                        continue block5;
                    }
                    stack.pop();
                    continue block5;
                }
            }
        }
        return paths;
    }
}

