/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.TrackLabelProcess$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@DescribeProcess(title="Track Label Process", description="Returns a single feature appropriate for labelling a track of features")
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\t\tBK]1dW2\u000b'-\u001a7Qe>\u001cWm]:\u000b\u0005\r!\u0011\u0001C1oC2LH/[2\u000b\u0005\u00151\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C\u0001C\u00059Q\r_3dkR,G#\u0002\u0012-w-\u001b\u0006CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\u0005K\u0001\u0005I\u0006$\u0018M\u0003\u0002*\u0015\u0005Aq-Z8u_>d7/\u0003\u0002,I\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006[}\u0001\rAI\u0001\u0012M\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007F\u0002\u00170m]B\u0014\b\u0005\u00021i5\t\u0011G\u0003\u00023g\u00059a-Y2u_JL(BA\u0003)\u0013\t)\u0014GA\tEKN\u001c'/\u001b2f!\u0006\u0014\u0018-\\3uKJ\fAA\\1nK\u0006\nq%A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001\u001e\u0002\u001d%s\u0007/\u001e;!M\u0016\fG/\u001e:fg\")Ah\ba\u0001{\u0005)AO]1dWB\u0011a\b\u0012\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\tQ\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D\u0001\"21h\f\u001cIq%\u000b\u0013\u0001P\u0011\u0002\u0015\u0006aCK]1dW\u0002\nG\u000f\u001e:jEV$X\r\t;pAU\u001cX\r\t4pe\u0002:'o\\;qS:<\u0007EZ3biV\u0014Xm\u001d\u0005\u0006\u0019~\u0001\r!P\u0001\u0004IR<\u0007\u0006C&0m9Ct*\u0015*\"\u00031\u000b\u0013\u0001U\u0001*\t\u0006$X\rI1uiJL'-\u001e;fAQ|\u0007%^:fA\u0019|'\u000fI8sI\u0016\u0014\u0018N\\4!iJ\f7m[:\u0002\u00075Lg.H\u0001\u0001\u0011\u0015!v\u00041\u0001V\u0003\u001diwN\\5u_J\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00035*\tqa\u001c9f]\u001eL7/\u0003\u0002]/\n\u0001\u0002K]8he\u0016\u001c8\u000fT5ti\u0016tWM\u001d\u0015\u0007?y3\u0014\rO2\u0011\u0005Az\u0016B\u000112\u00059!Um]2sS\n,'+Z:vYR\f\u0013AY\u0001\u0007e\u0016\u001cX\u000f\u001c;\"\u0003\u0011\fa\u0002T1cK2\u0004c-Z1ukJ,7\u000fK\u0002 M6\u00042aP4j\u0013\tA\u0007I\u0001\u0004uQJ|wo\u001d\t\u0003U.l\u0011aM\u0005\u0003YN\u0012\u0001\u0003\u0015:pG\u0016\u001c8/\u0012=dKB$\u0018n\u001c8$\u0003%Dc\u0001A8sgb*\bC\u0001\u0019q\u0013\t\t\u0018GA\bEKN\u001c'/\u001b2f!J|7-Z:t\u0003\u0015!\u0018\u000e\u001e7fC\u0005!\u0018a\u0005+sC\u000e\\\u0007\u0005T1cK2\u0004\u0003K]8dKN\u001c\u0018%\u0001<\u0002\rJ+G/\u001e:og\u0002\n\u0007e]5oO2,\u0007EZ3biV\u0014X\rI1qaJ|\u0007O]5bi\u0016\u0004cm\u001c:!Y\u0006\u0014W\r\u001c7j]\u001e\u0004\u0013\r\t;sC\u000e\\\u0007e\u001c4!M\u0016\fG/\u001e:fg\u0002")
public class TrackLabelProcess
implements GeoMesaProcess {
    @DescribeResult(name="result", description="Label features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection featureCollection, @DescribeParameter(name="track", description="Track attribute to use for grouping features") String track, @DescribeParameter(name="dtg", description="Date attribute to use for ordering tracks", min=0) String dtg, ProgressListener monitor) throws ProcessException {
        Option option;
        block6: {
            ListFeatureCollection results;
            block5: {
                Map grouped;
                block4: {
                    ObjectRef sftString$lzy = ObjectRef.zero();
                    VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                    SimpleFeatureType sft = (SimpleFeatureType)featureCollection.getSchema();
                    int trackField = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)track).map((Function1)new Serializable(this, sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;

                        public final int apply(String x$1) {
                            return this.sft$1.indexOf(x$1);
                        }
                        {
                            this.sft$1 = sft$1;
                        }
                    }).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$1) {
                            return this.apply$mcZI$sp(x$1);
                        }

                        public boolean apply$mcZI$sp(int x$1) {
                            return x$1 != -1;
                        }
                    }).getOrElse((Function0)new Serializable(this, track, sft, sftString$lzy, bitmap$0){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TrackLabelProcess $outer;
                        private final String track$1;
                        private final SimpleFeatureType sft$1;
                        private final ObjectRef sftString$lzy$1;
                        private final VolatileByteRef bitmap$0$1;

                        public final Nothing$ apply() {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid track field ", " for schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.track$1, this.$outer.org$locationtech$geomesa$process$analytic$TrackLabelProcess$$sftString$1(this.sft$1, this.sftString$lzy$1, this.bitmap$0$1)})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.track$1 = track$1;
                            this.sft$1 = sft$1;
                            this.sftString$lzy$1 = sftString$lzy$1;
                            this.bitmap$0$1 = bitmap$0$1;
                        }
                    }));
                    Option dtgField = Option$.MODULE$.apply((Object)dtg).map((Function1)new Serializable(this, sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;

                        public final int apply(String x$1) {
                            return this.sft$1.indexOf(x$1);
                        }
                        {
                            this.sft$1 = sft$1;
                        }
                    }).orElse((Function0)new Serializable(this, sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;

                        public final Option<Object> apply() {
                            return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                        }
                        {
                            this.sft$1 = sft$1;
                        }
                    });
                    if (dtgField.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 == -1;
                        }
                    })) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid track field ", " for schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{track, this.org$locationtech$geomesa$process$analytic$TrackLabelProcess$$sftString$1(sft, sftString$lzy, bitmap$0)})));
                    }
                    results = new ListFeatureCollection(sft);
                    grouped = SelfClosingIterator$.MODULE$.apply(featureCollection).toSeq().groupBy((Function1)new Serializable(this, trackField){
                        public static final long serialVersionUID = 0L;
                        private final int trackField$1;

                        public final Object apply(SimpleFeature x$3) {
                            return x$3.getAttribute(this.trackField$1);
                        }
                        {
                            this.trackField$1 = trackField$1;
                        }
                    });
                    option = dtgField;
                    if (!None$.MODULE$.equals(option)) break block4;
                    grouped.foreach((Function1)new Serializable(this, results){
                        public static final long serialVersionUID = 0L;
                        private final ListFeatureCollection results$1;

                        public final boolean apply(Tuple2<Object, Seq<SimpleFeature>> x0$1) {
                            Tuple2<Object, Seq<SimpleFeature>> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Seq features = (Seq)tuple2._2();
                                boolean bl = this.results$1.add((SimpleFeature)features.head());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.results$1 = results$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!(option instanceof Some)) break block6;
                Some some = (Some)option;
                int d = BoxesRunTime.unboxToInt((Object)some.x());
                grouped.foreach((Function1)new Serializable(this, results, d){
                    public static final long serialVersionUID = 0L;
                    private final ListFeatureCollection results$1;
                    public final int d$1;

                    public final boolean apply(Tuple2<Object, Seq<SimpleFeature>> x0$2) {
                        Tuple2<Object, Seq<SimpleFeature>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Seq features = (Seq)tuple2._2();
                            boolean bl = this.results$1.add((SimpleFeature)features.maxBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$execute$3 $outer;

                                public final Date apply(SimpleFeature x$4) {
                                    return (Date)x$4.getAttribute(this.$outer.d$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.results$1 = results$1;
                        this.d$1 = d$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return results;
        }
        throw new MatchError((Object)option);
    }

    private final String sftString$lzycompute$1(SimpleFeatureType sft$1, ObjectRef sftString$lzy$1, VolatileByteRef bitmap$0$1) {
        TrackLabelProcess trackLabelProcess = this;
        synchronized (trackLabelProcess) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                sftString$lzy$1.elem = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft$1.getTypeName(), SimpleFeatureTypes$.MODULE$.encodeType(sft$1, SimpleFeatureTypes$.MODULE$.encodeType$default$2())}));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)sftString$lzy$1.elem;
        }
    }

    public final String org$locationtech$geomesa$process$analytic$TrackLabelProcess$$sftString$1(SimpleFeatureType sft$1, ObjectRef sftString$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.sftString$lzycompute$1(sft$1, sftString$lzy$1, bitmap$0$1) : (String)sftString$lzy$1.elem;
    }
}

