/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.Date;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001b\tIaj\\$ba\u001aKG\u000e\u001c\u0006\u0003\u0007\u0011\tA\u0001^;cK*\u0011QAB\u0001\baJ|7-Z:t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tYA+\u001e2f\u0005VLG\u000eZ3s!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u00181\u0005AA/\u001f9fg\u00064WMC\u0001\u001a\u0003\r\u0019w.\\\u0005\u00037Q\u00111\u0002T1{s2{wmZ5oO\"IQ\u0004\u0001B\u0001B\u0003%a\u0004K\u0001\riV\u0014WMR3biV\u0014Xm\u001d\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\naa]5na2,'BA\u0012%\u0003\u0011!\u0017\r^1\u000b\u0005\u0015R\u0011\u0001C4f_R|w\u000e\\:\n\u0005\u001d\u0002#aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0013\ti\u0002\u0003C\u0005+\u0001\t\u0005\t\u0015!\u0003,c\u0005q!-\u001e4gKJ$\u0015n\u001d;b]\u000e,\u0007C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#A\u0002#pk\ndW-\u0003\u0002+!!I1\u0007\u0001B\u0001B\u0003%AgN\u0001\b[\u0006D()\u001b8t!\taS'\u0003\u00027[\t\u0019\u0011J\u001c;\n\u0005M\u0002\u0002\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\b\u0001\u0011\u0015i\u0002\b1\u0001\u001f\u0011\u0015Q\u0003\b1\u0001,\u0011\u0015\u0019\u0004\b1\u00015\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003=!\u0018.\\3CS:\fe\u000eZ+oS>tGc\u0001\"X9B\u00191i\u0013(\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$\r\u0003\u0019a$o\\8u}%\ta&\u0003\u0002K[\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u0005!IE/\u001a:bi>\u0014(B\u0001&.!\tyU+D\u0001Q\u0015\t\t\u0013K\u0003\u0002S'\u00069a-Z1ukJ,'B\u0001+\u000b\u0003\u001dy\u0007/\u001a8hSNL!A\u0016)\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u0015Av\b1\u0001Z\u0003!1W-\u0019;ve\u0016\u001c\bcA\"[\u001d&\u00111,\u0014\u0002\t\u0013R,'/\u00192mK\")1g\u0010a\u0001i!)a\f\u0001C\u0001?\u0006iQO\\5p]\u001a+\u0017\r^;sKN$2A\u00141f\u0011\u0015\tW\f1\u0001c\u0003=y'\u000fZ3sK\u00124U-\u0019;ve\u0016\u001c\bcA\"d\u001d&\u0011A-\u0014\u0002\u0004'\u0016\f\b\"\u00024^\u0001\u00049\u0017AA5e!\tA7N\u0004\u0002-S&\u0011!.L\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002k[!)q\u000e\u0001C!a\u0006Q1M]3bi\u0016$VOY3\u0016\u0003\t\u0003")
public class NoGapFill
extends TubeBuilder {
    public Iterator<SimpleFeature> timeBinAndUnion(Iterable<SimpleFeature> features, int maxBins) {
        Iterator iterator;
        int numFeatures = features.size();
        if (numFeatures == 0) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            int n;
            int n2 = maxBins;
            switch (n2) {
                default: {
                    n = numFeatures / maxBins + (numFeatures % maxBins == 0 ? 0 : 1);
                    break;
                }
                case 1: {
                    n = numFeatures;
                    break;
                }
                case 0: {
                    n = 1;
                }
            }
            int binSize = n;
            iterator = features.grouped(binSize).zipWithIndex().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NoGapFill $outer;

                public final SimpleFeature apply(Tuple2<Iterable<SimpleFeature>, Object> x0$1) {
                    Tuple2<Iterable<SimpleFeature>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Iterable bin = (Iterable)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        SimpleFeature simpleFeature = this.$outer.unionFeatures((Seq<SimpleFeature>)bin.toSeq(), ((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                        return simpleFeature;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return iterator;
    }

    public SimpleFeature unionFeatures(Seq<SimpleFeature> orderedFeatures, String id) {
        Seq geoms = (Seq)orderedFeatures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NoGapFill $outer;

            public final Geometry apply(SimpleFeature sf) {
                return this.$outer.getGeom(sf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Geometry unionGeom = this.geoFac().buildGeometry((Collection)JavaConversions$.MODULE$.seqAsJavaList(geoms)).union();
        Date min = this.getStartTime((SimpleFeature)orderedFeatures.head());
        Date max = this.getStartTime((SimpleFeature)orderedFeatures.last());
        this.builder().reset();
        return this.builder().buildFeature(id, new Object[]{unionGeom, min, max});
    }

    @Override
    public Iterator<SimpleFeature> createTube() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with no gap filling");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Iterator<SimpleFeature> buffered = this.buffer(transformed, super.bufferDistance());
        Seq sortedTube = (Seq)buffered.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NoGapFill $outer;

            public final long apply(SimpleFeature sf) {
                return this.$outer.getStartTime(sf).getTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sorted tube size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sortedTube.size())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.timeBinAndUnion((Iterable<SimpleFeature>)sortedTube, super.maxBins());
    }

    public NoGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

