/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.geom.Point2D;
import java.util.Date;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.locationtech.geomesa.features.ScalaSimpleFeatureFactory$;
import org.locationtech.geomesa.process.tube.TubeBuilder$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055x!B\u0001\u0003\u0011\u0003i\u0011a\u0003+vE\u0016\u0014U/\u001b7eKJT!a\u0001\u0003\u0002\tQ,(-\u001a\u0006\u0003\u000b\u0019\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0003+vE\u0016\u0014U/\u001b7eKJ\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011A\u000f\u0002\u001f\u0011+g-Y;mi\u0012#xMR5fY\u0012,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1qe\u0004Q\u0001\ny\t\u0001\u0003R3gCVdG\u000f\u0012;h\r&,G\u000e\u001a\u0011\u0007\u000bA\u0011\u0011\u0011A\u0015\u0014\u0007!\u0012\"\u0006\u0005\u0002,e5\tAF\u0003\u0002.]\u0005a1oY1mC2|wmZ5oO*\u0011q\u0006M\u0001\tif\u0004Xm]1gK*\t\u0011'A\u0002d_6L!a\r\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tk!\u0012)\u0019!C\u0001m\u0005aA/\u001e2f\r\u0016\fG/\u001e:fgV\tq\u0007\u0005\u00029\u007f5\t\u0011H\u0003\u0002;w\u000511/[7qY\u0016T!\u0001P\u001f\u0002\t\u0011\fG/\u0019\u0006\u0003})\t\u0001bZ3pi>|Gn]\u0005\u0003\u0001f\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u0011\tC#\u0011!Q\u0001\n]\nQ\u0002^;cK\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003#)\u0005\u000b\u0007I\u0011A#\u0002\u001d\t,hMZ3s\t&\u001cH/\u00198dKV\ta\t\u0005\u0002\u0014\u000f&\u0011\u0001\n\u0006\u0002\u0007\t>,(\r\\3\t\u0011)C#\u0011!Q\u0001\n\u0019\u000bqBY;gM\u0016\u0014H)[:uC:\u001cW\r\t\u0005\t\u0019\"\u0012)\u0019!C\u0001\u001b\u00069Q.\u0019=CS:\u001cX#\u0001(\u0011\u0005My\u0015B\u0001)\u0015\u0005\rIe\u000e\u001e\u0005\t%\"\u0012\t\u0011)A\u0005\u001d\u0006AQ.\u0019=CS:\u001c\b\u0005C\u0003\u001aQ\u0011\u0005A\u000b\u0006\u0003V-^C\u0006C\u0001\b)\u0011\u0015)4\u000b1\u00018\u0011\u0015!5\u000b1\u0001G\u0011\u0015a5\u000b1\u0001O\u0011\u001dQ\u0006F1A\u0005\u0002m\u000bAaY1mGV\tA\f\u0005\u0002^A6\taL\u0003\u0002`{\u0005Y!/\u001a4fe\u0016t7-\u001b8h\u0013\t\tgL\u0001\nHK>$W\r^5d\u0007\u0006d7-\u001e7bi>\u0014\bBB2)A\u0003%A,A\u0003dC2\u001c\u0007\u0005C\u0004fQ\t\u0007I\u0011\u00014\u0002\u0011\u0011$xMR5fY\u0012,\u0012a\u001a\t\u0003Q.t!aE5\n\u0005)$\u0012A\u0002)sK\u0012,g-\u0003\u0002&Y*\u0011!\u000e\u0006\u0005\u0007]\"\u0002\u000b\u0011B4\u0002\u0013\u0011$xMR5fY\u0012\u0004\u0003b\u00029)\u0005\u0004%\t!]\u0001\u0007O\u0016|g)Y2\u0016\u0003I\u0004\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\t\u001d,w.\u001c\u0006\u0003ob\f1A\u001b;t\u0015\tI\b'\u0001\bwSZLGm]8mkRLwN\\:\n\u0005m$(aD$f_6,GO]=GC\u000e$xN]=\t\ruD\u0003\u0015!\u0003s\u0003\u001d9Wm\u001c$bG\u0002Bqa \u0015C\u0002\u0013\u0005Q$A\u0005H\u000b>ku\f\u0015*P!\"9\u00111\u0001\u0015!\u0002\u0013q\u0012AC$F\u001f6{\u0006KU(QA!I\u0011q\u0001\u0015C\u0002\u0013\u0005\u0011\u0011B\u0001\tiV\u0014W\rV=qKV\u0011\u00111\u0002\t\u0005\u0003\u001b\tI\"\u0004\u0002\u0002\u0010)\u0019!(!\u0005\u000b\t\u0005M\u0011QC\u0001\bM\u0016\fG/\u001e:f\u0015\r\t9BC\u0001\b_B,gnZ5t\u0013\u0011\tY\"a\u0004\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0003\u0005\u0002 !\u0002\u000b\u0011BA\u0006\u0003%!XOY3UsB,\u0007\u0005C\u0005\u0002$!\u0012\r\u0011\"\u0001\u0002&\u00059!-^5mI\u0016\u0014XCAA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"b\u0001\u001e\u0002.)\u0019\u00111C\u001f\n\t\u0005E\u00121\u0006\u0002\u0015'&l\u0007\u000f\\3GK\u0006$XO]3Ck&dG-\u001a:\t\u0011\u0005U\u0002\u0006)A\u0005\u0003O\t\u0001BY;jY\u0012,'\u000f\t\u0005\n\u0003sA#\u0019!C\u0001\u0003w\t!\u0001\u001a4\u0016\u0005\u0005u\u0002\u0003BA \u0003\u001bj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007M>\u0014X.\u0019;\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005i&lWMC\u0002\u0002L)\tAA[8eC&!\u0011qJA!\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\t\u0003'B\u0003\u0015!\u0003\u0002>\u0005\u0019AM\u001a\u0011\t\u000f\u0005]\u0003\u0006\"\u0001\u0002Z\u00059q-\u001a;HK>lG\u0003BA.\u0003C\u00022a]A/\u0013\r\ty\u0006\u001e\u0002\t\u000f\u0016|W.\u001a;ss\"A\u00111MA+\u0001\u0004\t)'\u0001\u0002tMB!\u0011QBA4\u0013\u0011\tI'a\u0004\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u001d\ti\u0007\u000bC\u0001\u0003_\nAbZ3u'R\f'\u000f\u001e+j[\u0016$B!!\u001d\u0002~A!\u00111OA=\u001b\t\t)HC\u0002\u0002x\t\nA!\u001e;jY&!\u00111PA;\u0005\u0011!\u0015\r^3\t\u0011\u0005\r\u00141\u000ea\u0001\u0003KBq!!!)\t\u0003\t\u0019)\u0001\u0006hKR,e\u000e\u001a+j[\u0016$B!!\u001d\u0002\u0006\"A\u00111MA@\u0001\u0004\t)\u0007C\u0004\u0002\n\"\"\t!a#\u0002\u0015\t,hMZ3s\u000f\u0016|W\u000e\u0006\u0004\u0002\\\u00055\u0015q\u0012\u0005\bk\u0006\u001d\u0005\u0019AA.\u0011\u001d\t\t*a\"A\u0002\u0019\u000ba!\\3uKJ\u001c\bbBAKQ\u0011\u0005\u0011qS\u0001\u0010[\u0016$XM]:U_\u0012+wM]3fgR)a)!'\u0002\u001c\"9\u0011\u0011SAJ\u0001\u00041\u0005\u0002CAO\u0003'\u0003\r!a(\u0002\u000bA|\u0017N\u001c;\u0011\u0007M\f\t+C\u0002\u0002$R\u0014Q\u0001U8j]RDq!a*)\t\u0003\tI+\u0001\u0004ck\u001a4WM\u001d\u000b\u0007\u0003W\u000b\u0019-a2\u0011\r\u00055\u0016QXA3\u001d\u0011\ty+!/\u000f\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.\r\u0003\u0019a$o\\8u}%\tQ#C\u0002\u0002<R\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0006\u0005'\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005mF\u0003\u0003\u0005\u0002F\u0006\u0015\u0006\u0019AAV\u00039\u0019\u0018.\u001c9mK\u001a+\u0017\r^;sKNDq!!%\u0002&\u0002\u0007a\tC\u0004\u0002L\"\"\t!!4\u0002\u0013Q\u0014\u0018M\\:g_JlGCBAV\u0003\u001f\f\t\u000e\u0003\u00046\u0003\u0013\u0004\ra\u000e\u0005\u0007K\u0006%\u0007\u0019A4\t\u000f\u0005U\u0007\u0006\"\u0001\u0002X\u0006)R.Y6f\u0013\u0012c5+\u00194f\u0019&tWm\u0015;sS:<GCBA.\u00033\f\u0019\u000f\u0003\u0005\u0002\\\u0006M\u0007\u0019AAo\u0003\u0019Ig\u000e];ucA\u00191/a8\n\u0007\u0005\u0005HO\u0001\u0006D_>\u0014H-\u001b8bi\u0016D\u0001\"!:\u0002T\u0002\u0007\u0011Q\\\u0001\u0007S:\u0004X\u000f\u001e\u001a\t\u000f\u0005%\bF\"\u0001\u0002l\u0006Q1M]3bi\u0016$VOY3\u0016\u0005\u0005-\u0006")
public abstract class TubeBuilder
implements LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final double bufferDistance;
    private final int maxBins;
    private final GeodeticCalculator calc;
    private final String dtgField;
    private final GeometryFactory geoFac;
    private final String GEOM_PROP;
    private final SimpleFeatureType tubeType;
    private final SimpleFeatureBuilder builder;
    private final DateTimeFormatter df;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String DefaultDtgField() {
        return TubeBuilder$.MODULE$.DefaultDtgField();
    }

    private Logger logger$lzycompute() {
        TubeBuilder tubeBuilder = this;
        synchronized (tubeBuilder) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public double bufferDistance() {
        return this.bufferDistance;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public GeodeticCalculator calc() {
        return this.calc;
    }

    public String dtgField() {
        return this.dtgField;
    }

    public GeometryFactory geoFac() {
        return this.geoFac;
    }

    public String GEOM_PROP() {
        return this.GEOM_PROP;
    }

    public SimpleFeatureType tubeType() {
        return this.tubeType;
    }

    public SimpleFeatureBuilder builder() {
        return this.builder;
    }

    public DateTimeFormatter df() {
        return this.df;
    }

    public Geometry getGeom(SimpleFeature sf) {
        return (Geometry)sf.getAttribute(0);
    }

    public Date getStartTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(1);
    }

    public Date getEndTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(2);
    }

    public Geometry bufferGeom(Geometry geom, double meters) {
        return geom.buffer(this.metersToDegrees(meters, Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom))));
    }

    public double metersToDegrees(double meters, Point point) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Buffering: ").append((Object)((Object)BoxesRunTime.boxToDouble((double)meters)).toString()).append((Object)" ").append((Object)WKTUtils$.MODULE$.write((Geometry)point)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.calc().setStartingGeographicPoint(point.getX(), point.getY());
        this.calc().setDirection(0.0, meters);
        Point2D dest2D = this.calc().getDestinationGeographicPoint();
        Point destPoint = this.geoFac().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
        return point.distance((Geometry)destPoint);
    }

    public Iterator<SimpleFeature> buffer(Iterator<SimpleFeature> simpleFeatures, double meters) {
        return simpleFeatures.map((Function1)new Serializable(this, meters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TubeBuilder $outer;
            private final double meters$1;

            public final SimpleFeature apply(SimpleFeature sf) {
                Geometry bufferedGeom = this.$outer.bufferGeom(this.$outer.getGeom(sf), this.meters$1);
                this.$outer.builder().reset();
                this.$outer.builder().init(sf);
                this.$outer.builder().set(this.$outer.GEOM_PROP(), (Object)bufferedGeom);
                return this.$outer.builder().buildFeature(sf.getID());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.meters$1 = meters$1;
            }
        });
    }

    public Iterator<SimpleFeature> transform(SimpleFeatureCollection tubeFeatures, String dtgField) {
        return SelfClosingIterator$.MODULE$.apply(tubeFeatures.features()).map((Function1)new Serializable(this, dtgField){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TubeBuilder $outer;
            private final String dtgField$1;

            public final SimpleFeature apply(SimpleFeature sf) {
                Object object;
                Object object2 = sf.getAttribute(this.dtgField$1);
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = this.$outer.df().parseDateTime(string).toDate();
                } else {
                    object = object2;
                }
                Object date = object;
                if (date == null) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error(new StringBuilder().append((Object)"Unable to retrieve date field from input tubeFeatures...ensure there a field named ").append((Object)this.dtgField$1).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Unable to retrieve date field from input tubeFeatures...ensure there a field named \"").append((Object)this.dtgField$1).append((Object)"\"").toString());
                }
                this.$outer.builder().reset();
                return this.$outer.builder().buildFeature(sf.getID(), new Object[]{sf.getDefaultGeometry(), date, null});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dtgField$1 = dtgField$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Geometry makeIDLSafeLineString(Coordinate input1, Coordinate input2) {
        LineString lineString;
        if (GeometryUtils$.MODULE$.crossesIDL(input1, input2)) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            double latIntercept = GeometryUtils$.MODULE$.calcIDLIntercept(input1, input2);
            Coordinate p1 = new Coordinate(-180.0, latIntercept);
            Coordinate p2 = new Coordinate(180.0, latIntercept);
            Tuple2 tuple23 = tuple22 = input1.x > 0.0 ? new Tuple2((Object)input1, (Object)input2) : new Tuple2((Object)input2, (Object)input1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Coordinate point1 = (Coordinate)tuple22._1();
            Coordinate point2 = (Coordinate)tuple22._2();
            Tuple2 tuple24 = tuple2 = new Tuple2((Object)point1, (Object)point2);
            Coordinate point12 = (Coordinate)tuple24._1();
            Coordinate point22 = (Coordinate)tuple24._2();
            LineString westLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{p1, point22})), this.geoFac());
            LineString eastLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{point12, p2})), this.geoFac());
            lineString = new MultiLineString((LineString[])((Object[])new LineString[]{westLine, eastLine}), this.geoFac());
            return lineString;
        } else {
            lineString = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{input1, input2})), this.geoFac());
        }
        return lineString;
    }

    public abstract Iterator<SimpleFeature> createTube();

    public TubeBuilder(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        this.tubeFeatures = tubeFeatures;
        this.bufferDistance = bufferDistance;
        this.maxBins = maxBins;
        LazyLogging.class.$init$((LazyLogging)this);
        this.calc = new GeodeticCalculator();
        this.dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)tubeFeatures.getSchema())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return TubeBuilder$.MODULE$.DefaultDtgField();
            }
        });
        this.geoFac = new GeometryFactory();
        this.GEOM_PROP = "geom";
        this.tubeType = SimpleFeatureTypes$.MODULE$.createType("tubeType", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":Geometry:srid=4326,start:Date,end:Date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.GEOM_PROP()})));
        this.builder = ScalaSimpleFeatureFactory$.MODULE$.featureBuilder(this.tubeType());
        this.df = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }
}

