/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.NullProgressListener;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.tube.GapFill$;
import org.locationtech.geomesa.process.tube.TubeResult;
import org.locationtech.geomesa.process.tube.TubeVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.util.ProgressListener;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Tube Select", description="Performs a tube select on a Geomesa feature collection based on another feature collection")
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u00015\u0011\u0011\u0003V;cKN+G.Z2u!J|7-Z:t\u0015\t\u0019A!\u0001\u0003uk\n,'BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u000599Um\\'fg\u0006\u0004&o\\2fgN\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0003\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u001d)\u00070Z2vi\u0016$\u0012\u0002\f\u001cF\u0017j\u001b\u0017N]>\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB:j[BdWM\u0003\u00022e\u0005!A-\u0019;b\u0015\t\u0019$\"\u0001\u0005hK>$xn\u001c7t\u0013\t)dFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")q'\u000ba\u0001Y\u0005aA/\u001e2f\r\u0016\fG/\u001e:fg\"2a'\u000f!B\u0005\u000e\u0003\"A\u000f \u000e\u0003mR!\u0001P\u001f\u0002\u000f\u0019\f7\r^8ss*\u0011QAM\u0005\u0003\u007fm\u0012\u0011\u0003R3tGJL'-\u001a)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0003]\n1\u0002Z3tGJL\u0007\u000f^5p]\u0006\nA)\u0001\u001eJ]B,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004\u0003&\\;ti\u0002B\u0017M^3!O\u0016|W.\u001a;ss\u0002\ng\u000e\u001a\u0011eCR,G/[7fS!)a)\u000ba\u0001Y\u0005\tb-Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8)\r\u0015K\u0004\t\u0013\"JC\u00051\u0015%\u0001&\u0002WQCW\r\t3bi\u0006\u00043/\u001a;!i>\u0004\u0013/^3ss\u00022wN\u001d\u0011nCR\u001c\u0007.\u001b8hA\u0019,\u0017\r^;sKNDQ\u0001T\u0015A\u00025\u000baAZ5mi\u0016\u0014\bC\u0001(S\u001b\u0005y%B\u0001'Q\u0015\t\t&\"A\u0004pa\u0016tw-[:\n\u0005M{%A\u0002$jYR,'\u000f\u000b\u0005Ls\u0001+fk\u0016\"YC\u0005a\u0015aA7j]v\t\u0001!I\u0001Z\u00031\"\u0006.\u001a\u0011gS2$XM\u001d\u0011u_\u0002\n\u0007\u000f\u001d7zAQ|\u0007\u0005\u001e5fA\u0019,\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000eC\u0003\\S\u0001\u0007A,\u0001\u0005nCb\u001c\u0006/Z3e!\tyQ,\u0003\u0002_!\t!Aj\u001c8hQ!Q\u0016\b\u00111W/\n\u000b\u0017%A.\"\u0003\t\f\u0001)T1yAM\u0004X-\u001a3!_\u001a\u0004C\u000f[3!_\nTWm\u0019;!S:\u0004SnL:!M>\u0014\bE\\8gS2d\u0007E\n\u0011mS:,\u0007eZ1qM&dG\u000eI7fi\"|Gm\u001d\u0005\u0006I&\u0002\r\u0001X\u0001\b[\u0006DH+[7fQ!\u0019\u0017\b\u00114W/\n;\u0017%\u00013\"\u0003!\f\u0011\u0007V5nK\u0002\n7\u000fI:fG>tGm\u001d\u0011g_J\u0004cn\u001c4jY2\u0004c\u0005\t7j]\u0016\u0004s-\u00199gS2d\u0007%\\3uQ>$7\u000fC\u0003kS\u0001\u00071.\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"a\u00047\n\u00055\u0004\"A\u0002#pk\ndW\r\u000b\u0005js\u0001{gk\u0016\"qC\u0005Q\u0017%A9\u0002\t\n+hMZ3sAML'0\u001a\u0011j]\u0002jW\r^3sg\u0002\"x\u000eI;tK\u0002Jgn\u001d;fC\u0012\u0004sN\u001a\u0011nCb\u001c\u0006/Z3e_5\f\u0007\u0010V5nK\u0002\u001a\u0017\r\\2vY\u0006$\u0018n\u001c8\t\u000bML\u0003\u0019\u0001;\u0002\u000f5\f\u0007PQ5ogB\u0011q\"^\u0005\u0003mB\u0011q!\u00138uK\u001e,'\u000f\u000b\u0005ss\u0001Chk\u0016\"zC\u0005\u0019\u0018%\u0001>\u0002\u0007:+XNY3sA=4\u0007EY5og\u0002\"x\u000eI;tK\u00022wN\u001d\u0011ce\u0016\f7.\u001b8hAU\u0004\b%];fef\u0004\u0013N\u001c;pA%tG-\u001b<jIV\fG\u000eI9vKJLWm\u001d\u0005\u0006y&\u0002\r!`\u0001\bO\u0006\u0004h)\u001b7m!\rq\u0018\u0011\u0002\b\u0004\u007f\u0006\u0015QBAA\u0001\u0015\t\t\u0019!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\b\u0005\u0005\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twM\u0003\u0003\u0002\b\u0005\u0005\u0001FC>:\u0001\u0006Eak\u0016\"\u0002\u0014\u0005\nA0\t\u0002\u0002\u0016\u0005!S*\u001a;i_\u0012\u0004sN\u001a\u0011gS2d\u0017N\\4!O\u0006\u0004\b\u0005\u000b8pM&dG\u000e\f\u0011mS:,\u0017\u0006\u000b\u0004*\u00033\u0011\u0015q\u0004\t\u0004u\u0005m\u0011bAA\u000fw\tqA)Z:de&\u0014WMU3tk2$\u0018EAA\u0011\u0003eyU\u000f\u001e9vi\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0015\u0001\t)#a\u000b\u0002.\t\u000b\t\u0004E\u0002;\u0003OI1!!\u000b<\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u0018\u0003-!VOY3!'\u0016dWm\u0019;\"\u0005\u0005M\u0012A\u0017)fe\u001a|'/\\:!C\u0002\"XOY3!g\u0016dWm\u0019;!_:\u0004\u0013\rI$f_6,7/\u0019\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007EY1tK\u0012\u0004sN\u001c\u0011b]>$\b.\u001a:!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000e")
public class TubeSelectProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TubeSelectProcess tubeSelectProcess = this;
        synchronized (tubeSelectProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="tubeFeatures", description="Input feature collection (must have geometry and datetime)") SimpleFeatureCollection tubeFeatures, @DescribeParameter(name="featureCollection", description="The data set to query for matching features") SimpleFeatureCollection featureCollection, @DescribeParameter(name="filter", min=0, description="The filter to apply to the featureCollection") Filter filter, @DescribeParameter(name="maxSpeed", min=0, description="Max speed of the object in m/s for nofill & line gapfill methods") Long maxSpeed, @DescribeParameter(name="maxTime", min=0, description="Time as seconds for nofill & line gapfill methods") Long maxTime, @DescribeParameter(name="bufferSize", min=0, description="Buffer size in meters to use instead of maxSpeed/maxTime calculation") Double bufferSize, @DescribeParameter(name="maxBins", min=0, description="Number of bins to use for breaking up query into individual queries") Integer maxBins, @DescribeParameter(name="gapFill", min=0, description="Method of filling gap (nofill, line)") String gapFill) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Tube selecting on collection type ").append((Object)featureCollection.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TubeVisitor tubeVisitor = new TubeVisitor(tubeFeatures, featureCollection, (Filter)Option$.MODULE$.apply((Object)filter).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        }), BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)maxSpeed).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })), BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)maxTime).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })), BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)bufferSize).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        })), BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)maxBins).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        })), (Enumeration.Value)Option$.MODULE$.apply((Object)gapFill).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(String s) {
                return GapFill$.MODULE$.withName(s);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply() {
                return GapFill$.MODULE$.NOFILL();
            }
        }));
        featureCollection.accepts((FeatureVisitor)tubeVisitor, (ProgressListener)new NullProgressListener());
        return ((TubeResult)tubeVisitor.getResult()).results();
    }

    public TubeSelectProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

