/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.calrissian.mango.collect.CloseableIterable;

public abstract class AbstractCloseableIterable<T>
implements CloseableIterable<T> {
    protected boolean closed = false;

    protected abstract void doClose() throws IOException;

    protected abstract Iterator<T> retrieveIterator();

    @Override
    public void closeQuietly() {
        try {
            Closeables.close((Closeable)this, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.doClose();
            this.closed = true;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.closed) {
            throw new IllegalStateException("Iterable is already closed");
        }
        return this.retrieveIterator();
    }
}

