/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.event;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.calrissian.mango.domain.BaseTupleStore;
import org.calrissian.mango.domain.event.Event;

public class BaseEvent
extends BaseTupleStore
implements Event {
    private final String id;
    private final long timestamp;

    public BaseEvent() {
        this(UUID.randomUUID().toString());
    }

    public BaseEvent(String id) {
        this(id, System.currentTimeMillis());
    }

    public BaseEvent(String id, long timestamp) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        this.timestamp = timestamp;
    }

    public BaseEvent(Event event) {
        this(((Event)Preconditions.checkNotNull((Object)event)).getId(), event.getTimestamp());
        this.putAll(event.getTuples());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "BaseEvent{id='" + this.id + '\'' + ", timestamp=" + this.timestamp + ", tuples=" + this.getTuples() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        if (this.timestamp != baseEvent.timestamp) {
            return false;
        }
        return this.id.equals(baseEvent.id);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

