/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractBufferedInputStream
extends InputStream {
    private static final int EOF = -1;
    private byte[] buf = null;
    private int curr = 0;
    private boolean closed = false;

    protected abstract boolean isEOF();

    protected abstract byte[] getNextBuffer() throws IOException;

    @Override
    public int read() throws IOException {
        while (this.available() < 1) {
            if (this.isEOF()) {
                return -1;
            }
            this.loadBuffer();
        }
        return this.buf[this.curr++] & 0xFF;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        if (this.buf == null) {
            return 0;
        }
        return this.buf.length - this.curr;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
        }
    }

    private void loadBuffer() throws IOException {
        this.buf = this.getNextBuffer();
        this.curr = 0;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot read from stream anymore.  It has been closed");
        }
    }
}

