/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandselect;

import it.geosolutions.jaiext.bandselect.JaiI18N;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class BandSelectDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -8249015686542274642L;
    private static final String[][] resources = new String[][]{{"GlobalName", "BandSelect"}, {"LocalName", "BandSelect"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", JaiI18N.getString("BandSelectDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandSelectDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BandSelectDescriptor1")}};
    private static final Class<?>[] parametersClasses = new Class[]{int[].class};
    private static final String[] parametersNames = new String[]{"bandIndices"};
    private static final Object[] parametersDefaults = new Object[]{NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public BandSelectDescriptor() {
        super(resources, supportedModes, 1, parametersNames, (Class[])parametersClasses, parametersDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        int[] indices = (int[])args.getObjectParameter(0);
        if (indices.length < 1) {
            message.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor2"));
            return false;
        }
        RenderedImage src = args.getRenderedSource(0);
        int bands = src.getSampleModel().getNumBands();
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0 && indices[i] < bands) continue;
            message.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor3"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, int[] bandIndices, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bandIndices", (Object)bandIndices);
        return JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, int[] bandIndices, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("bandIndices", (Object)bandIndices);
        return JAI.createRenderable((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

