/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Schema;
import org.hsqldb.Session;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.rights.User;

public class SessionManager {
    long sessionIdCount = 0L;
    private LongKeyHashMap sessionMap = new LongKeyHashMap();
    private Session sysSession;
    private Session sysLobSession;

    public SessionManager(Database database) {
        User user = database.getUserManager().getSysUser();
        this.sysSession = new Session(database, user, false, false, this.sessionIdCount++, null, 0);
        this.sysLobSession = new Session(database, user, true, false, this.sessionIdCount++, null, 0);
    }

    public synchronized Session newSession(Database database, User user, boolean bl, boolean bl2, String string, int n) {
        Session session = new Session(database, user, bl2, bl, this.sessionIdCount, string, n);
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public synchronized Session newSessionForLog(Database database) {
        boolean bl = database.databaseProperties.isVersion18();
        Session session = new Session(database, database.getUserManager().getSysUser(), bl, false, this.sessionIdCount, null, 0);
        session.isProcessingLog = true;
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session getSysSessionForScript(Database database) {
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, 0L, null, 0);
        session.setCurrentSchemaHsqlName(database.schemaManager.defaultSchemaHsqlName);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session newSysSession() {
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, this.sessionIdCount, null, 0);
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session newSysSession(HsqlNameManager.HsqlName hsqlName, User user) {
        Session session = new Session(this.sysSession.database, user, false, false, 0L, null, 0);
        session.currentSchema = hsqlName;
        return session;
    }

    public void closeAllSessions() {
        Session[] sessionArray = this.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            sessionArray[i].close();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long l) {
        return (Session)this.sessionMap.get(l);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = (Session)iterator.next();
            ++n;
        }
        return sessionArray;
    }

    public synchronized boolean isUserActive(String string) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (string.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void removeSchemaReference(Schema schema) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session.getCurrentSchemaHsqlName() == schema.getName()) {
                session.resetSchema();
            }
            ++n;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.loggedSchema = null;
            ++n;
        }
        this.sysLobSession.loggedSchema = null;
    }
}

