/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDiskLarge
extends NodeAVL {
    final RowAVLDisk row;
    private long iLeft = -1L;
    private long iRight = -1L;
    private long iParent = -1L;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDiskLarge(RowAVLDisk rowAVLDisk, RowInputInterface rowInputInterface, int n) throws IOException {
        this.row = rowAVLDisk;
        this.iId = n;
        int n2 = rowInputInterface.readInt();
        this.iBalance = (byte)n2;
        this.iLeft = (long)rowInputInterface.readInt() & 0xFFFFFFFFL;
        this.iRight = (long)rowInputInterface.readInt() & 0xFFFFFFFFL;
        this.iParent = (long)rowInputInterface.readInt() & 0xFFFFFFFFL;
        if (n2 > 255) {
            this.iParent |= (long)n2 << 8 & 0xFF00000000L;
            this.iLeft |= (long)n2 << 16 & 0xFF00000000L;
            this.iRight |= (long)n2 << 24 & 0xFF00000000L;
        }
        if (this.iLeft == 0L) {
            this.iLeft = -1L;
        }
        if (this.iRight == 0L) {
            this.iRight = -1L;
        }
        if (this.iParent == 0L) {
            this.iParent = -1L;
        }
    }

    public NodeAVLDiskLarge(RowAVLDisk rowAVLDisk, int n) {
        this.row = rowAVLDisk;
        this.iId = n;
    }

    @Override
    public void delete() {
        this.iLeft = -1L;
        this.iRight = -1L;
        this.iParent = -1L;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        this.row.setNodesChanged();
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public long getPos() {
        return this.row.getPos();
    }

    @Override
    public RowAVL getRow(PersistentStore persistentStore) {
        if (!this.row.isInMemory()) {
            return (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
        }
        this.row.updateAccessCount(persistentStore.getAccessCount());
        return this.row;
    }

    @Override
    public Object[] getData(PersistentStore persistentStore) {
        return this.row.getData();
    }

    private NodeAVLDiskLarge findNode(PersistentStore persistentStore, long l) {
        NodeAVLDiskLarge nodeAVLDiskLarge = null;
        RowAVLDisk rowAVLDisk = (RowAVLDisk)persistentStore.get(l, false);
        if (rowAVLDisk != null) {
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDiskLarge;
    }

    @Override
    boolean isLeft(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iLeft == -1L;
        }
        return this.iLeft == nodeAVL.getPos();
    }

    @Override
    boolean isRight(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iRight == -1L;
        }
        return this.iRight == nodeAVL.getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDiskLarge.iLeft == -1L) {
            return null;
        }
        if (nodeAVLDiskLarge.nLeft == null || !nodeAVLDiskLarge.nLeft.isInMemory()) {
            nodeAVLDiskLarge.nLeft = this.findNode(persistentStore, nodeAVLDiskLarge.iLeft);
            nodeAVLDiskLarge.nLeft.nParent = nodeAVLDiskLarge;
        }
        return nodeAVLDiskLarge.nLeft;
    }

    @Override
    NodeAVL getRight(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDiskLarge.iRight == -1L) {
            return null;
        }
        if (nodeAVLDiskLarge.nRight == null || !nodeAVLDiskLarge.nRight.isInMemory()) {
            nodeAVLDiskLarge.nRight = this.findNode(persistentStore, nodeAVLDiskLarge.iRight);
            nodeAVLDiskLarge.nRight.nParent = nodeAVLDiskLarge;
        }
        return nodeAVLDiskLarge.nRight;
    }

    @Override
    NodeAVL getParent(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDiskLarge.iParent == -1L) {
            return null;
        }
        if (nodeAVLDiskLarge.nParent == null || !nodeAVLDiskLarge.nParent.isInMemory()) {
            nodeAVLDiskLarge.nParent = this.findNode(persistentStore, this.iParent);
        }
        return nodeAVLDiskLarge.nParent;
    }

    @Override
    public int getBalance(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDiskLarge.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDiskLarge.iParent == -1L;
    }

    @Override
    boolean isFromLeft(PersistentStore persistentStore) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDiskLarge.iParent == -1L) {
            return true;
        }
        if (nodeAVLDiskLarge.nParent == null || !nodeAVLDiskLarge.nParent.isInMemory()) {
            nodeAVLDiskLarge.nParent = this.findNode(persistentStore, this.iParent);
        }
        return rowAVLDisk.getPos() == ((NodeAVLDiskLarge)nodeAVLDiskLarge.nParent).iLeft;
    }

    @Override
    public NodeAVL child(PersistentStore persistentStore, boolean bl) {
        return bl ? this.getLeft(persistentStore) : this.getRight(persistentStore);
    }

    @Override
    NodeAVL setParent(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk.keepInMemory(false);
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        long l = nodeAVLDiskLarge.iParent = nodeAVL == null ? -1L : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDiskLarge.nParent = (NodeAVLDiskLarge)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDiskLarge;
    }

    @Override
    public NodeAVL setBalance(PersistentStore persistentStore, int n) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDiskLarge.iBalance = n;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDiskLarge;
    }

    @Override
    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        long l = nodeAVLDiskLarge.iLeft = nodeAVL == null ? -1L : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDiskLarge.nLeft = (NodeAVLDiskLarge)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDiskLarge;
    }

    @Override
    NodeAVL setRight(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        long l = nodeAVLDiskLarge.iRight = nodeAVL == null ? -1L : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDiskLarge.nRight = (NodeAVLDiskLarge)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDiskLarge;
    }

    @Override
    public NodeAVL set(PersistentStore persistentStore, boolean bl, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = bl ? this.setLeft(persistentStore, nodeAVL) : this.setRight(persistentStore, nodeAVL);
        if (nodeAVL != null) {
            nodeAVL.setParent(persistentStore, this);
        }
        return nodeAVL2;
    }

    @Override
    public void replace(PersistentStore persistentStore, Index index, NodeAVL nodeAVL) {
        NodeAVLDiskLarge nodeAVLDiskLarge = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDiskLarge = (NodeAVLDiskLarge)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDiskLarge.iParent == -1L) {
            if (nodeAVL != null) {
                nodeAVL = nodeAVL.setParent(persistentStore, null);
            }
            persistentStore.setAccessor(index, nodeAVL);
        } else {
            boolean bl = nodeAVLDiskLarge.isFromLeft(persistentStore);
            nodeAVLDiskLarge.getParent(persistentStore).set(persistentStore, bl, nodeAVL);
        }
        rowAVLDisk.keepInMemory(false);
    }

    @Override
    boolean equals(NodeAVL nodeAVL) {
        if (nodeAVL instanceof NodeAVLDiskLarge) {
            return this == nodeAVL || this.row.getPos() == ((NodeAVLDiskLarge)nodeAVL).getPos();
        }
        return false;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 16;
    }

    @Override
    public void setInMemory(boolean bl) {
        if (!bl) {
            if (this.nLeft != null) {
                this.nLeft.nParent = null;
            }
            if (this.nRight != null) {
                this.nRight.nParent = null;
            }
            if (this.nParent != null) {
                if (this.row.getPos() == ((NodeAVLDiskLarge)this.nParent).iLeft) {
                    this.nParent.nLeft = null;
                } else {
                    this.nParent.nRight = null;
                }
            }
            this.nParent = null;
            this.nRight = null;
            this.nLeft = null;
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        long l = NodeAVLDiskLarge.getTranslatePointer(this.iLeft, longLookup);
        long l2 = NodeAVLDiskLarge.getTranslatePointer(this.iRight, longLookup);
        long l3 = NodeAVLDiskLarge.getTranslatePointer(this.iParent, longLookup);
        int n = 0;
        n |= (int)((l3 & 0xFF00000000L) >> 8);
        n |= (int)((l & 0xFF00000000L) >> 16);
        n = (n |= (int)((l2 & 0xFF00000000L) >> 24)) == 0 ? this.iBalance : (n |= this.iBalance & 0xFF);
        rowOutputInterface.writeInt(n);
        rowOutputInterface.writeInt((int)l);
        rowOutputInterface.writeInt((int)l2);
        rowOutputInterface.writeInt((int)l3);
    }

    private static long getTranslatePointer(long l, LongLookup longLookup) {
        long l2 = 0L;
        if (l != -1L) {
            l2 = longLookup == null ? l : longLookup.lookup(l);
        }
        return l2;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateAccessCount(int n) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(long l) {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean bl) {
        return false;
    }
}

