/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeUshort
extends Range {
    public static RangeUshort FULL_RANGE = new RangeUshort(0, true, 65535, true);
    private final int minValue;
    private final int maxValue;
    private final boolean isPoint;

    RangeUshort(int minValue, boolean minIncluded, int maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        int valueMin = minValue & 0xFFFF;
        int valueMax = maxValue & 0xFFFF;
        if (minValue < maxValue) {
            this.minValue = valueMin;
            this.maxValue = valueMax;
            this.isPoint = false;
        } else if (minValue > maxValue) {
            this.minValue = valueMax;
            this.maxValue = valueMin;
            this.isPoint = false;
        } else {
            this.minValue = valueMin;
            this.maxValue = valueMin;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    public boolean contains(short value) {
        boolean lower;
        int valueUshort = value & 0xFFFF;
        if (this.isPoint) {
            return this.minValue == valueUshort;
        }
        if (this.isMinIncluded()) {
            lower = valueUshort < this.minValue;
        } else {
            boolean bl = lower = valueUshort <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? valueUshort > this.maxValue : valueUshort >= this.maxValue;
        return !lower && !upper;
    }

    public Range.DataType getDataType() {
        return Range.DataType.USHORT;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public Number getMax() {
        return this.maxValue;
    }

    public Number getMin() {
        return this.minValue;
    }

    public Number getMax(boolean isMaxIncluded) {
        int value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    public Number getMin(boolean isMinIncluded) {
        int value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        int min2 = other.getMin().intValue();
        int max2 = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeUshort((short)finalMin, minIncluded, (short)finalMax, maxIncluded);
    }

    public Range intersection(Range other) {
        if (other.getDataType() == this.getDataType()) {
            if (other.contains(this)) {
                return this;
            }
            if (this.contains(other)) {
                return other;
            }
        }
        int minOther = other.getMin().intValue();
        int maxOther = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (minOther > this.minValue) {
            finalMin = minOther;
            minIncluded = other.isMinIncluded();
        } else if (minOther == this.minValue) {
            minIncluded &= other.isMinIncluded();
        }
        if (maxOther < this.maxValue) {
            finalMax = maxOther;
            maxIncluded = other.isMaxIncluded();
        } else if (maxOther == this.maxValue) {
            maxIncluded &= other.isMaxIncluded();
        }
        if (finalMax < finalMin || finalMax == finalMin && !minIncluded && !maxIncluded) {
            return null;
        }
        return new RangeUshort((short)finalMin, minIncluded, (short)finalMax, maxIncluded);
    }
}

