/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.metadata;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.locationtech.geomesa.index.metadata.CachedLazyMetadata;
import org.locationtech.geomesa.index.metadata.CachedLazyMetadata$;
import org.locationtech.geomesa.index.metadata.MetadataAdapter;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.IsSynchronized;
import org.locationtech.geomesa.utils.collection.MaybeSynchronized;
import org.locationtech.geomesa.utils.collection.NotSynchronized;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CachedLazyMetadata$class {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getFeatureTypes(CachedLazyMetadata $this) {
        String[] stringArray;
        if (!BoxesRunTime.unboxToBoolean((Object)$this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists().get())) {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            return stringArray;
        }
        CloseableIterator<byte[]> rows = ((MetadataAdapter)((Object)$this)).scanRows((Option<byte[]>)None$.MODULE$);
        try {
            stringArray = (String[])((TraversableOnce)rows.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CachedLazyMetadata $outer;

                public final String apply(byte[] r) {
                    return (String)CachedLazyMetadata$.MODULE$.decodeRow(r, this.$outer.typeNameSeparator())._1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).toSeq().distinct()).toArray(ClassTag$.MODULE$.apply(String.class));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        rows.close();
        return stringArray;
    }

    public static Option read(CachedLazyMetadata $this, String typeName, String key, boolean cache) {
        if (!cache) {
            $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().invalidate((Object)new Tuple2((Object)typeName, (Object)key));
        }
        return (Option)$this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().get((Object)new Tuple2((Object)typeName, (Object)key));
    }

    public static void insert(CachedLazyMetadata $this, String typeName, String key, Object value) {
        $this.insert(typeName, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), value)})));
    }

    public static void insert(CachedLazyMetadata $this, String typeName, Map kvPairs) {
        CachedLazyMetadata$class.ensureTableExists($this);
        Seq inserts = (Seq)kvPairs.toSeq().map((Function1)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedLazyMetadata $outer;
            private final String typeName$2;

            public final Tuple2<byte[], byte[]> apply(Tuple2<String, T> x0$1) {
                Tuple2<String, T> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    this.$outer.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().put((Object)new Tuple2((Object)this.typeName$2, (Object)k), (Object)Option$.MODULE$.apply(v));
                    Tuple2 tuple22 = new Tuple2((Object)this.$outer.encodeRow(this.typeName$2, k), (Object)this.$outer.serializer().serialize(this.typeName$2, k, v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$2 = typeName$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((MetadataAdapter)((Object)$this)).write((Seq<Tuple2<byte[], byte[]>>)inserts);
    }

    public static void invalidateCache(CachedLazyMetadata $this, String typeName, String key) {
        $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().invalidate((Object)new Tuple2((Object)typeName, (Object)key));
    }

    public static void remove(CachedLazyMetadata $this, String typeName, String key) {
        BoxedUnit boxedUnit;
        if (BoxesRunTime.unboxToBoolean((Object)$this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists().get())) {
            ((MetadataAdapter)((Object)$this)).delete($this.encodeRow(typeName, key));
            $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().invalidate((Object)new Tuple2((Object)typeName, (Object)key));
        } else if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to delete '", ":", "' but table does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(CachedLazyMetadata $this, String typeName) {
        BoxedUnit boxedUnit;
        if (BoxesRunTime.unboxToBoolean((Object)$this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists().get())) {
            byte[] prefix = $this.encodeRow(typeName, "");
            CloseableIterator<byte[]> rows = ((MetadataAdapter)((Object)$this)).scanRows((Option<byte[]>)new Some((Object)prefix));
            try {
                Buffer all = rows.toBuffer();
                if (all.nonEmpty()) {
                    ((MetadataAdapter)((Object)$this)).delete((Seq<byte[]>)all);
                }
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
            rows.close();
            boxedUnit = BoxedUnit.UNIT;
        } else if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to delete type '", "' but table does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        JavaConversions$.MODULE$.mapAsScalaConcurrentMap($this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().asMap()).keys().foreach((Function1)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedLazyMetadata $outer;
            private final String typeName$3;

            public final void apply(Tuple2<String, String> k) {
                Object object = k._1();
                String string = this.typeName$3;
                if (!(object != null ? !object.equals(string) : string != null)) {
                    this.$outer.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache().invalidate(k);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$3 = typeName$3;
            }
        });
    }

    public static byte[] encodeRow(CachedLazyMetadata $this, String typeName, String key) {
        return CachedLazyMetadata$.MODULE$.encodeRow(typeName, key, $this.typeNameSeparator());
    }

    private static void ensureTableExists(CachedLazyMetadata $this) {
        $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists().set((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedLazyMetadata $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((MetadataAdapter)((Object)this.$outer)).createTable();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(CachedLazyMetadata $this) {
        $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$_setter_$typeNameSeparator_$eq('~');
        $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$_setter_$org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists_$eq((MaybeSynchronized)(((MetadataAdapter)((Object)$this)).checkIfTableExists() ? new NotSynchronized((Object)BoxesRunTime.boxToBoolean((boolean)true)) : new IsSynchronized((Object)BoxesRunTime.boxToBoolean((boolean)false))));
        $this.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$_setter_$org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$metaDataCache_$eq(Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<Tuple2<String, String>, Option<T>>($this){
            private final /* synthetic */ CachedLazyMetadata $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Option<T> load(Tuple2<String, String> k) {
                None$ none$;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$tableExists().get())) {
                    Tuple2 tuple2;
                    Tuple2<String, String> tuple22 = k;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    String typeName = (String)tuple22._1();
                    String key = (String)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)typeName, (Object)key);
                    String typeName2 = (String)tuple23._1();
                    String key2 = (String)tuple23._2();
                    none$ = ((MetadataAdapter)((Object)this.$outer)).scanValue(this.$outer.encodeRow(typeName2, key2)).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CachedLazyMetadata$.anon.1 $outer;
                        private final String typeName$1;
                        private final String key$1;

                        public final Option<T> apply(byte[] b) {
                            return Option$.MODULE$.apply(this.$outer.org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$anon$$$outer().serializer().deserialize(this.typeName$1, this.key$1, b));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.typeName$1 = typeName$1;
                            this.key$1 = key$1;
                        }
                    });
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public /* synthetic */ CachedLazyMetadata org$locationtech$geomesa$index$metadata$CachedLazyMetadata$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }
}

