/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Connection;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.audit.AuditLogger$;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.audit.NoOpAuditProvider$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u00115b\u0001B\u0001\u0003\u00015\u0011Q\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-u\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0006\u0002\u0011\u001d,w\u000e^8pYNL!\u0001\b\r\u0003'\u0011\u000bG/Y*u_J,g)Y2u_JL8\u000b]5\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t!\u0001C\u0003.\u0001\u0011\u0005c&\u0001\nde\u0016\fG/\u001a(fo\u0012\u000bG/Y*u_J,GCA\u00183!\t9\u0002'\u0003\u000221\tIA)\u0019;b'R|'/\u001a\u0005\u0006g1\u0002\r\u0001N\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\tUB$\bR\u0007\u0002m)\u0011qGE\u0001\u0005kRLG.\u0003\u0002:m\t\u0019Q*\u00199\u0011\u0005m\neB\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0013\u0012AA5p\u0013\tIeI\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003L\u0001\u0011\u0005C*A\bde\u0016\fG/\u001a#bi\u0006\u001cFo\u001c:f)\tyS\nC\u00034\u0015\u0002\u0007A\u0007C\u0003P\u0001\u0011E\u0001+\u0001\u0006hKR\u001c\u0015\r^1m_\u001e$\"AO)\t\u000bMr\u0005\u0019\u0001\u001b\t\u000bM\u0003A\u0011\u0003+\u0002\u001d\t,\u0018\u000e\u001c3ECR\f7\u000b^8sKR\u0019Q\u000bW3\u0011\u0005-2\u0016BA,\u0003\u00059A%)Y:f\t\u0006$\u0018m\u0015;pe\u0016DQ!\u0017*A\u0002i\u000b!bY8o]\u0016\u001cG/[8o!\tY6-D\u0001]\u0015\tif,\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b}S!\u0001Y1\u0002\r!\fGm\\8q\u0015\t\u0011'\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Ir\u0013!bQ8o]\u0016\u001cG/[8o\u0011\u00151'\u000b1\u0001h\u0003\u0019\u0019wN\u001c4jOB\u0019\u0001.a2\u000f\u0005%4hB\u00016v\u001d\tYGO\u0004\u0002mg:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)qO\u0001E\u0001q\u0006)\u0002JQ1tK\u0012\u000bG/Y*u_J,g)Y2u_JL\bCA\u0016z\r\u0015\t!\u0001#\u0001{'\u0011I8P`\u000f\u0011\u0005qb\u0018BA?>\u0005\u0019\te.\u001f*fMB\u0019q0a\u0005\u000f\t\u0005\u0005\u0011Q\u0002\b\u0005\u0003\u0007\tIAD\u0002l\u0003\u000bI1!a\u0002\u0007\u0003\u0015Ig\u000eZ3y\u0013\rQ\u00121\u0002\u0006\u0004\u0003\u000f1\u0011\u0002BA\b\u0003#\tqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\u000b\u0007i\tY!\u0003\u0003\u0002\u0016\u0005]!\u0001F$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0013:4wN\u0003\u0003\u0002\u0010\u0005E\u0001B\u0002\u0015z\t\u0003\tY\u0002F\u0001y\u0011%\ty\"\u001fb\u0001\n\u0003\t\t#A\u000bI\u0005\u0006\u001cXmR3p\u001b\u0016\u001c\u0018\r\u0015:j]\u000eL\u0007/\u00197\u0016\u0005\u0005\r\u0002cA\b\u0002&%\u0011!\t\u0005\u0005\t\u0003SI\b\u0015!\u0003\u0002$\u00051\u0002JQ1tK\u001e+w.T3tCB\u0013\u0018N\\2ja\u0006d\u0007\u0005C\u0005\u0002.e\u0014\r\u0011\"\u0001\u0002\"\u0005\u0011\u0002JQ1tK\u001e+w.T3tC.+\u0017\u0010V1c\u0011!\t\t$\u001fQ\u0001\n\u0005\r\u0012a\u0005%CCN,w)Z8NKN\f7*Z=UC\n\u0004\u0003\"CA\u001bs\n\u0007I\u0011AA\u001c\u0003Q\u0011V-\\8uK\u001aKG\u000e^3s!J|\u0007/\u001a:usV\u0011\u0011\u0011\b\t\u0005\u0003w\t\tF\u0004\u0003\u0002>\u0005-c\u0002BA \u0003\u000br1a[A!\u0013\r\t\u0019EB\u0001\u0006kRLGn]\u0005\u0005\u0003\u000f\nI%\u0001\u0003d_:4'bAA\"\r%!\u0011QJA(\u0003]9Um\\'fg\u0006\u001c\u0016p\u001d;f[B\u0013x\u000e]3si&,7O\u0003\u0003\u0002H\u0005%\u0013\u0002BA*\u0003+\u0012abU=ti\u0016l\u0007K]8qKJ$\u0018P\u0003\u0003\u0002N\u0005=\u0003\u0002CA-s\u0002\u0006I!!\u000f\u0002+I+Wn\u001c;f\r&dG/\u001a:Qe>\u0004XM\u001d;zA!I\u0011QL=C\u0002\u0013\u0005\u0011qG\u0001\u0013\u0007>tg-[4QCRD\u0007K]8qKJ$\u0018\u0010\u0003\u0005\u0002be\u0004\u000b\u0011BA\u001d\u0003M\u0019uN\u001c4jOB\u000bG\u000f\u001b)s_B,'\u000f^=!\u0011%\t)'\u001fb\u0001\n\u0003\n\t#A\u0006ESN\u0004H.Y=OC6,\u0007\u0002CA5s\u0002\u0006I!a\t\u0002\u0019\u0011K7\u000f\u001d7bs:\u000bW.\u001a\u0011\t\u0013\u00055\u0014P1A\u0005B\u0005\u0005\u0012a\u0003#fg\u000e\u0014\u0018\u000e\u001d;j_:D\u0001\"!\u001dzA\u0003%\u00111E\u0001\r\t\u0016\u001c8M]5qi&|g\u000e\t\u0005\n\u0003kJ(\u0019!C!\u0003o\nQ\u0002U1sC6,G/\u001a:J]\u001a|WCAA=!\u0015a\u00141PA@\u0013\r\ti(\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u0003\u0003\u000by\t\u0005\u0004\u0002\u0004\u0006\u001d\u00151R\u0007\u0003\u0003\u000bS1AGA%\u0013\u0011\tI)!\"\u0003\u0019\u001d+w.T3tCB\u000b'/Y7\u0011\t\u00055\u0015q\u0012\u0007\u0001\t1\t\t*a%\u0002\u0002\u0003\u0005)\u0011AAQ\u0005\ryFE\r\u0005\t\u0003+K\b\u0015!\u0003\u0002\u0018\u0006q\u0001+\u0019:b[\u0016$XM]%oM>\u0004\u0003#\u0002\u001f\u0002|\u0005e\u0005\u0007BAN\u0003?\u0003b!a!\u0002\b\u0006u\u0005\u0003BAG\u0003?#A\"!%\u0002\u0014\u0006\u0005\t\u0011!B\u0001\u0003C\u000bB!a)\u0002*B\u0019A(!*\n\u0007\u0005\u001dVHA\u0004O_RD\u0017N\\4\u0011\u0007q\nY+C\u0002\u0002.v\u00121!\u00118z\u0011)\t\t,\u001fb\u0001\n\u00031\u0011\u0011E\u0001\u0013\u0005&<G+\u00192mKB\u000b'/Y7DQ\u0016\u001c7\u000e\u0003\u0005\u00026f\u0004\u000b\u0011BA\u0012\u0003M\u0011\u0015n\u001a+bE2,\u0007+\u0019:b[\u000eCWmY6!\u0011\u001d\tI,\u001fC!\u0003w\u000b!bY1o!J|7-Z:t)\u0011\ti,a1\u0011\u0007q\ny,C\u0002\u0002Bv\u0012qAQ8pY\u0016\fg\u000eC\u00044\u0003o\u0003\r!!2\u0011\u000bUB\u00141\u0005#\u0007\r\u0005%\u0017\u0010QAf\u0005QA%)Y:f\t\u0006$\u0018m\u0015;pe\u0016\u001cuN\u001c4jONI\u0011qY>\u0002N\u0006M\u0017\u0011\u001c\t\u0004\u007f\u0006=\u0017\u0002BAi\u0003/\u0011acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\t\u0004y\u0005U\u0017bAAl{\t9\u0001K]8ek\u000e$\bc\u0001\u001f\u0002\\&\u0011\u0011*\u0010\u0005\f\u0003?\f9M!f\u0001\n\u0003\t\t/A\u0004dCR\fGn\\4\u0016\u0003iB!\"!:\u0002H\nE\t\u0015!\u0003;\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0003bCAu\u0003\u000f\u0014)\u001a!C\u0001\u0003W\fAB]3n_R,g)\u001b7uKJ,\"!!0\t\u0017\u0005=\u0018q\u0019B\tB\u0003%\u0011QX\u0001\u000ee\u0016lw\u000e^3GS2$XM\u001d\u0011\t\u0017\u0005M\u0018q\u0019BK\u0002\u0013\u0005\u00111^\u0001\u000eO\u0016tWM]1uKN#\u0018\r^:\t\u0017\u0005]\u0018q\u0019B\tB\u0003%\u0011QX\u0001\u000fO\u0016tWM]1uKN#\u0018\r^:!\u0011-\tY0a2\u0003\u0016\u0004%\t!!@\u0002\u000b\u0005,H-\u001b;\u0016\u0005\u0005}\b#\u0002\u001f\u0003\u0002\t\u0015\u0011b\u0001B\u0002{\t1q\n\u001d;j_:\u0004\u0002\u0002\u0010B\u0004\u0005\u0017\u0011)BO\u0005\u0004\u0005\u0013i$A\u0002+va2,7\u0007\u0005\u0003\u0003\u000e\tEQB\u0001B\b\u0015\u0011\tY0!\u0013\n\t\tM!q\u0002\u0002\f\u0003V$\u0017\u000e^,sSR,'\u000f\u0005\u0003\u0003\u000e\t]\u0011\u0002\u0002B\r\u0005\u001f\u0011Q\"Q;eSR\u0004&o\u001c<jI\u0016\u0014\bb\u0003B\u000f\u0003\u000f\u0014\t\u0012)A\u0005\u0003\u007f\fa!Y;eSR\u0004\u0003b\u0003B\u0011\u0003\u000f\u0014)\u001a!C\u0001\u0005G\tA\"];fef$\u0006N]3bIN,\"A!\n\u0011\u0007q\u00129#C\u0002\u0003*u\u00121!\u00138u\u0011-\u0011i#a2\u0003\u0012\u0003\u0006IA!\n\u0002\u001bE,XM]=UQJ,\u0017\rZ:!\u0011-\u0011\t$a2\u0003\u0016\u0004%\tAa\r\u0002\u0019E,XM]=US6,w.\u001e;\u0016\u0005\tU\u0002#\u0002\u001f\u0003\u0002\t]\u0002c\u0001\u001f\u0003:%\u0019!1H\u001f\u0003\t1{gn\u001a\u0005\f\u0005\u007f\t9M!E!\u0002\u0013\u0011)$A\u0007rk\u0016\u0014\u0018\u0010V5nK>,H\u000f\t\u0005\f\u0005\u0007\n9M!f\u0001\n\u0003\u0011\u0019#\u0001\rnCb\u0014\u0016M\\4fgB+'/\u0012=uK:$W\rZ*dC:D1Ba\u0012\u0002H\nE\t\u0015!\u0003\u0003&\u0005IR.\u0019=SC:<Wm\u001d)fe\u0016CH/\u001a8eK\u0012\u001c6-\u00198!\u0011-\u0011Y%a2\u0003\u0016\u0004%\t!a;\u0002\u00131|wn]3C\u0005>D\bb\u0003B(\u0003\u000f\u0014\t\u0012)A\u0005\u0003{\u000b!\u0002\\8pg\u0016\u0014%i\u001c=!\u0011-\u0011\u0019&a2\u0003\u0016\u0004%\t!a;\u0002\u000f\r\f7\r[5oO\"Y!qKAd\u0005#\u0005\u000b\u0011BA_\u0003!\u0019\u0017m\u00195j]\u001e\u0004\u0003b\u0003B.\u0003\u000f\u0014)\u001a!C\u0001\u0005;\nA\"Y;uQB\u0013xN^5eKJ,\"Aa\u0018\u0011\u000bq\u0012\tA!\u0019\u0011\t\t\r$\u0011N\u0007\u0003\u0005KR1Aa\u001a\u0007\u0003!\u0019XmY;sSRL\u0018\u0002\u0002B6\u0005K\u0012a#Q;uQ>\u0014\u0018N_1uS>t7\u000f\u0015:pm&$WM\u001d\u0005\f\u0005_\n9M!E!\u0002\u0013\u0011y&A\u0007bkRD\u0007K]8wS\u0012,'\u000f\t\u0005\f\u0005g\n9M!f\u0001\n\u0003\u0011)(\u0001\bd_B\u0014xnY3tg>\u0014XK\u001d7\u0016\u0005\t]\u0004#\u0002\u001f\u0003\u0002\te\u0004\u0003\u0002B>\u0005\u0003k!A! \u000b\u0007\t}t,\u0001\u0002gg&!!1\u0011B?\u0005\u0011\u0001\u0016\r\u001e5\t\u0017\t\u001d\u0015q\u0019B\tB\u0003%!qO\u0001\u0010G>\u0004(o\\2fgN|'/\u0016:mA!Y!1RAd\u0005+\u0007I\u0011\u0001BG\u0003%q\u0017-\\3ta\u0006\u001cW-\u0006\u0002\u0003\u0010B!AH!\u0001;\u0011-\u0011\u0019*a2\u0003\u0012\u0003\u0006IAa$\u0002\u00159\fW.Z:qC\u000e,\u0007\u0005C\u0004)\u0003\u000f$\tAa&\u00155\te%Q\u0014BP\u0005C\u0013\u0019K!*\u0003(\n%&1\u0016BW\u0005_\u0013\tLa-\u0011\t\tm\u0015qY\u0007\u0002s\"9\u0011q\u001cBK\u0001\u0004Q\u0004\u0002CAu\u0005+\u0003\r!!0\t\u0011\u0005M(Q\u0013a\u0001\u0003{C\u0001\"a?\u0003\u0016\u0002\u0007\u0011q \u0005\t\u0005C\u0011)\n1\u0001\u0003&!A!\u0011\u0007BK\u0001\u0004\u0011)\u0004\u0003\u0005\u0003D\tU\u0005\u0019\u0001B\u0013\u0011!\u0011YE!&A\u0002\u0005u\u0006\u0002\u0003B*\u0005+\u0003\r!!0\t\u0011\tm#Q\u0013a\u0001\u0005?B\u0001Ba\u001d\u0003\u0016\u0002\u0007!q\u000f\u0005\t\u0005\u0017\u0013)\n1\u0001\u0003\u0010\"Q!qWAd\u0003\u0003%\tA!/\u0002\t\r|\u0007/\u001f\u000b\u001b\u00053\u0013YL!0\u0003@\n\u0005'1\u0019Bc\u0005\u000f\u0014IMa3\u0003N\n='\u0011\u001b\u0005\n\u0003?\u0014)\f%AA\u0002iB!\"!;\u00036B\u0005\t\u0019AA_\u0011)\t\u0019P!.\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\u000b\u0003w\u0014)\f%AA\u0002\u0005}\bB\u0003B\u0011\u0005k\u0003\n\u00111\u0001\u0003&!Q!\u0011\u0007B[!\u0003\u0005\rA!\u000e\t\u0015\t\r#Q\u0017I\u0001\u0002\u0004\u0011)\u0003\u0003\u0006\u0003L\tU\u0006\u0013!a\u0001\u0003{C!Ba\u0015\u00036B\u0005\t\u0019AA_\u0011)\u0011YF!.\u0011\u0002\u0003\u0007!q\f\u0005\u000b\u0005g\u0012)\f%AA\u0002\t]\u0004B\u0003BF\u0005k\u0003\n\u00111\u0001\u0003\u0010\"Q!Q[Ad#\u0003%\tAa6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u001c\u0016\u0004u\tm7F\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dX(\u0001\u0006b]:|G/\u0019;j_:LAAa;\u0003b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t=\u0018qYI\u0001\n\u0003\u0011\t0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM(\u0006BA_\u00057D!Ba>\u0002HF\u0005I\u0011\u0001By\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB!Ba?\u0002HF\u0005I\u0011\u0001B\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa@+\t\u0005}(1\u001c\u0005\u000b\u0007\u0007\t9-%A\u0005\u0002\r\u0015\u0011AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0007\u000fQCA!\n\u0003\\\"Q11BAd#\u0003%\ta!\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\u0002\u0016\u0005\u0005k\u0011Y\u000e\u0003\u0006\u0004\u0014\u0005\u001d\u0017\u0013!C\u0001\u0007\u000b\tabY8qs\u0012\"WMZ1vYR$s\u0007\u0003\u0006\u0004\u0018\u0005\u001d\u0017\u0013!C\u0001\u0005c\fabY8qs\u0012\"WMZ1vYR$\u0003\b\u0003\u0006\u0004\u001c\u0005\u001d\u0017\u0013!C\u0001\u0005c\fabY8qs\u0012\"WMZ1vYR$\u0013\b\u0003\u0006\u0004 \u0005\u001d\u0017\u0013!C\u0001\u0007C\tqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0007GQCAa\u0018\u0003\\\"Q1qEAd#\u0003%\ta!\u000b\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cE*\"aa\u000b+\t\t]$1\u001c\u0005\u000b\u0007_\t9-%A\u0005\u0002\rE\u0012aD2paf$C-\u001a4bk2$H%\r\u001a\u0016\u0005\rM\"\u0006\u0002BH\u00057D!ba\u000e\u0002H\u0006\u0005I\u0011IA\u0011\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"Q11HAd\u0003\u0003%\tAa\t\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\r}\u0012qYA\u0001\n\u0003\u0019\t%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%61\t\u0005\u000b\u0007\u000b\u001ai$!AA\u0002\t\u0015\u0012a\u0001=%c!Q1\u0011JAd\u0003\u0003%\tea\u0013\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0014\u0011\r\r=3QKAU\u001b\t\u0019\tFC\u0002\u0004Tu\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199f!\u0015\u0003\u0011%#XM]1u_JD!ba\u0017\u0002H\u0006\u0005I\u0011AB/\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA_\u0007?B!b!\u0012\u0004Z\u0005\u0005\t\u0019AAU\u0011)\u0019\u0019'a2\u0002\u0002\u0013\u00053QM\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!Q\u0005\u0005\u000b\u0007S\n9-!A\u0005B\r-\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0002BCB8\u0003\u000f\f\t\u0011\"\u0011\u0004r\u00051Q-];bYN$B!!0\u0004t!Q1QIB7\u0003\u0003\u0005\r!!+\b\u0013\r]\u00140!A\t\u0002\re\u0014\u0001\u0006%CCN,G)\u0019;b'R|'/Z\"p]\u001aLw\r\u0005\u0003\u0003\u001c\u000emd!CAes\u0006\u0005\t\u0012AB?'\u0019\u0019Yha \u0002ZBi2\u0011QBDu\u0005u\u0016QXA\u0000\u0005K\u0011)D!\n\u0002>\u0006u&q\fB<\u0005\u001f\u0013I*\u0004\u0002\u0004\u0004*\u00191QQ\u001f\u0002\u000fI,h\u000e^5nK&!1\u0011RBB\u0005I\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u001a\t\u000f!\u001aY\b\"\u0001\u0004\u000eR\u00111\u0011\u0010\u0005\u000b\u0007S\u001aY(!A\u0005F\r-\u0004BCBJ\u0007w\n\t\u0011\"!\u0004\u0016\u0006)\u0011\r\u001d9msRQ\"\u0011TBL\u00073\u001bYj!(\u0004 \u000e\u000561UBS\u0007O\u001bIka+\u0004.\"9\u0011q\\BI\u0001\u0004Q\u0004\u0002CAu\u0007#\u0003\r!!0\t\u0011\u0005M8\u0011\u0013a\u0001\u0003{C\u0001\"a?\u0004\u0012\u0002\u0007\u0011q \u0005\t\u0005C\u0019\t\n1\u0001\u0003&!A!\u0011GBI\u0001\u0004\u0011)\u0004\u0003\u0005\u0003D\rE\u0005\u0019\u0001B\u0013\u0011!\u0011Ye!%A\u0002\u0005u\u0006\u0002\u0003B*\u0007#\u0003\r!!0\t\u0011\tm3\u0011\u0013a\u0001\u0005?B\u0001Ba\u001d\u0004\u0012\u0002\u0007!q\u000f\u0005\t\u0005\u0017\u001b\t\n1\u0001\u0003\u0010\"Q1\u0011WB>\u0003\u0003%\tia-\u0002\u000fUt\u0017\r\u001d9msR!1QWB_!\u0015a$\u0011AB\\!ia4\u0011\u0018\u001e\u0002>\u0006u\u0016q B\u0013\u0005k\u0011)#!0\u0002>\n}#q\u000fBH\u0013\r\u0019Y,\u0010\u0002\b)V\u0004H.Z\u00193\u0011)\u0019yla,\u0002\u0002\u0003\u0007!\u0011T\u0001\u0004q\u0012\u0002\u0004BCBb\u0007w\n\t\u0011\"\u0003\u0004F\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005q\u0001bBBes\u0012\u000511Z\u0001\u0013EVLG\u000eZ!vi\"\u001c\bK]8wS\u0012,'\u000f\u0006\u0004\u0003b\r57q\u001a\u0005\u00073\u000e\u001d\u0007\u0019\u0001.\t\rM\u001a9\r1\u00015\u0011\u001d\u0019\u0019\u000e\u0001C\t\u0003W\f!C^1mS\u0012\fG/Z\"p]:,7\r^5p]\"91q\u001b\u0001\u0005B\re\u0017aC5t\u0003Z\f\u0017\u000e\\1cY\u0016$\"!!0\t\u000f\ru\u0007\u0001\"\u0011\u0004`\u0006qq-\u001a;ESN\u0004H.Y=OC6,G#\u0001\u001e\t\u000f\r\r\b\u0001\"\u0011\u0004`\u0006qq-\u001a;EKN\u001c'/\u001b9uS>t\u0007bBBt\u0001\u0011\u00053\u0011^\u0001\u0012O\u0016$\b+\u0019:b[\u0016$XM]:J]\u001a|GCABv!\u0015a\u00141PBw!\u0011\u0019yo!@\u000f\t\rE8\u0011 \b\u0005\u0007g\u001c9PD\u0002n\u0007kL!A\u0007\u0006\n\u0005\rI\u0012bAB~1\u0005\tB)\u0019;b\u0003\u000e\u001cWm]:GC\u000e$xN]=\n\t\r}H\u0011\u0001\u0002\u0006!\u0006\u0014\u0018-\u001c\u0006\u0004\u0007wD\u0002bBA]\u0001\u0011\u0005CQ\u0001\u000b\u0005\u0003{#9\u0001\u0003\u00044\t\u0007\u0001\r\u0001\u000e\u0005\b\t\u0017\u0001A\u0011\tC\u0007\u0003Y9W\r^%na2,W.\u001a8uCRLwN\u001c%j]R\u001cHC\u0001C\ba\u0011!\t\u0002\"\u000b\u0011\rUBD1\u0003C\u0014!\u0011!)\u0002\"\t\u000f\t\u0011]AQD\u0007\u0003\t3Q1\u0001b\u0007\u0013\u0003\r\tw\u000f^\u0005\u0005\t?!I\"\u0001\bSK:$WM]5oO\"Kg\u000e^:\n\t\u0011\rBQ\u0005\u0002\u0004\u0017\u0016L(\u0002\u0002C\u0010\t3\u0001B!!$\u0005*\u0011aA1\u0006C\u0005\u0003\u0003\u0005\tQ!\u0001\u0002\"\n\u0019q\fJ\u0019")
public class HBaseDataStoreFactory
implements DataStoreFactorySpi,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static AuthorizationsProvider buildAuthsProvider(Connection connection, Map<String, Serializable> map) {
        return HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection, map);
    }

    public static GeoMesaParam<?>[] ParameterInfo() {
        return HBaseDataStoreFactory$.MODULE$.ParameterInfo();
    }

    public static String Description() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public static String DisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    public static GeoMesaSystemProperties.SystemProperty ConfigPathProperty() {
        return HBaseDataStoreFactory$.MODULE$.ConfigPathProperty();
    }

    public static GeoMesaSystemProperties.SystemProperty RemoteFilterProperty() {
        return HBaseDataStoreFactory$.MODULE$.RemoteFilterProperty();
    }

    public static String HBaseGeoMesaKeyTab() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab();
    }

    public static String HBaseGeoMesaPrincipal() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal();
    }

    private Logger logger$lzycompute() {
        HBaseDataStoreFactory hBaseDataStoreFactory = this;
        synchronized (hBaseDataStoreFactory) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) {
        return this.createDataStore(params);
    }

    public DataStore createDataStore(Map<String, Serializable> params) {
        BoxedUnit boxedUnit;
        Connection connection = HBaseConnectionPool$.MODULE$.getConnection(params, this.validateConnection());
        String catalog = this.getCatalog(params);
        boolean remoteFilters = BoxesRunTime.unboxToBoolean((Object)HBaseDataStoreParams$.MODULE$.RemoteFilteringParam().lookupOpt(params).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$1) {
                return x$1;
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(HBaseDataStoreFactory$.MODULE$.RemoteFilterProperty().get())).toBoolean();
            }
        }));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Using {} filtering", new Object[]{remoteFilters ? "remote" : "local"});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Boolean generateStats = (Boolean)HBaseDataStoreParams$.MODULE$.GenerateStatsParam().lookup(params);
        None$ audit = Predef$.MODULE$.Boolean2boolean((Boolean)HBaseDataStoreParams$.MODULE$.AuditQueriesParam().lookup(params)) ? new Some((Object)new Tuple3((Object)AuditLogger$.MODULE$, Option$.MODULE$.apply((Object)AuditProvider.Loader.load(params)).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NoOpAuditProvider$ apply() {
                return NoOpAuditProvider$.MODULE$;
            }
        }), (Object)"hbase")) : None$.MODULE$;
        Integer queryThreads = (Integer)HBaseDataStoreParams$.MODULE$.QueryThreadsParam().lookup(params);
        Option queryTimeout = HBaseDataStoreParams$.MODULE$.QueryTimeoutParam().lookupOpt(params).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$2) {
                return x$2.toMillis();
            }
        });
        Integer maxRangesPerExtendedScan = (Integer)HBaseDataStoreParams$.MODULE$.MaxRangesPerExtendedScanParam().lookup(params);
        Boolean looseBBox = (Boolean)HBaseDataStoreParams$.MODULE$.LooseBBoxParam().lookup(params);
        Boolean caching = (Boolean)HBaseDataStoreParams$.MODULE$.CachingParam().lookup(params);
        None$ authsProvider = Predef$.MODULE$.Boolean2boolean((Boolean)HBaseDataStoreParams$.MODULE$.EnableSecurityParam().lookup(params)) ? new Some((Object)HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection, params)) : None$.MODULE$;
        Option coprocessorUrl2 = HBaseDataStoreParams$.MODULE$.CoprocessorUrlParam().lookupOpt(params);
        Option ns = HBaseDataStoreParams$.MODULE$.NamespaceParam().lookupOpt(params);
        HBaseDataStoreConfig config = new HBaseDataStoreConfig(catalog, remoteFilters, Predef$.MODULE$.Boolean2boolean(generateStats), (Option<Tuple3<AuditWriter, AuditProvider, String>>)audit, Predef$.MODULE$.Integer2int(queryThreads), (Option<Object>)queryTimeout, Predef$.MODULE$.Integer2int(maxRangesPerExtendedScan), Predef$.MODULE$.Boolean2boolean(looseBBox), Predef$.MODULE$.Boolean2boolean(caching), (Option<AuthorizationsProvider>)authsProvider, (Option<Path>)coprocessorUrl2, (Option<String>)ns);
        HBaseDataStore ds = this.buildDataStore(connection, config);
        GeoMesaDataStore$.MODULE$.initRemoteVersion((GeoMesaDataStore)ds);
        return ds;
    }

    public String getCatalog(Map<String, Serializable> params) {
        return (String)HBaseDataStoreParams$.MODULE$.HBaseCatalogParam().lookup(params);
    }

    public HBaseDataStore buildDataStore(Connection connection, HBaseDataStoreConfig config) {
        return new HBaseDataStore(connection, config);
    }

    public boolean validateConnection() {
        return true;
    }

    public boolean isAvailable() {
        return true;
    }

    public String getDisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    public String getDescription() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return (DataAccessFactory.Param[])Predef$.MODULE$.refArrayOps((Object[])HBaseDataStoreFactory$.MODULE$.ParameterInfo()).$colon$plus(HBaseDataStoreParams$.MODULE$.NamespaceParam(), ClassTag$.MODULE$.apply(DataAccessFactory.Param.class));
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return HBaseDataStoreFactory$.MODULE$.canProcess(params);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public HBaseDataStoreFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class HBaseDataStoreConfig
    implements GeoMesaDataStoreFactory.GeoMesaDataStoreConfig,
    Product,
    scala.Serializable {
        private final String catalog;
        private final boolean remoteFilter;
        private final boolean generateStats;
        private final Option<Tuple3<AuditWriter, AuditProvider, String>> audit;
        private final int queryThreads;
        private final Option<Object> queryTimeout;
        private final int maxRangesPerExtendedScan;
        private final boolean looseBBox;
        private final boolean caching;
        private final Option<AuthorizationsProvider> authProvider;
        private final Option<Path> coprocessorUrl;
        private final Option<String> namespace;

        public String catalog() {
            return this.catalog;
        }

        public boolean remoteFilter() {
            return this.remoteFilter;
        }

        public boolean generateStats() {
            return this.generateStats;
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> audit() {
            return this.audit;
        }

        public int queryThreads() {
            return this.queryThreads;
        }

        public Option<Object> queryTimeout() {
            return this.queryTimeout;
        }

        public int maxRangesPerExtendedScan() {
            return this.maxRangesPerExtendedScan;
        }

        public boolean looseBBox() {
            return this.looseBBox;
        }

        public boolean caching() {
            return this.caching;
        }

        public Option<AuthorizationsProvider> authProvider() {
            return this.authProvider;
        }

        public Option<Path> coprocessorUrl() {
            return this.coprocessorUrl;
        }

        public Option<String> namespace() {
            return this.namespace;
        }

        public HBaseDataStoreConfig copy(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl2, Option<String> namespace) {
            return new HBaseDataStoreConfig(catalog, remoteFilter, generateStats, audit, queryThreads, queryTimeout, maxRangesPerExtendedScan, looseBBox, caching, authProvider, coprocessorUrl2, namespace);
        }

        public String copy$default$1() {
            return this.catalog();
        }

        public boolean copy$default$2() {
            return this.remoteFilter();
        }

        public boolean copy$default$3() {
            return this.generateStats();
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> copy$default$4() {
            return this.audit();
        }

        public int copy$default$5() {
            return this.queryThreads();
        }

        public Option<Object> copy$default$6() {
            return this.queryTimeout();
        }

        public int copy$default$7() {
            return this.maxRangesPerExtendedScan();
        }

        public boolean copy$default$8() {
            return this.looseBBox();
        }

        public boolean copy$default$9() {
            return this.caching();
        }

        public Option<AuthorizationsProvider> copy$default$10() {
            return this.authProvider();
        }

        public Option<Path> copy$default$11() {
            return this.coprocessorUrl();
        }

        public Option<String> copy$default$12() {
            return this.namespace();
        }

        public String productPrefix() {
            return "HBaseDataStoreConfig";
        }

        public int productArity() {
            return 12;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 11: {
                    object = this.namespace();
                    break;
                }
                case 10: {
                    object = this.coprocessorUrl();
                    break;
                }
                case 9: {
                    object = this.authProvider();
                    break;
                }
                case 8: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.caching());
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.looseBBox());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToInteger((int)this.maxRangesPerExtendedScan());
                    break;
                }
                case 5: {
                    object = this.queryTimeout();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.queryThreads());
                    break;
                }
                case 3: {
                    object = this.audit();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.generateStats());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.remoteFilter());
                    break;
                }
                case 0: {
                    object = this.catalog();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HBaseDataStoreConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.catalog()));
            n = Statics.mix((int)n, (int)(this.remoteFilter() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.generateStats() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.audit()));
            n = Statics.mix((int)n, (int)this.queryThreads());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryTimeout()));
            n = Statics.mix((int)n, (int)this.maxRangesPerExtendedScan());
            n = Statics.mix((int)n, (int)(this.looseBBox() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.caching() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.authProvider()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.coprocessorUrl()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.namespace()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HBaseDataStoreConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            HBaseDataStoreConfig hBaseDataStoreConfig = (HBaseDataStoreConfig)x$1;
            String string = this.catalog();
            String string2 = hBaseDataStoreConfig.catalog();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.remoteFilter() != hBaseDataStoreConfig.remoteFilter()) return false;
            if (this.generateStats() != hBaseDataStoreConfig.generateStats()) return false;
            Option<Tuple3<AuditWriter, AuditProvider, String>> option = this.audit();
            Option<Tuple3<AuditWriter, AuditProvider, String>> option2 = hBaseDataStoreConfig.audit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.queryThreads() != hBaseDataStoreConfig.queryThreads()) return false;
            Option<Object> option3 = this.queryTimeout();
            Option<Object> option4 = hBaseDataStoreConfig.queryTimeout();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (this.maxRangesPerExtendedScan() != hBaseDataStoreConfig.maxRangesPerExtendedScan()) return false;
            if (this.looseBBox() != hBaseDataStoreConfig.looseBBox()) return false;
            if (this.caching() != hBaseDataStoreConfig.caching()) return false;
            Option<AuthorizationsProvider> option5 = this.authProvider();
            Option<AuthorizationsProvider> option6 = hBaseDataStoreConfig.authProvider();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Path> option7 = this.coprocessorUrl();
            Option<Path> option8 = hBaseDataStoreConfig.coprocessorUrl();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<String> option9 = this.namespace();
            Option<String> option10 = hBaseDataStoreConfig.namespace();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            if (!hBaseDataStoreConfig.canEqual(this)) return false;
            return true;
        }

        public HBaseDataStoreConfig(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl2, Option<String> namespace) {
            this.catalog = catalog;
            this.remoteFilter = remoteFilter;
            this.generateStats = generateStats;
            this.audit = audit;
            this.queryThreads = queryThreads;
            this.queryTimeout = queryTimeout;
            this.maxRangesPerExtendedScan = maxRangesPerExtendedScan;
            this.looseBBox = looseBBox;
            this.caching = caching;
            this.authProvider = authProvider;
            this.coprocessorUrl = coprocessorUrl2;
            this.namespace = namespace;
            Product.class.$init$((Product)this);
        }
    }
}

