/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.analytic.SamplingVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t1\u0002JQ1tK\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|gN\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\tO\u0016|Go\\8mg*\u00111CB\u0001\u0006S:$W\r_\u0005\u0003+A\u0011\u0001dR3p\u001b\u0016\u001c\u0018MR3biV\u0014XmQ8mY\u0016\u001cG/[8o!\t9b$D\u0001\u0019\u0015\tI\"$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001c9\u0005AA/\u001f9fg\u00064WMC\u0001\u001e\u0003\r\u0019w.\\\u0005\u0003?a\u00111\u0002T1{s2{wmZ5oO\"I\u0011\u0005\u0001B\u0001B\u0003%!%J\u0001\u0007g>,(oY3\u0011\u0005=\u0019\u0013B\u0001\u0013\u0011\u0005Q9Um\\'fg\u00064U-\u0019;ve\u0016\u001cv.\u001e:dK&\u0011\u0011\u0005\u0006\u0005\nO\u0001\u0011\t\u0011)A\u0005Q9\nQ!];fef\u0004\"!\u000b\u0017\u000e\u0003)R!aA\u0016\u000b\u0005EQ\u0011BA\u0017+\u0005\u0015\tV/\u001a:z\u0013\t9C\u0003C\u00031\u0001\u0011\u0005\u0011'\u0001\u0004=S:LGO\u0010\u000b\u0004eQ*\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\u00110\u0001\u0004\u0011\u0003\"B\u00140\u0001\u0004A\u0003\"B\u001c\u0001\t\u0003B\u0014aB1dG\u0016\u0004Ho\u001d\u000b\u0004s}J\u0005C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001B+oSRDQ\u0001\u0011\u001cA\u0002\u0005\u000bqA^5tSR|'\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u00069a-Z1ukJ,'B\u0001$\u000b\u0003\u001dy\u0007/\u001a8hSNL!\u0001S\"\u0003\u001d\u0019+\u0017\r^;sKZK7/\u001b;pe\")!J\u000ea\u0001\u0017\u0006A\u0001O]8he\u0016\u001c8\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u000b\u0006!Q\u000f^5m\u0013\t\u0001VJ\u0001\tQe><'/Z:t\u0019&\u001cH/\u001a8fe\u0002")
public class HBaseFeatureCollection
extends GeoMesaFeatureCollection
implements LazyLogging {
    private final GeoMesaFeatureSource source;
    private final Query query;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        HBaseFeatureCollection hBaseFeatureCollection = this;
        synchronized (hBaseFeatureCollection) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        FeatureVisitor featureVisitor = visitor;
        if (featureVisitor instanceof SamplingVisitor) {
            super.accepts(visitor, progress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (featureVisitor instanceof GeoMesaProcessVisitor) {
            GeoMesaProcessVisitor geoMesaProcessVisitor = (GeoMesaProcessVisitor)featureVisitor;
            geoMesaProcessVisitor.execute((SimpleFeatureSource)this.source, this.query);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using fallback FeatureVisitor for process {}.", new Object[]{featureVisitor.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            super.accepts(visitor, progress);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public HBaseFeatureCollection(GeoMesaFeatureSource source, Query query) {
        this.source = source;
        this.query = query;
        super(source, query);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

