/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.filters;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoBufferSimpleFeature;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.hbase.filters.CqlTransformFilter;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.iterators.IteratorCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class CqlTransformFilter$
implements StrictLogging {
    public static final CqlTransformFilter$ MODULE$;
    private final int Priority;
    private final Logger logger;

    static {
        new CqlTransformFilter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int Priority() {
        return this.Priority;
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        return new CqlTransformFilter(this.deserialize(pbBytes));
    }

    public CqlTransformFilter apply(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?, ?> index, Option<org.opengis.filter.Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        Option<org.opengis.filter.Filter> option;
        block7: {
            CqlTransformFilter.DelegateFilter delegateFilter;
            block5: {
                Some some;
                boolean bl;
                KryoBufferSimpleFeature feature;
                block6: {
                    block4: {
                        if (filter.isEmpty() && transform.isEmpty()) {
                            throw new IllegalArgumentException("The filter must have a predicate and/or transform");
                        }
                        feature = KryoFeatureSerializer$.MODULE$.apply(sft, SerializationOption.SerializationOptions$.MODULE$.withoutId()).getReusableFeature();
                        transform.foreach((Function1)new Serializable(feature){
                            public static final long serialVersionUID = 0L;
                            private final KryoBufferSimpleFeature feature$1;

                            public final void apply(Tuple2<String, SimpleFeatureType> x0$1) {
                                Tuple2<String, SimpleFeatureType> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String tdefs = (String)tuple2._1();
                                    SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
                                    this.feature$1.setTransforms(tdefs, tsft);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.feature$1 = feature$1;
                            }
                        });
                        bl = false;
                        some = null;
                        option = filter;
                        if (!None$.MODULE$.equals(option)) break block4;
                        delegateFilter = new CqlTransformFilter.TransformDelegate(sft, index, feature);
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    bl = true;
                    some = (Some)option;
                    org.opengis.filter.Filter f = (org.opengis.filter.Filter)some.x();
                    if (!transform.isEmpty()) break block6;
                    delegateFilter = new CqlTransformFilter.FilterDelegate(sft, index, feature, f);
                    break block5;
                }
                if (!bl) break block7;
                org.opengis.filter.Filter f = (org.opengis.filter.Filter)some.x();
                delegateFilter = new CqlTransformFilter.FilterTransformDelegate(sft, index, feature, f);
            }
            CqlTransformFilter.TransformDelegate delegate = delegateFilter;
            return new CqlTransformFilter(delegate);
        }
        throw new MatchError(option);
    }

    public byte[] org$locationtech$geomesa$hbase$filters$CqlTransformFilter$$serialize(CqlTransformFilter.DelegateFilter delegate) {
        Option<Tuple2<String, SimpleFeatureType>> option;
        block4: {
            byte[] byArray;
            block3: {
                Some some;
                Tuple2 tuple2;
                byte[] indexBytes;
                byte[] cqlBytes;
                byte[] sftBytes;
                block2: {
                    sftBytes = SimpleFeatureTypes$.MODULE$.encodeType(delegate.sft(), true).getBytes(StandardCharsets.UTF_8);
                    cqlBytes = (byte[])delegate.filter().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(org.opengis.filter.Filter x$1) {
                            return ECQL.toCQL((org.opengis.filter.Filter)x$1).getBytes(StandardCharsets.UTF_8);
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply() {
                            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                        }
                    });
                    indexBytes = delegate.index().identifier().getBytes(StandardCharsets.UTF_8);
                    option = delegate.transform();
                    if (!None$.MODULE$.equals(option)) break block2;
                    byte[] array = (byte[])Array$.MODULE$.ofDim(sftBytes.length + cqlBytes.length + indexBytes.length + 16, ClassTag$.MODULE$.Byte());
                    int offset = 0;
                    ByteArrays$.MODULE$.writeInt(sftBytes.length, array, offset);
                    System.arraycopy(sftBytes, 0, array, offset += 4, sftBytes.length);
                    ByteArrays$.MODULE$.writeInt(cqlBytes.length, array, offset += sftBytes.length);
                    System.arraycopy(cqlBytes, 0, array, offset += 4, cqlBytes.length);
                    ByteArrays$.MODULE$.writeInt(-1, array, offset += cqlBytes.length);
                    ByteArrays$.MODULE$.writeInt(indexBytes.length, array, offset += 4);
                    System.arraycopy(indexBytes, 0, array, offset += 4, indexBytes.length);
                    byArray = array;
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                String tdefs = (String)tuple2._1();
                SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
                byte[] tdefsBytes = tdefs.getBytes(StandardCharsets.UTF_8);
                byte[] tsftBytes = SimpleFeatureTypes$.MODULE$.encodeType(tsft).getBytes(StandardCharsets.UTF_8);
                byte[] array = (byte[])Array$.MODULE$.ofDim(sftBytes.length + cqlBytes.length + tdefsBytes.length + tsftBytes.length + indexBytes.length + 20, ClassTag$.MODULE$.Byte());
                int offset = 0;
                ByteArrays$.MODULE$.writeInt(sftBytes.length, array, offset);
                System.arraycopy(sftBytes, 0, array, offset += 4, sftBytes.length);
                ByteArrays$.MODULE$.writeInt(cqlBytes.length, array, offset += sftBytes.length);
                System.arraycopy(cqlBytes, 0, array, offset += 4, cqlBytes.length);
                ByteArrays$.MODULE$.writeInt(tdefsBytes.length, array, offset += cqlBytes.length);
                System.arraycopy(tdefsBytes, 0, array, offset += 4, tdefsBytes.length);
                ByteArrays$.MODULE$.writeInt(tsftBytes.length, array, offset += tdefsBytes.length);
                System.arraycopy(tsftBytes, 0, array, offset += 4, tsftBytes.length);
                ByteArrays$.MODULE$.writeInt(indexBytes.length, array, offset += tsftBytes.length);
                System.arraycopy(indexBytes, 0, array, offset += 4, indexBytes.length);
                byArray = array;
            }
            return byArray;
        }
        throw new MatchError(option);
    }

    private CqlTransformFilter.DelegateFilter deserialize(byte[] bytes) throws DeserializationException {
        try {
            CqlTransformFilter.DelegateFilter delegateFilter;
            int offset = 0;
            int sftLength = ByteArrays$.MODULE$.readInt(bytes, offset);
            String spec = new String(bytes, offset += 4, sftLength);
            SimpleFeatureType sft = IteratorCache$.MODULE$.sft(spec);
            KryoBufferSimpleFeature feature = IteratorCache$.MODULE$.serializer(spec, SerializationOption.SerializationOptions$.MODULE$.withoutId()).getReusableFeature();
            int cqlLength = ByteArrays$.MODULE$.readInt(bytes, offset += sftLength);
            org.opengis.filter.Filter cql = cqlLength == 0 ? null : IteratorCache$.MODULE$.filter(sft, spec, new String(bytes, offset += 4, cqlLength));
            int tdefsLength = ByteArrays$.MODULE$.readInt(bytes, offset += cqlLength);
            if (tdefsLength == -1) {
                if (cql == null) {
                    throw new DeserializationException("No filter or transform defined");
                }
                GeoMesaFeatureIndex<?, ?, ?> index = this.deserializeIndex(sft, spec, bytes, offset + 4);
                delegateFilter = new CqlTransformFilter.FilterDelegate(sft, index, feature, cql);
            } else {
                String tdefs = new String(bytes, offset += 4, tdefsLength);
                int tsftLength = ByteArrays$.MODULE$.readInt(bytes, offset += tdefsLength);
                SimpleFeatureType tsft = IteratorCache$.MODULE$.sft(new String(bytes, offset += 4, tsftLength));
                feature.setTransforms(tdefs, tsft);
                GeoMesaFeatureIndex<?, ?, ?> index = this.deserializeIndex(sft, spec, bytes, offset + tsftLength);
                delegateFilter = cql == null ? new CqlTransformFilter.TransformDelegate(sft, index, feature) : new CqlTransformFilter.FilterTransformDelegate(sft, index, feature, cql);
            }
            return delegateFilter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof DeserializationException) {
                DeserializationException deserializationException = (DeserializationException)throwable2;
                throw deserializationException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new DeserializationException("Error deserializing filter", e);
        }
    }

    private GeoMesaFeatureIndex<?, ?, ?> deserializeIndex(SimpleFeatureType sft, String spec, byte[] bytes, int start) {
        HBaseFeatureIndex hBaseFeatureIndex;
        if (bytes.length <= start) {
            hBaseFeatureIndex = null;
        } else {
            int offset = start;
            int identifierLength = ByteArrays$.MODULE$.readInt(bytes, offset);
            hBaseFeatureIndex = HBaseFeatureIndex$.MODULE$.index(new String(bytes, offset += 4, identifierLength, StandardCharsets.UTF_8));
        }
        return hBaseFeatureIndex;
    }

    private CqlTransformFilter$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.Priority = 30;
    }
}

