/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig;
import org.locationtech.geomesa.hbase.data.CoprocessorPlan;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.data.ScanPlan;
import org.locationtech.geomesa.hbase.index.HBaseColumnGroups$;
import org.locationtech.geomesa.hbase.index.HBasePlatform;
import org.locationtech.geomesa.hbase.index.HBasePlatform$;
import org.locationtech.geomesa.hbase.package$HBaseSystemProperties$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class HBasePlatform$class {
    public static HBaseQueryPlan buildPlatformScanPlan(HBasePlatform $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Seq ranges, byte[] colFamily, Seq tables, Seq hbaseFilters, Option coprocessor, Function1 toFeatures) {
        Option option;
        block4: {
            Product product;
            block3: {
                None$ filterList;
                block2: {
                    filterList = hbaseFilters.isEmpty() ? None$.MODULE$ : new Some(((TraversableLike)hbaseFilters.sortBy((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<Object, Filter> x$1) {
                            return x$1._1$mcI$sp();
                        }
                    }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Filter apply(Tuple2<Object, Filter> x$2) {
                            return (Filter)x$2._2();
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                    option = coprocessor;
                    if (!None$.MODULE$.equals(option)) break block2;
                    Seq scans = ((Scan)ranges.head()).isSmall() ? HBasePlatform$class.configureSmallScans($this, ds, ranges, colFamily, (Option)filterList) : HBasePlatform$class.configureMultiRowRangeFilter($this, ds, ranges, colFamily, (Option)filterList);
                    product = new ScanPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, (Seq<TableName>)tables, (Seq<Scan>)ranges, (Seq<Scan>)scans, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)toFeatures);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                CoprocessorConfig coprocessorConfig = (CoprocessorConfig)some.x();
                Scan scan2 = HBasePlatform$class.configureCoprocessorScan($this, ds, ranges, colFamily, (Option)filterList);
                product = new CoprocessorPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, (Seq<TableName>)tables, (Seq<Scan>)ranges, scan2, coprocessorConfig);
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private static Seq configureSmallScans(HBasePlatform $this, HBaseDataStore ds, Seq ranges, byte[] colFamily, Option filterList) {
        Option filter = filterList.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Filter apply(Seq<Filter> x0$1) {
                FilterList filterList;
                Seq<Filter> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    Filter f = (Filter)((SeqLike)some.get()).apply(0);
                    filterList = f;
                } else {
                    filterList = new FilterList((Filter[])seq.toArray(ClassTag$.MODULE$.apply(Filter.class)));
                }
                return filterList;
            }
        });
        ranges.foreach((Function1)new Serializable($this, ds, colFamily, filter){
            public static final long serialVersionUID = 0L;
            private final HBaseDataStore ds$1;
            private final byte[] colFamily$1;
            private final Option filter$1;

            public final void apply(Scan r) {
                r.addColumn(this.colFamily$1, HBaseColumnGroups$.MODULE$.default());
                this.filter$1.foreach((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final Scan r$1;

                    public final Scan apply(Filter x$1) {
                        return this.r$1.setFilter(x$1);
                    }
                    {
                        this.r$1 = r$1;
                    }
                });
                this.ds$1.applySecurity((Query)r);
            }
            {
                this.ds$1 = ds$1;
                this.colFamily$1 = colFamily$1;
                this.filter$1 = filter$1;
            }
        });
        return ranges;
    }

    private static Seq configureMultiRowRangeFilter(HBasePlatform $this, HBaseDataStore ds, Seq originalRanges, byte[] colFamily, Option filterList) {
        BoxedUnit boxedUnit;
        boolean cacheBlocks = BoxesRunTime.unboxToBoolean((Object)package$HBaseSystemProperties$.MODULE$.ScannerBlockCaching().toBoolean().get());
        Option cacheSize = package$HBaseSystemProperties$.MODULE$.ScannerCaching().toInt();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("HBase client scanner: block caching: {}, caching: {}", new Object[]{BoxesRunTime.boxToBoolean((boolean)cacheBlocks), cacheSize});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<MultiRowRangeFilter.RowRange> rowRanges = HBasePlatform$.MODULE$.sortAndMerge((Seq<Scan>)originalRanges);
        int rangesPerThread = package$.MODULE$.min(ds.config().maxRangesPerExtendedScan(), package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(rowRanges.size() / ds.config().queryThreads() * 2))));
        ArrayList groupedScans = new ArrayList((rowRanges.size() / rangesPerThread + 1) * 2);
        if (!rowRanges.isEmpty()) {
            int i;
            byte groupFirstByte;
            int groupStart = 0;
            int groupCount = 1;
            byte by = groupFirstByte = Predef$.MODULE$.byteArrayOps(rowRanges.get(0).getStartRow()).isEmpty() ? (byte)0 : rowRanges.get(0).getStartRow()[0];
            for (i = 1; i < rowRanges.size(); ++i) {
                MultiRowRangeFilter.RowRange nextRange = rowRanges.get(i);
                if (groupCount == rangesPerThread || nextRange.getStartRow().length > 0 && groupFirstByte != nextRange.getStartRow()[0]) {
                    HBasePlatform$class.addGroup$1($this, rowRanges.subList(groupStart, i), ds, colFamily, filterList, cacheBlocks, cacheSize, groupedScans);
                    groupFirstByte = Predef$.MODULE$.byteArrayOps(nextRange.getStopRow()).isEmpty() ? (byte)127 : nextRange.getStopRow()[0];
                    groupStart = i;
                    groupCount = 1;
                    continue;
                }
                ++groupCount;
            }
            HBasePlatform$class.addGroup$1($this, rowRanges.subList(groupStart, i), ds, colFamily, filterList, cacheBlocks, cacheSize, groupedScans);
        }
        Collections.shuffle(groupedScans);
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(groupedScans).asScala();
    }

    private static Scan configureCoprocessorScan(HBasePlatform $this, HBaseDataStore ds, Seq ranges, byte[] colFamily, Option filterList) {
        Scan scan2 = new Scan();
        scan2.addColumn(colFamily, HBaseColumnGroups$.MODULE$.default());
        MultiRowRangeFilter mrrf = new MultiRowRangeFilter(HBasePlatform$.MODULE$.sortAndMerge((Seq<Scan>)ranges));
        scan2.setFilter((Filter)new FilterList((Filter[])((TraversableOnce)filterList.map((Function1)new Serializable($this, mrrf){
            public static final long serialVersionUID = 0L;
            private final MultiRowRangeFilter mrrf$2;

            public final Seq<Filter> apply(Seq<Filter> f) {
                return (Seq)f.$plus$colon((Object)this.mrrf$2, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.mrrf$2 = mrrf$2;
            }
        }).getOrElse((Function0)new Serializable($this, mrrf){
            public static final long serialVersionUID = 0L;
            private final MultiRowRangeFilter mrrf$2;

            public final Seq<MultiRowRangeFilter> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MultiRowRangeFilter[]{this.mrrf$2}));
            }
            {
                this.mrrf$2 = mrrf$2;
            }
        })).toArray(ClassTag$.MODULE$.apply(Filter.class))));
        ds.applySecurity((Query)scan2);
        return scan2;
    }

    private static final void addGroup$1(HBasePlatform $this, List group, HBaseDataStore ds$2, byte[] colFamily$2, Option filterList$1, boolean cacheBlocks$1, Option cacheSize$1, ArrayList groupedScans$1) {
        BoxedUnit boxedUnit;
        Scan s = new Scan();
        s.setStartRow(((MultiRowRangeFilter.RowRange)group.get(0)).getStartRow());
        s.setStopRow(((MultiRowRangeFilter.RowRange)group.get(group.size() - 1)).getStopRow());
        if (group.size() > 1) {
            MultiRowRangeFilter mrrf = new MultiRowRangeFilter(group);
            boxedUnit = s.setFilter((Filter)filterList$1.map((Function1)new Serializable($this, mrrf){
                public static final long serialVersionUID = 0L;
                private final MultiRowRangeFilter mrrf$1;

                public final FilterList apply(Seq<Filter> f) {
                    return new FilterList((Filter[])((TraversableOnce)f.$plus$colon((Object)this.mrrf$1, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class)));
                }
                {
                    this.mrrf$1 = mrrf$1;
                }
            }).getOrElse((Function0)new Serializable($this, mrrf){
                public static final long serialVersionUID = 0L;
                private final MultiRowRangeFilter mrrf$1;

                public final MultiRowRangeFilter apply() {
                    return this.mrrf$1;
                }
                {
                    this.mrrf$1 = mrrf$1;
                }
            }));
        } else {
            filterList$1.foreach((Function1)new Serializable($this, s){
                public static final long serialVersionUID = 0L;
                private final Scan s$1;

                public final Scan apply(Seq<Filter> x0$2) {
                    Scan scan2;
                    Seq<Filter> seq = x0$2;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        Filter f = (Filter)((SeqLike)some.get()).apply(0);
                        scan2 = this.s$1.setFilter(f);
                    } else {
                        scan2 = this.s$1.setFilter((Filter)new FilterList((Filter[])seq.toArray(ClassTag$.MODULE$.apply(Filter.class))));
                    }
                    return scan2;
                }
                {
                    this.s$1 = s$1;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        }
        s.addColumn(colFamily$2, HBaseColumnGroups$.MODULE$.default());
        s.setCacheBlocks(cacheBlocks$1);
        cacheSize$1.foreach((Function1)new Serializable($this, s){
            public static final long serialVersionUID = 0L;
            private final Scan s$1;

            public final Scan apply(int x$1) {
                return this.s$1.setCaching(x$1);
            }
            {
                this.s$1 = s$1;
            }
        });
        ds$2.applySecurity((Query)s);
        groupedScans$1.add(s);
    }

    public static void $init$(HBasePlatform $this) {
    }
}

