/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidLine {
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geom) {
        block3: {
            block4: {
                block2: {
                    if (!(geom instanceof LineString)) break block2;
                    this.add(geom.getCoordinates());
                    break block3;
                }
                if (!(geom instanceof Polygon)) break block4;
                Polygon poly = (Polygon)geom;
                this.add(poly.getExteriorRing().getCoordinates());
                int i = 0;
                while (i < poly.getNumInteriorRing()) {
                    this.add(poly.getInteriorRingN(i).getCoordinates());
                    ++i;
                }
                break block3;
            }
            if (!(geom instanceof GeometryCollection)) break block3;
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.add(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        cent.x = this.centSum.x / this.totalLength;
        cent.y = this.centSum.y / this.totalLength;
        return cent;
    }

    public void add(Coordinate[] pts) {
        int i = 0;
        while (i < pts.length - 1) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            this.totalLength += segmentLen;
            double midx = (pts[i].x + pts[i + 1].x) / 2.0;
            this.centSum.x += segmentLen * midx;
            double midy = (pts[i].y + pts[i + 1].y) / 2.0;
            this.centSum.y += segmentLen * midy;
            ++i;
        }
    }
}

