/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private static final int INIT = 0;
    private static final int DELETE = 1;
    private static final int KEEP = 1;
    private Coordinate[] inputLine;
    private double distanceTol;
    private byte[] isDeleted;
    private int angleOrientation = 1;
    private static final int NUM_PTS_TO_CHECK = 10;

    public static Coordinate[] simplify(Coordinate[] inputLine, double distanceTol) {
        BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
        return simp.simplify(distanceTol);
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.abs(distanceTol);
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new byte[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index = 1;
        int maxIndex = this.inputLine.length - 1;
        int midIndex = this.findNextNonDeletedIndex(index);
        int lastIndex = this.findNextNonDeletedIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine.length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index, midIndex, lastIndex, this.distanceTol)) {
                this.isDeleted[midIndex] = 1;
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.findNextNonDeletedIndex(index);
            lastIndex = this.findNextNonDeletedIndex(midIndex);
        }
        return isChanged;
    }

    private int findNextNonDeletedIndex(int index) {
        int next = index + 1;
        while (next < this.inputLine.length && this.isDeleted[next] == 1) {
            ++next;
        }
        return next;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        int i = 0;
        while (i < this.inputLine.length) {
            if (this.isDeleted[i] != 1) {
                coordList.add(this.inputLine[i]);
            }
            ++i;
        }
        return coordList.toCoordinateArray();
    }

    private boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p0 = this.inputLine[i0];
        Coordinate p1 = this.inputLine[i1];
        Coordinate p2 = this.inputLine[i2];
        if (!this.isConcave(p0, p1, p2)) {
            return false;
        }
        if (!this.isShallow(p0, p1, p2, distanceTol)) {
            return false;
        }
        return this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private boolean isShallowConcavity(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        boolean isAngleToSimplify;
        int orientation = CGAlgorithms.computeOrientation(p0, p1, p2);
        boolean bl = isAngleToSimplify = orientation == this.angleOrientation;
        if (!isAngleToSimplify) {
            return false;
        }
        double dist = CGAlgorithms.distancePointLine(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / 10;
        if (inc <= 0) {
            inc = 1;
        }
        int i = i0;
        while (i < i2) {
            if (!this.isShallow(p0, p2, this.inputLine[i], distanceTol)) {
                return false;
            }
            i += inc;
        }
        return true;
    }

    private boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = CGAlgorithms.distancePointLine(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = CGAlgorithms.computeOrientation(p0, p1, p2);
        boolean isConcave = orientation == this.angleOrientation;
        return isConcave;
    }
}

