/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.id;

import org.geotools.factory.Hints;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.id.IdIndexKeySpace;
import org.locationtech.geomesa.index.strategies.IdFilterStrategy$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class IdIndexKeySpace$class {
    public static boolean supports(IdIndexKeySpace $this, SimpleFeatureType sft) {
        return true;
    }

    public static int indexKeyByteLength(IdIndexKeySpace $this) {
        return 0;
    }

    public static Function1 toIndexKey(IdIndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Function1<String, byte[]> function1 = GeoMesaFeatureIndex$.MODULE$.idToBytes(sft);
        return new Serializable($this, function1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdIndexKeySpace $outer;
            private final Function1 eta$0$1$1;

            public final Seq<byte[]> apply(SimpleFeature feature) {
                return IdIndexKeySpace$class.org$locationtech$geomesa$index$index$id$IdIndexKeySpace$$toBytesKey(this.$outer, this.eta$0$1$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(IdIndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdIndexKeySpace $outer;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                return IdIndexKeySpace$class.org$locationtech$geomesa$index$index$id$IdIndexKeySpace$$getIdAsBytes(this.$outer, prefix, feature, suffix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static Set getIndexValues(IdIndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        Set<String> identifiers = IdFilterStrategy$.MODULE$.intersectIdFilters(filter2);
        explain.apply((Function0<String>)new Serializable($this, identifiers){
            public static final long serialVersionUID = 0L;
            private final Set identifiers$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracted ID filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifiers$1.mkString(", ")}));
            }
            {
                this.identifiers$1 = identifiers$1;
            }
        });
        Function1<String, byte[]> serializer = GeoMesaFeatureIndex$.MODULE$.idToBytes(sft);
        return (Set)identifiers.map((Function1)new Serializable($this, serializer){
            public static final long serialVersionUID = 0L;
            private final Function1 serializer$1;

            public final byte[] apply(String v1) {
                return (byte[])this.serializer$1.apply((Object)v1);
            }
            {
                this.serializer$1 = serializer$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public static Iterator getRanges(IdIndexKeySpace $this, Set values, int multiplier) {
        return values.iterator().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.SingleRowRange<byte[]> apply(byte[] row) {
                return new IndexKeySpace.SingleRowRange<byte[]>(row);
            }
        });
    }

    public static Iterator getRangeBytes(IdIndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return prefixes.isEmpty() ? ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.ByteRange apply(IndexKeySpace.ScanRange<byte[]> x0$1) {
                IndexKeySpace.ScanRange<byte[]> scanRange = x0$1;
                if (scanRange instanceof IndexKeySpace.SingleRowRange) {
                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                    byte[] row = (byte[])singleRowRange.row();
                    IndexKeySpace.SingleRowByteRange singleRowByteRange = new IndexKeySpace.SingleRowByteRange(row);
                    return singleRowByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(IndexKeySpace.ScanRange<byte[]> x0$2) {
                IndexKeySpace.ScanRange<byte[]> scanRange = x0$2;
                if (scanRange instanceof IndexKeySpace.SingleRowRange) {
                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                    byte[] row = (byte[])singleRowRange.row();
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final byte[] row$1;

                        public final IndexKeySpace.SingleRowByteRange apply(byte[] p) {
                            return new IndexKeySpace.SingleRowByteRange(ByteArrays$.MODULE$.concat(p, this.row$1));
                        }
                        {
                            this.row$1 = row$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    public static boolean useFullFilter(IdIndexKeySpace $this, Option values, Option config, Hints hints) {
        return false;
    }

    public static Seq org$locationtech$geomesa$index$index$id$IdIndexKeySpace$$toBytesKey(IdIndexKeySpace $this, Function1 toBytes, SimpleFeature feature) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])toBytes.apply((Object)feature.getID())}));
    }

    public static Seq org$locationtech$geomesa$index$index$id$IdIndexKeySpace$$getIdAsBytes(IdIndexKeySpace $this, Seq prefix, SimpleFeature feature, byte[] suffix) {
        int length = BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte[] x$1) {
                return x$1.length;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + suffix.length;
        byte[] result = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        prefix.foreach((Function1)new Serializable($this, result, i){
            public static final long serialVersionUID = 0L;
            private final byte[] result$1;
            private final IntRef i$1;

            public final void apply(byte[] p) {
                System.arraycopy(p, 0, this.result$1, this.i$1.elem, p.length);
                this.i$1.elem += p.length;
            }
            {
                this.result$1 = result$1;
                this.i$1 = i$1;
            }
        });
        System.arraycopy(suffix, 0, result, i.elem, suffix.length);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{result}));
    }

    public static void $init$(IdIndexKeySpace $this) {
    }
}

